# 工程名称：CddI2c_Master_Slave_Demo_YTM32B1HA0

---
## 功能描述

**Eeprom_Write_Read_Test**

- I2C0 向 EEPROM 传输数据。
- I2C0 从 EEPROM 读取数据。
- 比较 I2C0 发送的数据和接收的数据是否相同。
- 当系统中启用缓存和DMA时，在从目标缓冲区读取数据之前应使缓存失效。在将数据写入源缓冲区之后应刷新缓存。缓存操作使用SCB_InvalidateDCache_by_Addr和SCB_CleanDCache_by_Addr函数执行。当缓冲区位于内存的非缓存区域时，不需要进行缓存操作。因此，有两种方法确保数据一致性：
  - 方法1：使用可缓存缓冲区，并在DMA传输前后执行缓存操作。
  - 方法2：使用非缓存缓冲区，无需执行缓存操作。

**I2c1_Master_I2c2_Slave_Test**:
- 此示例演示了主设备（I2C1）和从设备（I2C2）之间的I2C通信。代码展示了在I2C通信协议下主设备和从设备之间的异步和同步数据传输。该代码的目的是建立一个用于测试目的的功能性I2C通信链路。
- I2C初始化后，I2C1作为主设备向从设备（I2C2）传输数据。
- 数据验证：主设备发送 - 从设备接收。
- I2C1作为主设备从从设备（I2C2）接收数据。
- 数据验证：主设备接收 - 从设备发送。

<p style="text-align: center;"><strong>Note</strong></p>

- 由于 I2c1_Master_I2c2_Slave_Test 的 SDA 和 SCL 上缺少外部上拉电阻，因此在通信过程中可能会出现不稳定。但这是正常现象，不会影响 I2C 应用的参考。

- 波特率 = 频率 / (((MCLKCFG[LOW] + MCLKCFG[High] + 2 + ROUNDDOWN((2 + MFLTCFG[FLTSCL] + SCL_RISETIME) / 2^DIV)) * 2^DIV)).
- 由于 SCL_RISETIME 与外设/外部电路的电气特性有关，YtTools 计算中使用的默认值为 0.0，为了提高波特率的准确度，请根据实际情况填写。

---

## 硬件需求
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **调试器**： J-Link HW v9 或更高版本，安装了 YUNTU YTM32B1HA01 补丁（支持包）。

---

## 软件需求

+ **配置和代码生成工具**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 或更高版本
+ **编译器工具链**
  + **GCC**     : GNU GCC v10.3 或更高版本
  + **Keil/MDK**: ARM Keil/MDK v5.36 或更高版本
  + **IAR**     : IAR v8.40 或更高版本
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 或更高版本（需要 C/C++ 支持，GNU 工具链，CMake v3.25，ninja，Cortex-Debug 扩展安装）
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 或更高版本，需要安装 YUNTU YTM32B1HA01 补丁（支持包）。
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 或更高版本。

    ***注意***:  需要安装 **YTM32B1HA0** 补丁，补丁可通过 **YCT** 工具或联系 ***云途 销售/FAE 团队***获取.

---

## 操作步骤

+ ***步骤1***：参考I2C硬件连接图，通过导线连接 I2C1 和 I2C2 总线的SCL和SDA端口。
+ ***步骤2***：使用 YCT 工具打开示例的YCT工程文件（**工程名称：CddI2c_Master_Slave_Demo_YTM32B1HA0.yct**），根据您的需求配置工具链（默认使用 VS Code + GCC）。
+ ***步骤3***：生成代码，如果需要，您可以更改配置（以适应您自己的硬件设计），如果这样做，请确保所有修改都正确无误，并且在生成代码之前没有错误存在。
+ ***步骤4***：根据您的配置，使用相应的工具（VS Code/IAR/Keil IDE）打开生成的工程。
+ ***步骤5***：编译生成的工程，打开 EVB 电源并通过可用的调试器（如 J-Link 调试探针）将编译后好的可执行文件下载到 EVB。
+ ***步骤6***：调试、运行示例代码。

### I2C 硬件连接图

**I2C_1**

|  Function  |  MCU Pin  | EVB pin header|  
| ---- | ------- | ------ |
|  SDA  |  PTB20  |  P3_2 ：45 |
|  SCL  |  PTB21  |  P3_1 ：46 |

**I2C_2**

|  Function  |  MCU Pin  | EVB pin header|
| ---- | ------- | ------ |
|  SDA  |  PTA06  |  P6_7 ：104 |
|  SCL  |  PTA07  |  P5_7 ：102 |

---