# CddI2c Example Code

## Project Name：CddI2c_Master_Slave_Demo_YTM32B1HA0
---
## Function description

**Eeprom_Write_Read_Test**:
- I2C0 transmit data to eeprom.
- I2C0 read data from eeprom.
- Compare the I2C0 tx data and rx data the same or not.

+ When cache and DMA are enabled in the system, the cache should be invalidated before the data is read from the destination buffer. The cache should be flushed after the data is written to the source buffer. The cache operations are performed using the `SCB_InvalidateDCache_by_Addr` and `SCB_CleanDCache_by_Addr` functions. The cache operations are not required, when the buffer is placed in the non-cache-able region of the memory.
+ Therefor, there have two ways to ensures the data consistency:
  + **Method1**: Using the cache-able buffer, and perform the cache operations before and after the DMA transfer.
  + **Method2**: Using the non-cache-able buffer, and no need to perform the cache operations.

**I2c1_Master_I2c2_Slave_Test**:
This demo demonstrates I2C communication between a master device (I2C1) and a slave device (I2C2). The code showcases asynchronous and synchronous data transfers between the master and slave devices over the I2C communication protocol. The purpose of this code is to establish a functional I2C communication link for testing purposes.
 - After I2c init, I2C1 as master transmit data to Slave(I2C_2).
 - Data verification Master send - Slave receive.
 - I2C1 as master receive data from Slave(I2C_2)
 - Data verification Master receive - Slave send.

<p style="text-align: center;"><strong>Note</strong></p>

- Due to the absence of external pull-up resistors on SDA and SCL of I2c1_Master_I2c2_Slave_Test, there may be instability during communication. However, this is a normal occurrence and does not impact the reference for I2C applications.
- The bitrate = Frequency / (((MCLKCFG[LOW] + MCLKCFG[High] + 2 + ROUNDDOWN((2 + MFLTCFG[FLTSCL] - SCL_RISETIME) / 2^DIV)) * 2^DIV)).
- Since SCL_RISETIME is related to the electrical characteristics of the peripheral/external circuit, the default value used in the calculation of YtTools is 0.0, to improve the accuracy of the baud rate, please fill in according to the actual situation.

## HW requirement
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **Debugger**: J-Link HW v9 or later with YUNTU YTM32B1HA01 patch(support package) installed.

---

## SW requirement

+ **Config & Code Generation Tool**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 or later version
+ **Compiler Toolchain**
  + **GCC**     : GNU GCC v10.3 or later version
  + **Keil/MDK**: ARM Keil/MDK v5.36 or later version
  + **IAR**     : IAR v8.40 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 or later version, YUNTU YTM32B1HA01 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***:  **YTM32B1HA0** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---

## Setup

+ ***Step1***: Refer to the ***I2C HW connection diagram***, connect the I2C's SCL and SDA port of each I2C bus.
+ ***Step2***: Open the **CddI2c_Master_Slave_Demo_YTM32B1HA0.yct** with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step3***：Generate the codes， you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step4***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step5***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-Link debugger probe.
+ ***Step6***: At last, enjoy the demo example.

### I2C HW connection diagram
**I2C_1**

|  Function  |  MCU Pin  | EVB pin header|  
| ---- | ------- | ------ |
|  SDA  |  PTB20  |  P3_2 ：45 |
|  SCL  |  PTB21  |  P3_1 ：46 |

**I2C_2**

|  Function  |  MCU Pin  | EVB pin header|
| ---- | ------- | ------ |
|  SDA  |  PTA06  |  P6_7 ：104 |
|  SCL  |  PTA07  |  P5_7 ：102 |

---