/*
* @file    CddI2c_Lld_Reg.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CddI2c_Lld_Reg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.3.2
*
*   (c) Copyright 2020-2024 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CDDI2C_LLD_REG_H
#define CDDI2C_LLD_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "pSIP_I2c.h"

#if defined(CPU_YTM32B1ME0)
#include "YTM32B1ME0_features.h"
#elif defined(CPU_YTM32B1MD1)
#include "YTM32B1MD1_features.h"
#elif defined(CPU_YTM32B1HA0)
#include "YTM32B1HA0_features.h"
#elif defined(CPU_YTM32B1MC0)
#include "YTM32B1MC0_features.h"
#else
#error "Wrong MCU part number or no MCU part number selected!"
#endif

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CDDI2C_LLD_REG_VENDOR_ID                      (180)
#define CDDI2C_LLD_REG_AR_RELEASE_MAJOR_VERSION       (4)
#define CDDI2C_LLD_REG_AR_RELEASE_MINOR_VERSION       (4)
#define CDDI2C_LLD_REG_AR_RELEASE_REVISION_VERSION    (0)
#define CDDI2C_LLD_REG_SW_MAJOR_VERSION               (1)
#define CDDI2C_LLD_REG_SW_MINOR_VERSION               (3)
#define CDDI2C_LLD_REG_SW_PATCH_VERSION               (2)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file CddI2c_Lld_Reg.h */

