# Fls Example Code

## Project Name：Fls_Demo


---


## Function description

This project demonstrates the operation of reading, erasing, and writing in the NVR region using the MCAL Fls module of YTM32B1ME0 in conjunction with the Fls_NvrDriver.

- **Fls**: 
  - Demonstrate the erase operation of the CUR NVR.
  - Demonstrate how to write data to a specified position in the CUR NVR to modify the initial value of the FLASH write protection register EFM ADDR_PROT.
  - Demonstrate how to write data to a specified position in the CUR NVR to disable JLINK/SWD debug functionality.
  - Demonstrate read and write operations in the OPT NVR.
  - Demonstrate erase and write operations in the HCU NVR;


After reset, the following operations can be performed in this demo:

+ After the MCU completes RAM initialization and before entering the Main function, setting Fls_CurNvrEraseEn to 1 allows testing of the CUR NVR erase.
+ During program execution, setting Fls_CurNvrFlsProtectEn to 1 allows testing of the operation to set the initial value of the EFM ADDR_PROT. In this example, after performing this operation and resetting, PFLASH0 will be write-protected, and program PFLASH0 will fail. To download the program again, CUR NVR must be erased by setting Fls_CurNvrEraseEn to 1.
+ During program execution, pressing SW2 on the EVB will disable the JLINK/SWD debug function, and pressing SW3 will re-enable it.
+ During program execution, setting Fls_OptNvrWriteEn to 1 allows testing of the OPT NVR write function. Since OPT NVR cannot be erased, please test with caution.
+ During program execution, setting Fls_OptNvrReadEn to 1 allows testing of the OPT NVR read function.
+ During program execution, setting Fls_HcuNvrWriteEn to 1 allows testing of the HCU NVR write operation.
+ During program execution, setting Fls_HcuNvrEraseEn to 1 allows testing of the HCU NVR erase operation.

**Notice**
+ During testing, the default cus key is used for all operations. If the cus key has been modified, please pass the correct key.
+ The example demonstrates enabling and disabling debug functionality using SW2/SW3, so please ensure that J29 PIN1 is connected to PIN2 and PIN3 is connected to PIN4.
  
---


## HW requirement
+ **EVB**: YTM32B1ME0-Q144-EVB-REVB
+ **Debugger**: J-Link HW v9 or later with YUNTU YTM32B1ME0 patch(support package) installed.

---

## SW requirement

+ **Config & Code Generation Tool**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 or later version
+ **Compiler Toolchain**
  + **GCC**     : GNU GCC v10.3 or later version
  + **Keil/MDK**: ARM Keil/MDK v5.36 or later version
  + **IAR**     : IAR v8.40 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 or later version, YUNTU YTM32B1ME0 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***:  **YTM32B1ME0** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---

## Setup

+ ***Step1***: Open the `Fls_ME0NvrDemo.yct` with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***：Generate the codes， you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-Link debugger probe.
+ ***Step5***: At last, enjoy the demo example.


---