/*
* @file    SchM_Dio.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_Dio
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.2.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_DIO_H
#define SCHM_DIO_H

/**
*   @file    SchM_Dio.h
*
*   @addtogroup SCHM_DIO_MODULE
*   @{
*/

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define SCHM_DIO_VENDOR_ID             		  (180)
#define SCHM_DIO_AR_REL_MAJOR_VER              (4)
#define SCHM_DIO_AR_REL_MINOR_VER              (4)
#define SCHM_DIO_AR_REL_REVISION_VER           (0)
#define SCHM_DIO_SW_MAJOR_VER                  (2)
#define SCHM_DIO_SW_MINOR_VER                  (2)
#define SCHM_DIO_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/

/* Number of cores id */
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES         (uint8)(1U)
#endif /* NUMBER_OF_CORES */

/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/

extern void SchM_Enter_Dio_DIO_EXCLUSIVE_AREA_00(void);
extern void SchM_Exit_Dio_DIO_EXCLUSIVE_AREA_00(void);

#ifdef __cplusplus
}
#endif

/** @} */

#endif /* End of file SchM_Dio.h */

