# Fls示例代码

## 工程名称：Fls_Demo

---
## 功能描述

本示例用于演示云途YTM32B1MC0x系列 MCAL Fls 模块配合Fls_NvrDrver实现NVR区域的读，擦，写操作:

- **Fls**: 
  - 演示CUR NVR区域擦除操作；
  - 演示如何向CUR NVR指定位置写入数据修改FLASH写保护寄存器EFM ADDR_PROT的初始值；
  - 演示如何向CUR NVR指定位置写入数据关闭JLINK/SWD debug功能；
  - 演示OPT NVR区域读、写操作；
  - 演示HCU NVR区域擦、写操作；

复位后，本示例可执行如下操作:
+ MCU完成Ram初始化后，进入Main函数前，将Fls_CurNvrEraseEn置1，可测试CUR NVR擦除功能；
+ 程序运行过程中，将Fls_CurNvrFlsProtectEn置1，可测试设置EFM ADDR_PROT初始值操作，示例中执行该操作并复位后PFLASH0将被写保护，此时再向PFLASH0中烧写程序将失败，需通过Fls_CurNvrEraseEn置1，擦除CUR NVR才能再次下载程序；mo
+ 程序运行过程中，按下EVB上的SW2, JLINK/SWD debug功能将被关闭，按下SW3，则debug功能重新启用；
+ 程序运行过程中，将Fls_OptNvrWriteEn置1可测试OPT NVR写入操作，OPT NVR不可擦除，故请慎重测试； 
+ 程序运行过程中，将Fls_OptNvrReadEn置1可测试OPT NVR读取操作；
+ 程序运行过程中，将Fls_HcuNvrWriteEn置1可测试HCU NVR写入操作；
+ 程序运行过程中，将Fls_HcuNvrEraseEn置1可测试HCU NVR擦除操作;


**注意**
+ 测试过程中均使用默认的cus key进行操作，若修改了cus key，请传入正确的key；
+ 示例中演示debug禁用、使能时需使用SW2/SW3, 故请确认J13 PIN1与PIN2连接，PIN3与PIN4连接；

---


## 硬件需求
+ **EVB**: YTM32B1MC0-EVB-Q64-Rev.A
+ **调试器**： J-Link HW v9 或更高版本，安装了 YUNTU YTM32B1MC0 补丁（支持包）。

---

## 软件需求

+ **配置和代码生成工具**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 或更高版本
+ **编译器工具链**
  + **GCC**     : GNU GCC v10.3 或更高版本
  + **Keil/MDK**: ARM Keil/MDK v5.36 或更高版本
  + **IAR**     : IAR v8.40 或更高版本
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 或更高版本（需要 C/C++ 支持，GNU 工具链，CMake v3.25，ninja，Cortex-Debug 扩展安装）
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 或更高版本，需要安装 YUNTU YTM32B1MC0 补丁（支持包）。
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 或更高版本。

    ***注意***: * 需要安装 **YTM32B1MC0** 补丁，补丁可通过 **YCT** 工具或联系 ***云途 销售/FAE 团队***获取.

---

## 操作步骤

+ ***步骤1***：使用 YCT 工具打开示例的配置工程文件（`Fls_MC0NvrDemo.yct`），根据您的需求配置工具链（默认使用 VS Code + GCC）。
+ ***步骤2***：生成代码，如果需要，您可以更改配置（以适应您自己的硬件设计），如果这样做，请确保所有修改都正确无误，并且在生成代码之前没有错误存在。
+ ***步骤3***：根据您的配置，使用相应的工具（VS Code/IAR/Keil IDE）打开生成的工程。
+ ***步骤4***：编译生成的工程，打开 EVB 电源并通过可用的调试器（如 J-Link 调试探针）将编译好的可执行文件下载到 EVB。
+ ***步骤5***：调试、运行示例代码。
  
---