/*
 * Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */


/*! @addtogroup soc_support_YTM32B1MC0*/
/*! @{*/

/*!
 * @file system_YTM32B1MC0.h
 * @brief Device specific configuration file for YTM32B1MC0
 */

#ifndef SYSTEM_YTM32B1MC0_H
#define SYSTEM_YTM32B1MC0_H                        /**< Symbol preventing repeated inclusion */

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/******************************************************************************
 * CPU Settings.
 *****************************************************************************/
/* Mpu enable*/
#ifndef DISABLE_MPU
#define ENABLE_MPU      1
#else
#define ENABLE_MPU      0
#endif

/* Watchdog disable */
#ifndef ENABLE_WDOG
#define DISABLE_WDOG    1
#else
#define DISABLE_WDOG    0
#endif

/* Value of the external crystal or oscillator clock frequency in Hz */
#ifndef CPU_XTAL_CLK_HZ
#define CPU_XTAL_CLK_HZ         8000000U
#endif

/* Value of the fast internal oscillator clock frequency in Hz  */
#ifndef CPU_INT_FAST_CLK_HZ
#define CPU_INT_FAST_CLK_HZ     48000000U
#endif

/* Default System clock value */
#ifndef DEFAULT_SYSTEM_CLOCK
#define DEFAULT_SYSTEM_CLOCK    48000000U
#endif

/**
 * @brief System clock frequency (core clock)
 *
 * The system clock frequency supplied to the SysTick timer and the processor
 * core clock. This variable can be used by the user application to setup the
 * SysTick timer or configure other parameters. It may also be used by debugger to
 * query the frequency of the debug timer or configure the trace clock speed
 * SystemCoreClock is initialized with a correct predefined value.
 */
extern uint32 SystemCoreClock;

/**
 * @brief Setup the SoC.
 *
 * This function disables the watchdog.
 * if the corresponding feature macro is enabled.
 * SystemInit is called from startup_device file.
 */
void SystemInit(void);

/**
 * @brief Updates the SystemCoreClock variable.
 *
 * It must be called whenever the core clock is changed during program
 * execution. SystemCoreClockUpdate() evaluates the clock register settings and calculates
 * the current core clock.
 * This function must be called when user does not want to use clock manager component.
 * If clock manager is used, the CLOCK_SYS_GetFreq function must be used with CORE_CLOCK
 * parameter.
 *
 */
void SystemCoreClockUpdate(void);

#ifdef __cplusplus
}
#endif

/*! @}*/
#endif  /* #ifndef SYSTEM_YTM32B1MC0_H */
