/*
 * Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

/**
 * @page misra_violations MISRA-C:2012 violations list
 *  NONE
 */

/* PRQA S 3387 EOF */

#include "Compiler.h"
#include "Std_Types.h"
#include "system_YTM32B1MC0.h"
#include "YTM32B1MC0_features.h"

#if defined(UNIT_TEST)
#include "inc/fakeWDG.h"
#include "inc/fakeEFM.h"
#else
#include "YTM32B1Mx_CM33.h"
#include "pSIP_Wdg.h"
#include "pSIP_Efm.h"
#endif

/* ----------------------------------------------------------------------------
   -- Core clock
   ---------------------------------------------------------------------------- */

#define PLATFORM_START_SEC_CODE
#include "Platform_MemMap.h"

/**
 * @brief System clock frequency (core clock)
 *
 * The system clock frequency supplied to the SysTick timer and the processor
 * core clock. This variable can be used by the user application to setup the
 * SysTick timer or configure other parameters. It may also be used by debugger to
 * query the frequency of the debug timer or configure the trace clock speed
 * SystemCoreClock is initialized with a correct predefined value.
 */
uint32 SystemCoreClock = DEFAULT_SYSTEM_CLOCK;

/*FUNCTION**********************************************************************
 *
 * Function Name : SystemInit
 * Description   : This function disables the watchdog, enables FPU
 * and the power mode protection if the corresponding feature macro
 * is enabled. SystemInit is called from startup_device file.
 *
 * Implements    : SystemInit_Activity
 *END**************************************************************************/
PLATFORM_FUNC void SystemInit(void)
{
    /**************************************************************************/
    /* EFM CONTRROL */
    /**************************************************************************/
    EFM->CTRL |= EFM_CTRL_LPEN_MASK | EFM_CTRL_PREFETCH_EN_MASK;
    /**************************************************************************/
    /* WDOG DISABLE*/
    /**************************************************************************/
#if DISABLE_WDOG
    WDG->SVCR = 0xB631;
    WDG->SVCR = 0xC278;
    WDG->CR &= ~WDG_CR_EN_MASK;
#endif
}

/*FUNCTION**********************************************************************
 *
 * Function Name : SystemCoreClockUpdate
 * Description   : This function must be called whenever the core clock is changed
 * during program execution. It evaluates the clock register settings and calculates
 * the current core clock.
 *
 * Implements    : SystemCoreClockUpdate_Activity
 *END**************************************************************************/
PLATFORM_FUNC void SystemCoreClockUpdate(void)
{
    SystemCoreClock = 80000000U;
}

#define PLATFORM_STOP_SEC_CODE
#include "Platform_MemMap.h"

/*******************************************************************************
 * EOF
 ******************************************************************************/
