
/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file System_Lld_Cfg.h
 * @brief 
 * 
 */


#ifndef SYSTEM_LLD_CFG_H_
#define SYSTEM_LLD_CFG_H_

/*==================================================================================================
                                         INCLUDE FILES
==================================================================================================*/
#include "System_Lld_CfgDefines.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PLATFORM_SYSTEM_LLD_CFG_TYPES_VENDOR_ID                    (180)
#define PLATFORM_SYSTEM_LLD_CFG_SW_MAJOR_VERSION                   (1)
#define PLATFORM_SYSTEM_LLD_CFG_SW_MINOR_VERSION                   (3)
#define PLATFORM_SYSTEM_LLD_CFG_SW_PATCH_VERSION                   (2)

/*==================================================================================================
                                      FILE VERSION CHECKS
==================================================================================================*/
/* Check if current file and System_Lld_CfgDefines header file are of the same vendor */
#if (PLATFORM_SYSTEM_LLD_CFG_TYPES_VENDOR_ID != PLATFORM_SYSTEM_LLD_CFG_DEFINES_TYPES_VENDOR_ID)
    #error "System_Lld_Cfg.h and System_Lld_CfgDefines.h have different vendor ids"
#endif

/* Check if current file and System_Lld_CfgDefines header file are of the same Software version */
#if ((PLATFORM_SYSTEM_LLD_CFG_SW_MAJOR_VERSION != PLATFORM_SYSTEM_LLD_CFG_DEFINES_SW_MAJOR_VERSION) || \
     (PLATFORM_SYSTEM_LLD_CFG_SW_MINOR_VERSION != PLATFORM_SYSTEM_LLD_CFG_DEFINES_SW_MINOR_VERSION) || \
     (PLATFORM_SYSTEM_LLD_CFG_SW_PATCH_VERSION != PLATFORM_SYSTEM_LLD_CFG_DEFINES_SW_PATCH_VERSION) \
    )
    #error "Software Version Numbers of System_Lld_Cfg.h and System_Lld_CfgDefines.h are different"
#endif
/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/

/* Development error detection */
#define SYSTEM_LLD_DEV_ERROR_DETECT         (STD_ON)

/* User mode support */
#define SYSTEM_LLD_ENABLE_USER_MODE_SUPPORT (STD_OFF)

#endif /* SYSTEM_LLD_CFG_H_ */

