/*
* @file    Fls_Nvr.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Fls_Nvr
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V0.8.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef FLS_NVR_H
#define FLS_NVR_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "MemIf_Types.h"
#include "Fls_Types.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_NVR_VENDOR_ID             		  (180)
#define FLS_NVR_AR_REL_MAJOR_VER              (4)
#define FLS_NVR_AR_REL_MINOR_VER              (4)
#define FLS_NVR_AR_REL_REVISION_VER           (0)
#define FLS_NVR_SW_MAJOR_VER                  (0)
#define FLS_NVR_SW_MINOR_VER                  (8)
#define FLS_NVR_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
#if defined (CPU_YTM32B1HA0)||defined (CPU_YTM32B1MC0)||defined (CPU_YTM32B1ME0)
#define FLS_CUS_NVR_VALID              (STD_ON)
#define FLS_HCU_NVR_VALID              (STD_ON)
#define FLS_OPT_NVR_VALID              (STD_ON)
#elif defined (CPU_YTM32B1MD1)
#define FLS_CUS_NVR_VALID              (STD_ON)
#define FLS_HCU_NVR_VALID              (STD_OFF)
#define FLS_OPT_NVR_VALID              (STD_ON)
#else
#error "Wrong MCU part number or no MCU part number selected!"
#endif

#if defined (CPU_YTM32B1HA0)

#if(FLS_OPT_NVR_VALID == STD_ON)
/*OPT_NVR start address*/
#define FLS_OPT_NVR_BASE_ADDR           (0x10020000U)
/*OPT_NVR total size */
#define FLS_OPT_NVR_LENGTH              (0x00004000U)
/*OPT_NVR sector size */
#define FLS_OPT_NVR_SECTOR_SIZE         (0x00000800U)
/*OPT_NVR write page size */
#define FLS_OPT_NVR_PAGE_SIZE           (0x00000020U)
/*OPT_NVR write command */
#define FLS_OPT_NVR_WRITE_CMD           (0x02U)
#endif

#if(FLS_CUS_NVR_VALID == STD_ON)
/*CUS_NVR start address*/
#define FLS_CUS_NVR_BASE_ADDR          (0x10000000U)
/*CUS_NVR total size */
#define FLS_CUS_NVR_LENGTH             (0x00000800U)
/*CUS_NVR sector size */
#define FLS_CUS_NVR_SECTOR_SIZE        (0x00000800U)
/*CUS_NVR write page size */
#define FLS_CUS_NVR_PAGE_SIZE          (0x00000020U)
/*CUS_NVR write command */
#define FLS_CUS_NVR_WRITE_CMD          (0x02U)
/*CUS_NVR erase command */
#define FLS_CUS_NVR_ERASE_CMD          (0x10U)
#endif

#if(FLS_HCU_NVR_VALID==STD_ON)
/*HCU_NVR start address*/
#define FLS_HCU_NVR_BASE_ADDR          (0x10000800U)
/*HCU_NVR total size */
#define FLS_HCU_NVR_LENGTH             (0x00001000U)
/*HCU_NVR sector size */
#define FLS_HCU_NVR_SECTOR_SIZE        (0x00000800U)
/*HCU_NVR write page size */
#define FLS_HCU_NVR_PAGE_SIZE          (0x00000020U)
/*HCU_NVR write command */
#define FLS_HCU_NVR_WRITE_CMD          (0x02U)
/*HCU_NVR erase command */
#define FLS_HCU_NVR_ERASE_CMD          (0x10U)
#endif

#elif defined (CPU_YTM32B1MC0)

#if(FLS_OPT_NVR_VALID == STD_ON)
/*OPT_NVR start address*/
#define FLS_OPT_NVR_BASE_ADDR           (0x10003A00U)
/*OPT_NVR total size */
#define FLS_OPT_NVR_LENGTH              (0x00000200U)
/*OPT_NVR sector size */
#define FLS_OPT_NVR_SECTOR_SIZE         (0x00000200U)
/*OPT_NVR write page size */
#define FLS_OPT_NVR_PAGE_SIZE           (0x00000008U)
/*OPT_NVR write command */
#define FLS_OPT_NVR_WRITE_CMD           (0x01U)
#endif

#if(FLS_CUS_NVR_VALID == STD_ON)
/*CUS_NVR start address*/
#define FLS_CUS_NVR_BASE_ADDR          (0x10013800U)
/*CUS_NVR total size */
#define FLS_CUS_NVR_LENGTH             (0x00000200U)
/*CUS_NVR sector size */
#define FLS_CUS_NVR_SECTOR_SIZE        (0x00000200U)
/*CUS_NVR write page size */
#define FLS_CUS_NVR_PAGE_SIZE          (0x00000008U)
/*CUS_NVR write command */
#define FLS_CUS_NVR_WRITE_CMD          (0x01U)
/*CUS_NVR erase command */
#define FLS_CUS_NVR_ERASE_CMD          (0x10U)
#endif

#if(FLS_HCU_NVR_VALID==STD_ON)
/*HCU_NVR start address*/
#define FLS_HCU_NVR_BASE_ADDR          (0x10003800U)
/*HCU_NVR total size */
#define FLS_HCU_NVR_LENGTH             (0x00000200U)
/*HCU_NVR sector size */
#define FLS_HCU_NVR_SECTOR_SIZE        (0x00000200U)
/*HCU_NVR write page size */
#define FLS_HCU_NVR_PAGE_SIZE          (0x00000008U)
/*HCU_NVR write command */
#define FLS_HCU_NVR_WRITE_CMD          (0x01U)
/*HCU_NVR erase command */
#define FLS_HCU_NVR_ERASE_CMD          (0x10U)
#endif

#elif defined (CPU_YTM32B1ME0)

#if(FLS_OPT_NVR_VALID == STD_ON)
/*OPT_NVR start address*/
#define FLS_OPT_NVR_BASE_ADDR           (0x10010000U)
/*OPT_NVR total size */
#define FLS_OPT_NVR_LENGTH              (0x00000400U)
/*OPT_NVR sector size */
#define FLS_OPT_NVR_SECTOR_SIZE         (0x00000400U)
/*OPT_NVR write page size */
#define FLS_OPT_NVR_PAGE_SIZE           (0x00000008U)
/*OPT_NVR write command */
#define FLS_OPT_NVR_WRITE_CMD           (0x40U)
/*OPT_NVR read command */
#define FLS_OPT_NVR_READ_CMD            (0x42U)
#endif

#if(FLS_CUS_NVR_VALID == STD_ON)
/*CUS_NVR start address*/
#define FLS_CUS_NVR_BASE_ADDR          (0x10030000U)
/*CUS_NVR total size */
#define FLS_CUS_NVR_LENGTH             (0x00000400U)
/*CUS_NVR sector size */
#define FLS_CUS_NVR_SECTOR_SIZE        (0x00000400U)
/*CUS_NVR write page size */
#define FLS_CUS_NVR_PAGE_SIZE          (0x00000008U)
/*CUS_NVR write command */
#define FLS_CUS_NVR_WRITE_CMD          (0x40U)
/*CUS_NVR read command */
#define FLS_CUS_NVR_READ_CMD           (0x42U)
/*CUS_NVR erase command */
#define FLS_CUS_NVR_ERASE_CMD          (0x41U)
#endif

#if(FLS_HCU_NVR_VALID==STD_ON)
/*HCU_NVR start address*/
#define FLS_HCU_NVR_BASE_ADDR          (0x10000000U)
/*HCU_NVR total size */
#define FLS_HCU_NVR_LENGTH             (0x00000400U)
/*HCU_NVR sector size */
#define FLS_HCU_NVR_SECTOR_SIZE        (0x00000400U)
/*HCU_NVR write page size */
#define FLS_HCU_NVR_PAGE_SIZE          (0x00000008U)
/*HCU_NVR write command */
#define FLS_HCU_NVR_WRITE_CMD          (0x40U)
/*HCU_NVR erase command */
#define FLS_HCU_NVR_ERASE_CMD          (0x41U)
#endif

#elif defined (CPU_YTM32B1MD1)

#if(FLS_OPT_NVR_VALID == STD_ON)
/*OPT_NVR start address*/
#define FLS_OPT_NVR_BASE_ADDR           (0x10000100U)
/*OPT_NVR total size */
#define FLS_OPT_NVR_LENGTH              (0x00000100U)
/*OPT_NVR sector size */
#define FLS_OPT_NVR_SECTOR_SIZE         (0x00000100U)
/*OPT_NVR write page size */
#define FLS_OPT_NVR_PAGE_SIZE           (0x00000008U)
/*OPT_NVR write command */
#define FLS_OPT_NVR_WRITE_CMD           (0x40U)
/*OPT_NVR read command */
#define FLS_OPT_NVR_READ_CMD            (0x42U)
#endif

#if(FLS_CUS_NVR_VALID == STD_ON)
/*CUS_NVR start address*/
#define FLS_CUS_NVR_BASE_ADDR          (0x10000400U)
/*CUS_NVR total size */
#define FLS_CUS_NVR_LENGTH             (0x00000200U)
/*CUS_NVR sector size */
#define FLS_CUS_NVR_SECTOR_SIZE        (0x00000200U)
/*CUS_NVR write page size */
#define FLS_CUS_NVR_PAGE_SIZE          (0x00000008U)
/*CUS_NVR write command */
#define FLS_CUS_NVR_WRITE_CMD          (0x40U)
/*CUS_NVR read command */
#define FLS_CUS_NVR_READ_CMD           (0x42U)
/*CUS_NVR erase command */
#define FLS_CUS_NVR_ERASE_CMD          (0x41U)
#endif

#if(FLS_HCU_NVR_VALID==STD_ON)
/*HCU_NVR start address*/
#define FLS_HCU_NVR_BASE_ADDR          (0x10000200U)
/*HCU_NVR total size */
#define FLS_HCU_NVR_LENGTH             (0x00000200U)
/*HCU_NVR sector size */
#define FLS_HCU_NVR_SECTOR_SIZE        (0x00000200U)
/*HCU_NVR write page size */
#define FLS_HCU_NVR_PAGE_SIZE          (0x00000008U)
/*HCU_NVR write command */
#define FLS_HCU_NVR_WRITE_CMD          (0x40U)
/*HCU_NVR erase command */
#define FLS_HCU_NVR_ERASE_CMD          (0x41U)
#endif

#else
#error "Wrong MCU part number or no MCU part number selected!"
#endif




/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#if (FLS_CUS_NVR_VALID == STD_ON)
extern  Fls_Lld_ReturnType Fls_WriteCusNvr(Fls_AddressType Adress, const uint8 * SourceAddressPtr,Fls_LengthType Length,uint32 CustomerKey);

extern Fls_Lld_ReturnType Fls_EraseCusNvr(uint32 CustomerKey);

extern Fls_Lld_ReturnType Fls_ReadCusNvr(Fls_AddressType Adress, uint8 * DestinationAddressPtr,Fls_LengthType Length,uint32 CustomerKey);
#endif

#if (FLS_OPT_NVR_VALID == STD_ON)
extern Fls_Lld_ReturnType Fls_WriteOptNvr(Fls_AddressType Adress, const uint8 * SourceAddressPtr,Fls_LengthType Length);

extern Fls_Lld_ReturnType Fls_ReadOptNvr(Fls_AddressType Adress, uint8 * DestinationAddressPtr,Fls_LengthType Length);
#endif

#if (FLS_HCU_NVR_VALID == STD_ON)
extern Fls_Lld_ReturnType Fls_WriteHcuNvr(Fls_AddressType Adress, const uint8 * SourceAddressPtr,Fls_LengthType Length);
    
extern Fls_Lld_ReturnType Fls_EraseHcuNvr(Fls_AddressType Adress,Fls_LengthType Length,uint32 CustomerKey);
#endif

#ifdef __cplusplus
}
#endif

#endif /* End of file Fls_Nvr.h */
