cmake_minimum_required(VERSION 3.16)



set(sources
    ${PROJ_DIR}/board/IntCtrl_Lld_Cfg.c
    ${PROJ_DIR}/board/Platform_Cfg.c
    ${PROJ_DIR}/board/Platform_Mld_Cfg.c
    ${PROJ_DIR}/board/Mcu_Cfg.c
    ${PROJ_DIR}/board/Mcu_PBcfg.c
    ${PROJ_DIR}/board/Fls_Cfg.c
    ${PROJ_DIR}/board/Fls_PBcfg.c
    ${PROJ_DIR}/Mcal/Platform/src/exceptions.c
    ${PROJ_DIR}/Mcal/Platform/src/IntCtrl_Lld.c
    ${PROJ_DIR}/Mcal/Platform/src/OsIf.c
    ${PROJ_DIR}/Mcal/Platform/src/Platform.c
    ${PROJ_DIR}/Mcal/Platform/src/Platform_Mld.c
    ${PROJ_DIR}/Mcal/Platform/src/System_Lld.c
    ${PROJ_DIR}/Mcal/Platform/src/Intm_Lld.c
    ${PROJ_DIR}/Mcal/Platform/startup/startup.c
    ${PROJ_DIR}/Mcal/Platform/YTM32B1HA0/startup/system_YTM32B1HA0.c
    ${PROJ_DIR}/Mcal/Platform/YTM32B1HA0/startup/secure_boot_YTM32B1HA0.c
    ${PROJ_DIR}/Mcal/Platform/YTM32B1HA0/startup/gcc/YTM32B1HA0_startup_gcc.S
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Platform.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Mcu.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Fls.c
    ${PROJ_DIR}/Mcal/Det/src/Det.c
    ${PROJ_DIR}/Mcal/Mcu/src/Mcu.c
    ${PROJ_DIR}/Mcal/Mcu/src/Mcu_Lld.c
    ${PROJ_DIR}/Mcal/Mcu/src/Mcu_Lld_Irq.c
    ${PROJ_DIR}/Mcal/Fls/src/Fls.c
    ${PROJ_DIR}/Mcal/Fls/src/Fls_Lld.c
)
set(includes
    ${PROJ_DIR}/board
    ${PROJ_DIR}/Mcal/Platform/inc
    ${PROJ_DIR}/Mcal/Platform/startup
    ${PROJ_DIR}/Mcal/Platform/core
    ${PROJ_DIR}/Mcal/Platform/YTM32B1HA0/feature
    ${PROJ_DIR}/Mcal/Platform/YTM32B1HA0/regmap
    ${PROJ_DIR}/Mcal/Platform/YTM32B1HA0/startup
    ${PROJ_DIR}/Mcal/Rte/inc
    ${PROJ_DIR}/Mcal/Det/inc
    ${PROJ_DIR}/Mcal/Mcu/inc
    ${PROJ_DIR}/Mcal/Fls/inc
    ${PROJ_DIR}/Mcal/MemIf/inc
)


add_library(GENERATED_SDK_TARGET STATIC ${sources})
target_include_directories(GENERATED_SDK_TARGET PUBLIC ${includes})
configcore(GENERATED_SDK_TARGET ${CMAKE_SOURCE_DIR})

target_compile_definitions(GENERATED_SDK_TARGET PUBLIC
    YTM32B1HA0
    CPU_YTM32B1HA0
    START_FROM_FLASH
)
target_compile_options(GENERATED_SDK_TARGET PUBLIC
    -fdiagnostics-color=always
)