
/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file yt_linker.ld
 * @brief 
 * 
 */





















/* MEMORY MAP */
MEMORY
{
    BVT   (RX) : ORIGIN = 0x2000000, LENGTH = 0x800
    IVT   (RX) : ORIGIN = 0x2000800, LENGTH = 1024
    NC_TEXT   (RX) : ORIGIN = 0x2000c00, LENGTH = 0xB400
    TEXT   (RX) : ORIGIN = 0x200c000, LENGTH = 0x1F4000
    FEE   (RX) : ORIGIN = 0x6000000, LENGTH = 0x40000
    IVT_RAM   (RW) : ORIGIN = 0x0, LENGTH = 0x400
    CODE_RAM   (RW) : ORIGIN = 0x400, LENGTH = 0x7C00
    D_RAM   (RW) : ORIGIN = 0x20000000, LENGTH = 0x1F000
    STACK   (RW) : ORIGIN = 0x2001f000, LENGTH = 4096
    NC_RAM   (RW) : ORIGIN = 0x20020000, LENGTH = 0x10000
    RAM   (RW) : ORIGIN = 0x20030000, LENGTH = 0x30000
}
/* SECTIONS */
SECTIONS
{
    .BVT  : {
        
        BVT_start = .;
        . = ALIGN(4);
        bvt_header_region_start = .;
        KEEP(*(.bvt_header))
        bvt_header_region_end = .;
        
        . = ALIGN(4);
        sb_config_group_region_start = .;
        KEEP(*(.sb_config_group))
        sb_config_group_region_end = .;
        
        . = ALIGN(16);
        sb_config_section_region_start = .;
        KEEP(*(.sb_config_section))
        sb_config_section_region_end = .;
        
        . = ALIGN(16);
        sb_cmac_region_start = .;
        KEEP(*(.sb_cmac))
        sb_cmac_region_end = .;
        
        BVT_end = .;
    } > BVT
   
    


    .IVT  : {
        
        IVT_start = .;
        isr_vector_region_start = .;
        KEEP(*(.isr_vector))
        isr_vector_region_end = .;
        
        IVT_end = .;
    } > IVT
   
    


    .NC_TEXT  : {
        
        NC_TEXT_start = .;
        mcal_const_no_cacheable_region_start = .;
        *(.mcal_const_no_cacheable)
        mcal_const_no_cacheable_region_end = .;
        
        NC_TEXT_end = .;
    } > NC_TEXT
   
    


    .TEXT  : {
        
        TEXT_start = .;
        rodata_region_start = .;
        *(.rodata)
        *(.rodata*)
        rodata_region_end = .;
        
        text_region_start = .;
        *(.text)
        *(.text*)
        text_region_end = .;
        
        mcal_text_region_start = .;
        *(.mcal_text)
        mcal_text_region_end = .;
        
        mcal_const_region_start = .;
        *(.mcal_const)
        mcal_const_region_end = .;
        
        mcal_const_cfg_region_start = .;
        *(.mcal_const_cfg)
        mcal_const_cfg_region_end = .;
        
        TEXT_end = .;
    } > TEXT
   
    


    .ARM  : {
        
        ARM_start = .;
        ARM_region_start = .;
        *(.ARM)
        *(.ARM*)
        ARM_region_end = .;
        
        ARM_end = .;
    } > TEXT
   
    


    CODE_RAM_rom_start_not_align = .;
    CODE_RAM_rom_start = CODE_RAM_rom_start_not_align + (CODE_RAM_rom_start_not_align % 4);
   
    CODE_RAM_rom_end = CODE_RAM_rom_start + CODE_RAM_ram_end - CODE_RAM_ram_start;
    


    D_DATA_rom_start_not_align = CODE_RAM_rom_end;
    D_DATA_rom_start = D_DATA_rom_start_not_align + (D_DATA_rom_start_not_align % 4);
   
    D_DATA_rom_end = D_DATA_rom_start + D_DATA_ram_end - D_DATA_ram_start;
    


    NC_DATA_rom_start_not_align = D_DATA_rom_end;
    NC_DATA_rom_start = NC_DATA_rom_start_not_align + (NC_DATA_rom_start_not_align % 4);
   
    NC_DATA_rom_end = NC_DATA_rom_start + NC_DATA_ram_end - NC_DATA_ram_start;
    


    DATA_RAM_rom_start_not_align = NC_DATA_rom_end;
    DATA_RAM_rom_start = DATA_RAM_rom_start_not_align + (DATA_RAM_rom_start_not_align % 4);
   
    DATA_RAM_rom_end = DATA_RAM_rom_start + DATA_RAM_ram_end - DATA_RAM_ram_start;
    


    .IVT_RAM  : {
        
        . = ALIGN(1024);
        IVT_RAM_start = .;
        . += 0x400;
        IVT_RAM_end = .;
    } > IVT_RAM
   
    


    .CODE_RAM  : AT(CODE_RAM_rom_start) {
        
        . = ALIGN(4);
        CODE_RAM_ram_start = .;
        CODE_RAM_start = .;
        . = ALIGN(4);
        ramcode_region_start = .;
        *(.ramcode)
        ramcode_region_end = .;
        
        . = ALIGN(4);
        CODE_RAM_end = .;
        CODE_RAM_ram_end = .;
    } > CODE_RAM
   
    
    ASSERT((CODE_RAM_ram_end - CODE_RAM_ram_start) == (CODE_RAM_rom_end - CODE_RAM_rom_start), "Copy Section CODE_RAM Size non-aligned")


    .D_BSS  (NOLOAD): {
        
        D_BSS_start = .;
        dtcm_bss_region_start = .;
        *(.dtcm_bss)
        dtcm_bss_region_end = .;
        
        D_BSS_end = .;
    } > D_RAM
   
    


    .D_DATA  : AT(D_DATA_rom_start) {
        
        . = ALIGN(4);
        D_DATA_ram_start = .;
        D_DATA_start = .;
        dtcm_data_region_start = .;
        *(.dtcm_data)
        dtcm_data_region_end = .;
        
        D_DATA_end = .;
        D_DATA_ram_end = .;
    } > D_RAM
   
    
    ASSERT((D_DATA_ram_end - D_DATA_ram_start) == (D_DATA_rom_end - D_DATA_rom_start), "Copy Section D_DATA Size non-aligned")


    .STACK  : {
        
        STACK_start = .;
        . += 4096;
        STACK_end = .;
    } > STACK
   
    


    .NC_BSS  (NOLOAD): {
        
        NC_BSS_start = .;
        mcal_bss_no_cacheable_region_start = .;
        *(.mcal_bss_no_cacheable)
        mcal_bss_no_cacheable_region_end = .;
        
        NC_BSS_end = .;
    } > NC_RAM
   
    


    .NC_DATA  : AT(NC_DATA_rom_start) {
        
        . = ALIGN(4);
        NC_DATA_ram_start = .;
        NC_DATA_start = .;
        mcal_data_no_cacheable_region_start = .;
        *(.mcal_data_no_cacheable)
        mcal_data_no_cacheable_region_end = .;
        
        NC_DATA_end = .;
        NC_DATA_ram_end = .;
    } > NC_RAM
   
    
    ASSERT((NC_DATA_ram_end - NC_DATA_ram_start) == (NC_DATA_rom_end - NC_DATA_rom_start), "Copy Section NC_DATA Size non-aligned")


    .BSS  (NOLOAD): {
        
        BSS_start = .;
        bss_region_start = .;
        *(.bss)
        *(.bss*)
        bss_region_end = .;
        
        mcal_bss_region_start = .;
        *(.mcal_bss)
        mcal_bss_region_end = .;
        
        BSS_end = .;
    } > RAM
   
    


    .DATA_RAM  : AT(DATA_RAM_rom_start) {
        
        . = ALIGN(4);
        DATA_RAM_ram_start = .;
        DATA_RAM_start = .;
        data_region_start = .;
        *(.data)
        *(.data*)
        data_region_end = .;
        
        mcal_data_region_start = .;
        *(.mcal_data)
        mcal_data_region_end = .;
        
        DATA_RAM_end = .;
        DATA_RAM_ram_end = .;
    } > RAM
   
    
    ASSERT((DATA_RAM_ram_end - DATA_RAM_ram_start) == (DATA_RAM_rom_end - DATA_RAM_rom_start), "Copy Section DATA_RAM Size non-aligned")


    BVT_memory_start = ORIGIN(BVT);
    BVT_memory_end = ORIGIN(BVT) + LENGTH(BVT);
    BVT_memory_size = LENGTH(BVT);
    IVT_memory_start = ORIGIN(IVT);
    IVT_memory_end = ORIGIN(IVT) + LENGTH(IVT);
    IVT_memory_size = LENGTH(IVT);
    NC_TEXT_memory_start = ORIGIN(NC_TEXT);
    NC_TEXT_memory_end = ORIGIN(NC_TEXT) + LENGTH(NC_TEXT);
    NC_TEXT_memory_size = LENGTH(NC_TEXT);
    TEXT_memory_start = ORIGIN(TEXT);
    TEXT_memory_end = ORIGIN(TEXT) + LENGTH(TEXT);
    TEXT_memory_size = LENGTH(TEXT);
    FEE_memory_start = ORIGIN(FEE);
    FEE_memory_end = ORIGIN(FEE) + LENGTH(FEE);
    FEE_memory_size = LENGTH(FEE);
    IVT_RAM_memory_start = ORIGIN(IVT_RAM);
    IVT_RAM_memory_end = ORIGIN(IVT_RAM) + LENGTH(IVT_RAM);
    IVT_RAM_memory_size = LENGTH(IVT_RAM);
    CODE_RAM_memory_start = ORIGIN(CODE_RAM);
    CODE_RAM_memory_end = ORIGIN(CODE_RAM) + LENGTH(CODE_RAM);
    CODE_RAM_memory_size = LENGTH(CODE_RAM);
    D_RAM_memory_start = ORIGIN(D_RAM);
    D_RAM_memory_end = ORIGIN(D_RAM) + LENGTH(D_RAM);
    D_RAM_memory_size = LENGTH(D_RAM);
    STACK_memory_start = ORIGIN(STACK);
    STACK_memory_end = ORIGIN(STACK) + LENGTH(STACK);
    STACK_memory_size = LENGTH(STACK);
    NC_RAM_memory_start = ORIGIN(NC_RAM);
    NC_RAM_memory_end = ORIGIN(NC_RAM) + LENGTH(NC_RAM);
    NC_RAM_memory_size = LENGTH(NC_RAM);
    RAM_memory_start = ORIGIN(RAM);
    RAM_memory_end = ORIGIN(RAM) + LENGTH(RAM);
    RAM_memory_size = LENGTH(RAM);
}