
/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Mpu_Lld_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                         INCLUDE FILES
==================================================================================================*/
#include "Mpu_Lld_Cfg.h"

/*==================================================================================================
                                      FILE VERSION CHECKS
==================================================================================================*/

#define MPU_LLD_CFG_VENDOR_ID_C                     (180)
#define MPU_LLD_CFG_AR_RELEASE_MAJOR_VERSION_C      (4)
#define MPU_LLD_CFG_AR_RELEASE_MINOR_VERSION_C      (4)
#define MPU_LLD_CFG_AR_RELEASE_REVISION_VERSION_C   (0)
#define MPU_LLD_CFG_SW_MAJOR_VERSION_C              (1)
#define MPU_LLD_CFG_SW_MINOR_VERSION_C              (0)
#define MPU_LLD_CFG_SW_PATCH_VERSION_C              (0)

/*==================================================================================================
                                       GLOBAL VARIABLES
==================================================================================================*/
#define PLATFORM_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Platform_MemMap.h"

/* The configuration of M7 MPU region MpuM7Config_Core0 */
PLATFORM_CONST const Mpu_Lld_M7_RegionCfgType MpuM7RegionConfig_MpuM7Config_Core0[12U] = 
{
    {
        /* RegionConfig_All4G */
        .RegionIndex = 0U,
        {
            .RBAR = ARM_MPU_RBAR(0U, 0x0U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_UNPRIV_NONE),
                MPU_LLD_M7_AP(MPU_M7_PRIV_UNPRIV_NONE),
                MPU_LLD_M7_TEX(MPU_M7_MEM_STRONG_ORDER),
                MPU_LLD_M7_S(MPU_M7_MEM_STRONG_ORDER) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_STRONG_ORDER),
                MPU_LLD_M7_B(MPU_M7_MEM_STRONG_ORDER),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(31U)
            ),
        }
    },
    {
        /* RegionConfig_ITCM */
        .RegionIndex = 1U,
        {
            .RBAR = ARM_MPU_RBAR(1U, 0U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_TEX(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_S(MPU_M7_MEM_NORMAL_IO_NO_CACHE) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_B(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(14U)
            ),
        }
    },
    {
        /* RegionConfig_PFlash_0_1 */
        .RegionIndex = 2U,
        {
            .RBAR = ARM_MPU_RBAR(2U, 0x02000000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_TEX(MPU_M7_MEM_NORMAL_IO_WR_THROUGH),
                MPU_LLD_M7_S(MPU_M7_MEM_NORMAL_IO_WR_THROUGH) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_NORMAL_IO_WR_THROUGH),
                MPU_LLD_M7_B(MPU_M7_MEM_NORMAL_IO_WR_THROUGH),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(20U)
            ),
        }
    },
    {
        /* RegionConfig_DFlash */
        .RegionIndex = 3U,
        {
            .RBAR = ARM_MPU_RBAR(3U, 0x06000000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RW_UNPRIV_RW),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RW_UNPRIV_RW),
                MPU_LLD_M7_TEX(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_S(MPU_M7_MEM_DEVICE_SHARED) | STD_ON,
                MPU_LLD_M7_C(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_B(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(17U)
            ),
        }
    },
    {
        /* RegionConfig_NVR_0 */
        .RegionIndex = 4U,
        {
            .RBAR = ARM_MPU_RBAR(4U, 0x10000000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RW_UNPRIV_NONE),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RW_UNPRIV_NONE),
                MPU_LLD_M7_TEX(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_S(MPU_M7_MEM_DEVICE_SHARED) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_B(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(13U)
            ),
        }
    },
    {
        /* RegionConfig_NVR_1 */
        .RegionIndex = 5U,
        {
            .RBAR = ARM_MPU_RBAR(5U, 0x10020000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RW_UNPRIV_NONE),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RW_UNPRIV_NONE),
                MPU_LLD_M7_TEX(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_S(MPU_M7_MEM_DEVICE_SHARED) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_B(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(13U)
            ),
        }
    },
    {
        /* RegionConfig_DTCM_OCRAML_OCRAMU_DTCMBackdoor */
        .RegionIndex = 6U,
        {
            .RBAR = ARM_MPU_RBAR(6U, 0x20000000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_TEX(MPU_M7_MEM_NORMAL_CACHEABLE) | MPU_M7_CACHE_POLICY_W_BACK_WR_ALLOCATE,
                MPU_LLD_M7_S(MPU_M7_MEM_NORMAL_CACHEABLE) | STD_OFF,
                MPU_LLD_M7_C((uint8)MPU_M7_MEM_NORMAL_CACHEABLE | (uint8)MPU_M7_CACHE_POLICY_W_BACK_WR_ALLOCATE),
                MPU_LLD_M7_B((uint8)MPU_M7_MEM_NORMAL_CACHEABLE | (uint8)MPU_M7_CACHE_POLICY_W_BACK_WR_ALLOCATE),            
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(18U)
            ),
        }
    },
    {
        /* RegionConfig_DTCM */
        .RegionIndex = 7U,
        {
            .RBAR = ARM_MPU_RBAR(7U, 0x20000000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_TEX(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_S(MPU_M7_MEM_NORMAL_IO_NO_CACHE) | STD_ON,
                MPU_LLD_M7_C(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_B(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(16U)
            ),
        }
    },
    {
        /* RegionConfig_OCRAML_NonCacheable */
        .RegionIndex = 8U,
        {
            .RBAR = ARM_MPU_RBAR(8U, 0x20020000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_TEX(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_S(MPU_M7_MEM_NORMAL_IO_NO_CACHE) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_B(MPU_M7_MEM_NORMAL_IO_NO_CACHE),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(15U)
            ),
        }
    },
    {
        /* RegionConfig_APB */
        .RegionIndex = 9U,
        {
            .RBAR = ARM_MPU_RBAR(9U, 0x40000000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RW_UNPRIV_RW),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RW_UNPRIV_RW),
                MPU_LLD_M7_TEX(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_S(MPU_M7_MEM_DEVICE_SHARED) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_B(MPU_M7_MEM_DEVICE_SHARED),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(20U)
            ),
        }
    },
    {
        /* RegionConfig_QSPIRXbuffer */
        .RegionIndex = 10U,
        {
            .RBAR = ARM_MPU_RBAR(10U, 0x67000000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RWX_UNPRIV_RWX),
                MPU_LLD_M7_TEX(MPU_M7_MEM_DEVICE_NOSHARE),
                MPU_LLD_M7_S(MPU_M7_MEM_DEVICE_NOSHARE) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_DEVICE_NOSHARE),
                MPU_LLD_M7_B(MPU_M7_MEM_DEVICE_NOSHARE),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(6U)
            ),
        }
    },
    {
        /* RegionConfig_PrivatePeripheralBus */
        .RegionIndex = 11U,
        {
            .RBAR = ARM_MPU_RBAR(11U, 0xe0000000U),
            .RASR = ARM_MPU_RASR
            (
                MPU_LLD_M7_XN(~MPU_M7_PRIV_RW_UNPRIV_RW),
                MPU_LLD_M7_AP(MPU_M7_PRIV_RW_UNPRIV_RW),
                MPU_LLD_M7_TEX(MPU_M7_MEM_DEVICE_NOSHARE),
                MPU_LLD_M7_S(MPU_M7_MEM_DEVICE_NOSHARE) | STD_OFF,
                MPU_LLD_M7_C(MPU_M7_MEM_DEVICE_NOSHARE),
                MPU_LLD_M7_B(MPU_M7_MEM_DEVICE_NOSHARE),
                MPU_LLD_M7_SRD(0U),
                MPU_LLD_M7_SIZE(19U)
            ),
        }
    },
};

/* The configuration of MPU MpuM7Config_Core0 */
PLATFORM_CONST const Mpu_Lld_M7_ConfigType MpuConfig = 
{
    .DefaultMapEn = FALSE,
    .RunHFNMIEn = FALSE,
    .MemManageIrqEn = TRUE,
    .RegionCount = 12U,
    .RegionConfig = MpuM7RegionConfig_MpuM7Config_Core0,
};

#define PLATFORM_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Platform_MemMap.h"

#ifdef __cplusplus
}
#endif

