/**
*   @file    pSIP_Cim.h
*   @version
*
*   @brief   AUTOSAR Cim register map
*   @details Register map for CIM
*
*   @addtogroup ADC_MODULE
*   @{
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Adc
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V1.0.0
*
*   (c) Copyright 2020-2023 YTMicro Semiconductor, Inc.
*   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/

#ifndef PSIP_CIM_H
#define PSIP_CIM_H

/*=================================================================================================
*                                        INCLUDE FILES
=================================================================================================*/

#include "Std_Types.h"

/*==================================================================================================
*                              CIM REGISTER MAP
==================================================================================================*/

/**
 * @addtogroup CIM_Peripheral_Access_Layer CIM Peripheral Access Layer
 * @{
 */


/** CIM - Size of Registers Arrays */

/* CIM Register Layout Typedef */
typedef struct {
    uint32 CTRL0;                              /**< CIM Control Register 0, offset: 0x0000 */
    uint32 CTRL1;                              /**< CIM Control Register 1, offset: 0x0004 */
    uint32 RESERVED_2;                         /**< RESERVED_2, offset: 0x0008 */
    uint32 RESERVED_3;                         /**< RESERVED_3, offset: 0x000C */
    uint32 FPUIE;                              /**< FPU Interrupt Enable Register, offset: 0x0010 */
    uint32 SWTRIG;                             /**< Software Trigger Register, offset: 0x0014 */
    uint32 ETMROPT0;                           /**< eTMR Option register 0, offset: 0x0018 */
    uint32 ETMROPT1;                           /**< eTMR Option register 1, offset: 0x001C */
    uint32 ETMROPT2;                           /**< eTMR Option register 2, offset: 0x0020 */
    uint32 ETMROPT3;                           /**< eTMR Option register 3, offset: 0x0024 */
    uint32 ETMROPT4;                           /**< eTMR Option register 4, offset: 0x0028 */
    uint32 ETMROPT5;                           /**< eTMR Option register 5, offset: 0x002C */
    uint32 RESERVED0[ 3];                      /**< RESERVED0, offset: 0x0030 */
    uint32 ETMR_GLB_OPT;                       /**< eTMR Global Option Register, offset: 0x003C */
    uint32 SWFAULT;                            /**< Software Fault Generate register, offset: 0x0040 */
    uint32 DCCM_EI;                            /**< Dual Core Compare Error Injection, offset: 0x0044 */
    uint32 RESERVED_16;                        /**< RESERVED_16, offset: 0x0048 */
    uint32 RESERVED1[13];                      /**< RESERVED1, offset: 0x004C */
    uint32 UID0;                               /**< CIM Unique Identification Register 0, offset: 0x0080 */
    uint32 UID1;                               /**< CIM Unique Identification Register 1, offset: 0x0084 */
    uint32 UID2;                               /**< CIM Unique Identification Register 2, offset: 0x0088 */
    uint32 UID3;                               /**< CIM Unique Identification Register 3, offset: 0x008C */
    uint32 DIEINFO;                            /**< Die Information Register, offset: 0x0090 */
    uint32 CHIPINFO0;                          /**< Chip Information Register 0, offset: 0x0094 */
    uint32 CHIPINFO1;                          /**< Chip Information Register 1, offset: 0x0098 */
    uint32 RESERVED2[ 1];                      /**< RESERVED2, offset: 0x009C */
    uint32 CPUINFO;                            /**< CPU Information Register, offset: 0x00A0 */
    uint32 RESERVED3[ 1];                      /**< RESERVED3, offset: 0x00A4 */
    uint32 RESERVED_28;                        /**< RESERVED_28, offset: 0x00A8 */
    uint32 RESERVED_29;                        /**< RESERVED_29, offset: 0x00AC */
    uint32 RESERVED_30;                        /**< RESERVED_30, offset: 0x00B0 */
    uint32 RESERVED_31;                        /**< RESERVED_31, offset: 0x00B4 */
    uint32 RESERVED_32;                        /**< RESERVED_32, offset: 0x00B8 */
    uint32 RESERVED_33;                        /**< RESERVED_33, offset: 0x00BC */
    uint32 BOOT_CFG;                           /**< Chip Boot Configuration Register, offset: 0x00C0 */

} CIM_Type, *CIM_MemMapPtr;


/** Number of instances of the CIM module. */
#define CIM_INSTANCE_COUNT                        (1u)

/* CIM base address */
#define CIM_BASE_ADDR32                                   (0x401EC000U)
#define CIM                                               ((volatile CIM_Type *)(CIM_BASE_ADDR32))

/** Array initializer of CIM peripheral base addresses */
#define CIM_BASE_ADDRS                                     { CIM_BASE_ADDR32 }
/** Array initializer of CIM peripheral base pointers */
#define CIM_BASE_PTRS                                      { CIM }

#define CIM_CTRL0_OFFSET32                                 (0x0000U)                    /**< Offset for CIM Control Register 0 */
#define CIM_CTRL1_OFFSET32                                 (0x0004U)                    /**< Offset for CIM Control Register 1 */
#define CIM_FPUIE_OFFSET32                                 (0x0010U)                    /**< Offset for FPU Interrupt Enable Register */
#define CIM_SWTRIG_OFFSET32                                (0x0014U)                    /**< Offset for Software Trigger Register */
#define CIM_ETMROPT0_OFFSET32                              (0x0018U)                    /**< Offset for eTMR Option register 0 */
#define CIM_ETMROPT1_OFFSET32                              (0x001CU)                    /**< Offset for eTMR Option register 1 */
#define CIM_ETMROPT2_OFFSET32                              (0x0020U)                    /**< Offset for eTMR Option register 2 */
#define CIM_ETMROPT3_OFFSET32                              (0x0024U)                    /**< Offset for eTMR Option register 3 */
#define CIM_ETMROPT4_OFFSET32                              (0x0028U)                    /**< Offset for eTMR Option register 4 */
#define CIM_ETMROPT5_OFFSET32                              (0x002CU)                    /**< Offset for eTMR Option register 5 */
#define CIM_ETMR_GLB_OPT_OFFSET32                          (0x003CU)                    /**< Offset for eTMR Global Option Register */
#define CIM_SWFAULT_OFFSET32                               (0x0040U)                    /**< Offset for Software Fault Generate register */
#define CIM_DCCM_EI_OFFSET32                               (0x0044U)                    /**< Offset for Dual Core Compare Error Injection */
#define CIM_UID0_OFFSET32                                  (0x0080U)                    /**< Offset for CIM Unique Identification Register 0 */
#define CIM_UID1_OFFSET32                                  (0x0084U)                    /**< Offset for CIM Unique Identification Register 1 */
#define CIM_UID2_OFFSET32                                  (0x0088U)                    /**< Offset for CIM Unique Identification Register 2 */
#define CIM_UID3_OFFSET32                                  (0x008CU)                    /**< Offset for CIM Unique Identification Register 3 */
#define CIM_DIEINFO_OFFSET32                               (0x0090U)                    /**< Offset for Die Information Register */
#define CIM_CHIPINFO0_OFFSET32                             (0x0094U)                    /**< Offset for Chip Information Register 0 */
#define CIM_CHIPINFO1_OFFSET32                             (0x0098U)                    /**< Offset for Chip Information Register 1 */
#define CIM_CPUINFO_OFFSET32                               (0x00A0U)                    /**< Offset for CPU Information Register */
#define CIM_BOOT_CFG_OFFSET32                              (0x00C0U)                    /**< Offset for Chip Boot Configuration Register */
#define CIM_ETMROPT_IS_INDEPENDENT   /* the eTMR external clock and trigger/sync configuration is independent with different CIM_ETMROPT0/1/2/3/4/5 registers for eTMR0/1/2/3/4/5 respectively */

/**
 * @addtogroup CIM Register Mask
 * @{
 */
/* CIM_CTRL0 Register */
#define CIM_CTRL0_ADC1_NORMT_SEL_MASK                      (0xC0000U)
#define CIM_CTRL0_ADC1_NORMT_SEL_SHIFT                     (18U)
#define CIM_CTRL0_ADC1_NORMT_SEL(x)                        (((uint32)(((uint32)(x)) << CIM_CTRL0_ADC1_NORMT_SEL_SHIFT)) & CIM_CTRL0_ADC1_NORMT_SEL_MASK)
#define CIM_CTRL0_ADC0_NORMT_SEL_MASK                      (0x30000U)
#define CIM_CTRL0_ADC0_NORMT_SEL_SHIFT                     (16U)
#define CIM_CTRL0_ADC0_NORMT_SEL(x)                        (((uint32)(((uint32)(x)) << CIM_CTRL0_ADC0_NORMT_SEL_SHIFT)) & CIM_CTRL0_ADC0_NORMT_SEL_MASK)
#define CIM_CTRL0_ACMP1_TRIG_SEL_MASK                      (0xC00U)
#define CIM_CTRL0_ACMP1_TRIG_SEL_SHIFT                     (10U)
#define CIM_CTRL0_ACMP1_TRIG_SEL(x)                        (((uint32)(((uint32)(x)) << CIM_CTRL0_ACMP1_TRIG_SEL_SHIFT)) & CIM_CTRL0_ACMP1_TRIG_SEL_MASK)
#define CIM_CTRL0_ACMP0_TRIG_SEL_MASK                      (0x300U)
#define CIM_CTRL0_ACMP0_TRIG_SEL_SHIFT                     (8U)
#define CIM_CTRL0_ACMP0_TRIG_SEL(x)                        (((uint32)(((uint32)(x)) << CIM_CTRL0_ACMP0_TRIG_SEL_SHIFT)) & CIM_CTRL0_ACMP0_TRIG_SEL_MASK)
/* CIM_CTRL1 Register */
#define CIM_CTRL1_VTORLK_MASK                              (0x8000U)
#define CIM_CTRL1_VTORLK_SHIFT                             (15U)
#define CIM_CTRL1_VTORLK(x)                                (((uint32)(((uint32)(x)) << CIM_CTRL1_VTORLK_SHIFT)) & CIM_CTRL1_VTORLK_MASK)
#define CIM_CTRL1_AHBPCRLK_MASK                            (0x4000U)
#define CIM_CTRL1_AHBPCRLK_SHIFT                           (14U)
#define CIM_CTRL1_AHBPCRLK(x)                              (((uint32)(((uint32)(x)) << CIM_CTRL1_AHBPCRLK_SHIFT)) & CIM_CTRL1_AHBPCRLK_MASK)
#define CIM_CTRL1_DTCMCRLK_MASK                            (0x2000U)
#define CIM_CTRL1_DTCMCRLK_SHIFT                           (13U)
#define CIM_CTRL1_DTCMCRLK(x)                              (((uint32)(((uint32)(x)) << CIM_CTRL1_DTCMCRLK_SHIFT)) & CIM_CTRL1_DTCMCRLK_MASK)
#define CIM_CTRL1_ITCMCRLK_MASK                            (0x1000U)
#define CIM_CTRL1_ITCMCRLK_SHIFT                           (12U)
#define CIM_CTRL1_ITCMCRLK(x)                              (((uint32)(((uint32)(x)) << CIM_CTRL1_ITCMCRLK_SHIFT)) & CIM_CTRL1_ITCMCRLK_MASK)
#define CIM_CTRL1_TCMBKDEN_MASK                            (0x8U)
#define CIM_CTRL1_TCMBKDEN_SHIFT                           (3U)
#define CIM_CTRL1_TCMBKDEN(x)                              (((uint32)(((uint32)(x)) << CIM_CTRL1_TCMBKDEN_SHIFT)) & CIM_CTRL1_TCMBKDEN_MASK)
#define CIM_CTRL1_LOCKUPEN_MASK                            (0x4U)
#define CIM_CTRL1_LOCKUPEN_SHIFT                           (2U)
#define CIM_CTRL1_LOCKUPEN(x)                              (((uint32)(((uint32)(x)) << CIM_CTRL1_LOCKUPEN_SHIFT)) & CIM_CTRL1_LOCKUPEN_MASK)
#define CIM_CTRL1_NMIEN_MASK                               (0x2U)
#define CIM_CTRL1_NMIEN_SHIFT                              (1U)
#define CIM_CTRL1_NMIEN(x)                                 (((uint32)(((uint32)(x)) << CIM_CTRL1_NMIEN_SHIFT)) & CIM_CTRL1_NMIEN_MASK)
#define CIM_CTRL1_WICENREQ_MASK                            (0x1U)
#define CIM_CTRL1_WICENREQ_SHIFT                           (0U)
#define CIM_CTRL1_WICENREQ(x)                              (((uint32)(((uint32)(x)) << CIM_CTRL1_WICENREQ_SHIFT)) & CIM_CTRL1_WICENREQ_MASK)
/* CIM_FPUIE Register */
#define CIM_FPUIE_FPIXCIE_MASK                             (0x20U)
#define CIM_FPUIE_FPIXCIE_SHIFT                            (5U)
#define CIM_FPUIE_FPIXCIE(x)                               (((uint32)(((uint32)(x)) << CIM_FPUIE_FPIXCIE_SHIFT)) & CIM_FPUIE_FPIXCIE_MASK)
#define CIM_FPUIE_FPIDCIE_MASK                             (0x10U)
#define CIM_FPUIE_FPIDCIE_SHIFT                            (4U)
#define CIM_FPUIE_FPIDCIE(x)                               (((uint32)(((uint32)(x)) << CIM_FPUIE_FPIDCIE_SHIFT)) & CIM_FPUIE_FPIDCIE_MASK)
#define CIM_FPUIE_FPOFCIE_MASK                             (0x8U)
#define CIM_FPUIE_FPOFCIE_SHIFT                            (3U)
#define CIM_FPUIE_FPOFCIE(x)                               (((uint32)(((uint32)(x)) << CIM_FPUIE_FPOFCIE_SHIFT)) & CIM_FPUIE_FPOFCIE_MASK)
#define CIM_FPUIE_FPUFCIE_MASK                             (0x4U)
#define CIM_FPUIE_FPUFCIE_SHIFT                            (2U)
#define CIM_FPUIE_FPUFCIE(x)                               (((uint32)(((uint32)(x)) << CIM_FPUIE_FPUFCIE_SHIFT)) & CIM_FPUIE_FPUFCIE_MASK)
#define CIM_FPUIE_FPDZCIE_MASK                             (0x2U)
#define CIM_FPUIE_FPDZCIE_SHIFT                            (1U)
#define CIM_FPUIE_FPDZCIE(x)                               (((uint32)(((uint32)(x)) << CIM_FPUIE_FPDZCIE_SHIFT)) & CIM_FPUIE_FPDZCIE_MASK)
#define CIM_FPUIE_FPIOCIE_MASK                             (0x1U)
#define CIM_FPUIE_FPIOCIE_SHIFT                            (0U)
#define CIM_FPUIE_FPIOCIE(x)                               (((uint32)(((uint32)(x)) << CIM_FPUIE_FPIOCIE_SHIFT)) & CIM_FPUIE_FPIOCIE_MASK)
/* CIM_SWTRIG Register */
#define CIM_SWTRIG_SWTCNT_MASK                             (0xFEU)
#define CIM_SWTRIG_SWTCNT_SHIFT                            (1U)
#define CIM_SWTRIG_SWTCNT(x)                               (((uint32)(((uint32)(x)) << CIM_SWTRIG_SWTCNT_SHIFT)) & CIM_SWTRIG_SWTCNT_MASK)
#define CIM_SWTRIG_SWT_MASK                                (0x1U)
#define CIM_SWTRIG_SWT_SHIFT                               (0U)
#define CIM_SWTRIG_SWT(x)                                  (((uint32)(((uint32)(x)) << CIM_SWTRIG_SWT_SHIFT)) & CIM_SWTRIG_SWT_MASK)
/* CIM_ETMROPT0 Register */
#define CIM_ETMROPT0_ETMR0_IN3_SEL_MASK                    (0xC00000U)
#define CIM_ETMROPT0_ETMR0_IN3_SEL_SHIFT                   (22U)
#define CIM_ETMROPT0_ETMR0_IN3_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_IN3_SEL_SHIFT)) & CIM_ETMROPT0_ETMR0_IN3_SEL_MASK)
#define CIM_ETMROPT0_ETMR0_IN2_SEL_MASK                    (0x300000U)
#define CIM_ETMROPT0_ETMR0_IN2_SEL_SHIFT                   (20U)
#define CIM_ETMROPT0_ETMR0_IN2_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_IN2_SEL_SHIFT)) & CIM_ETMROPT0_ETMR0_IN2_SEL_MASK)
#define CIM_ETMROPT0_ETMR0_IN1_SEL_MASK                    (0xC0000U)
#define CIM_ETMROPT0_ETMR0_IN1_SEL_SHIFT                   (18U)
#define CIM_ETMROPT0_ETMR0_IN1_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_IN1_SEL_SHIFT)) & CIM_ETMROPT0_ETMR0_IN1_SEL_MASK)
#define CIM_ETMROPT0_ETMR0_IN0_SEL_MASK                    (0x30000U)
#define CIM_ETMROPT0_ETMR0_IN0_SEL_SHIFT                   (16U)
#define CIM_ETMROPT0_ETMR0_IN0_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_IN0_SEL_SHIFT)) & CIM_ETMROPT0_ETMR0_IN0_SEL_MASK)
#define CIM_ETMROPT0_ETMR0_CH7OUTSEL_MASK                  (0x8000U)
#define CIM_ETMROPT0_ETMR0_CH7OUTSEL_SHIFT                 (15U)
#define CIM_ETMROPT0_ETMR0_CH7OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_CH7OUTSEL_SHIFT)) & CIM_ETMROPT0_ETMR0_CH7OUTSEL_MASK)
#define CIM_ETMROPT0_ETMR0_CH6OUTSEL_MASK                  (0x4000U)
#define CIM_ETMROPT0_ETMR0_CH6OUTSEL_SHIFT                 (14U)
#define CIM_ETMROPT0_ETMR0_CH6OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_CH6OUTSEL_SHIFT)) & CIM_ETMROPT0_ETMR0_CH6OUTSEL_MASK)
#define CIM_ETMROPT0_ETMR0_CH5OUTSEL_MASK                  (0x2000U)
#define CIM_ETMROPT0_ETMR0_CH5OUTSEL_SHIFT                 (13U)
#define CIM_ETMROPT0_ETMR0_CH5OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_CH5OUTSEL_SHIFT)) & CIM_ETMROPT0_ETMR0_CH5OUTSEL_MASK)
#define CIM_ETMROPT0_ETMR0_CH4OUTSEL_MASK                  (0x1000U)
#define CIM_ETMROPT0_ETMR0_CH4OUTSEL_SHIFT                 (12U)
#define CIM_ETMROPT0_ETMR0_CH4OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_CH4OUTSEL_SHIFT)) & CIM_ETMROPT0_ETMR0_CH4OUTSEL_MASK)
#define CIM_ETMROPT0_ETMR0_CH3OUTSEL_MASK                  (0x800U)
#define CIM_ETMROPT0_ETMR0_CH3OUTSEL_SHIFT                 (11U)
#define CIM_ETMROPT0_ETMR0_CH3OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_CH3OUTSEL_SHIFT)) & CIM_ETMROPT0_ETMR0_CH3OUTSEL_MASK)
#define CIM_ETMROPT0_ETMR0_CH2OUTSEL_MASK                  (0x400U)
#define CIM_ETMROPT0_ETMR0_CH2OUTSEL_SHIFT                 (10U)
#define CIM_ETMROPT0_ETMR0_CH2OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_CH2OUTSEL_SHIFT)) & CIM_ETMROPT0_ETMR0_CH2OUTSEL_MASK)
#define CIM_ETMROPT0_ETMR0_CH1OUTSEL_MASK                  (0x200U)
#define CIM_ETMROPT0_ETMR0_CH1OUTSEL_SHIFT                 (9U)
#define CIM_ETMROPT0_ETMR0_CH1OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_CH1OUTSEL_SHIFT)) & CIM_ETMROPT0_ETMR0_CH1OUTSEL_MASK)
#define CIM_ETMROPT0_ETMR0_CH0OUTSEL_MASK                  (0x100U)
#define CIM_ETMROPT0_ETMR0_CH0OUTSEL_SHIFT                 (8U)
#define CIM_ETMROPT0_ETMR0_CH0OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_CH0OUTSEL_SHIFT)) & CIM_ETMROPT0_ETMR0_CH0OUTSEL_MASK)
#define CIM_ETMROPT0_ETMR0_FAULT_SEL_MASK                  (0x70U)
#define CIM_ETMROPT0_ETMR0_FAULT_SEL_SHIFT                 (4U)
#define CIM_ETMROPT0_ETMR0_FAULT_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_FAULT_SEL_SHIFT)) & CIM_ETMROPT0_ETMR0_FAULT_SEL_MASK)
#define CIM_ETMROPT0_ETMR0_EXTCLK_SEL_MASK                  (0x3U)
#define CIM_ETMROPT0_ETMR0_EXTCLK_SEL_SHIFT                 (0U)
#define CIM_ETMROPT0_ETMR0_EXTCLK_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT0_ETMR0_EXTCLK_SEL_SHIFT)) & CIM_ETMROPT0_ETMR0_EXTCLK_SEL_MASK)
/* CIM_ETMROPT1 Register */
#define CIM_ETMROPT1_ETMR1_IN3_SEL_MASK                    (0xC00000U)
#define CIM_ETMROPT1_ETMR1_IN3_SEL_SHIFT                   (22U)
#define CIM_ETMROPT1_ETMR1_IN3_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT1_ETMR1_IN3_SEL_SHIFT)) & CIM_ETMROPT1_ETMR1_IN3_SEL_MASK)
#define CIM_ETMROPT1_ETMR1_IN2_SEL_MASK                    (0x300000U)
#define CIM_ETMROPT1_ETMR1_IN2_SEL_SHIFT                   (20U)
#define CIM_ETMROPT1_ETMR1_IN2_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT1_ETMR1_IN2_SEL_SHIFT)) & CIM_ETMROPT1_ETMR1_IN2_SEL_MASK)
#define CIM_ETMROPT1_ETMR1_IN1_SEL_MASK                    (0xC0000U)
#define CIM_ETMROPT1_ETMR1_IN1_SEL_SHIFT                   (18U)
#define CIM_ETMROPT1_ETMR1_IN1_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT1_ETMR1_IN1_SEL_SHIFT)) & CIM_ETMROPT1_ETMR1_IN1_SEL_MASK)
#define CIM_ETMROPT1_ETMR1_IN0_SEL_MASK                    (0x30000U)
#define CIM_ETMROPT1_ETMR1_IN0_SEL_SHIFT                   (16U)
#define CIM_ETMROPT1_ETMR1_IN0_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT1_ETMR1_IN0_SEL_SHIFT)) & CIM_ETMROPT1_ETMR1_IN0_SEL_MASK)
#define CIM_ETMROPT1_ETMR1_FAULT_SEL_MASK                  (0x70U)
#define CIM_ETMROPT1_ETMR1_FAULT_SEL_SHIFT                 (4U)
#define CIM_ETMROPT1_ETMR1_FAULT_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT1_ETMR1_FAULT_SEL_SHIFT)) & CIM_ETMROPT1_ETMR1_FAULT_SEL_MASK)
#define CIM_ETMROPT1_ETMR1_EXTCLK_SEL_MASK                  (0x3U)
#define CIM_ETMROPT1_ETMR1_EXTCLK_SEL_SHIFT                 (0U)
#define CIM_ETMROPT1_ETMR1_EXTCLK_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT1_ETMR1_EXTCLK_SEL_SHIFT)) & CIM_ETMROPT1_ETMR1_EXTCLK_SEL_MASK)
/* CIM_ETMROPT2 Register */
#define CIM_ETMROPT2_ETMR2_IN3_SEL_MASK                    (0xC00000U)
#define CIM_ETMROPT2_ETMR2_IN3_SEL_SHIFT                   (22U)
#define CIM_ETMROPT2_ETMR2_IN3_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT2_ETMR2_IN3_SEL_SHIFT)) & CIM_ETMROPT2_ETMR2_IN3_SEL_MASK)
#define CIM_ETMROPT2_ETMR2_IN2_SEL_MASK                    (0x300000U)
#define CIM_ETMROPT2_ETMR2_IN2_SEL_SHIFT                   (20U)
#define CIM_ETMROPT2_ETMR2_IN2_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT2_ETMR2_IN2_SEL_SHIFT)) & CIM_ETMROPT2_ETMR2_IN2_SEL_MASK)
#define CIM_ETMROPT2_ETMR2_IN1_SEL_MASK                    (0xC0000U)
#define CIM_ETMROPT2_ETMR2_IN1_SEL_SHIFT                   (18U)
#define CIM_ETMROPT2_ETMR2_IN1_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT2_ETMR2_IN1_SEL_SHIFT)) & CIM_ETMROPT2_ETMR2_IN1_SEL_MASK)
#define CIM_ETMROPT2_ETMR2_IN0_SEL_MASK                    (0x30000U)
#define CIM_ETMROPT2_ETMR2_IN0_SEL_SHIFT                   (16U)
#define CIM_ETMROPT2_ETMR2_IN0_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT2_ETMR2_IN0_SEL_SHIFT)) & CIM_ETMROPT2_ETMR2_IN0_SEL_MASK)
#define CIM_ETMROPT2_ETMR2_FAULT_SEL_MASK                  (0x70U)
#define CIM_ETMROPT2_ETMR2_FAULT_SEL_SHIFT                 (4U)
#define CIM_ETMROPT2_ETMR2_FAULT_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT2_ETMR2_FAULT_SEL_SHIFT)) & CIM_ETMROPT2_ETMR2_FAULT_SEL_MASK)
#define CIM_ETMROPT2_ETMR2_EXTCLK_SEL_MASK                  (0x3U)
#define CIM_ETMROPT2_ETMR2_EXTCLK_SEL_SHIFT                 (0U)
#define CIM_ETMROPT2_ETMR2_EXTCLK_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT2_ETMR2_EXTCLK_SEL_SHIFT)) & CIM_ETMROPT2_ETMR2_EXTCLK_SEL_MASK)
/* CIM_ETMROPT3 Register */
#define CIM_ETMROPT3_ETMR3_IN3_SEL_MASK                    (0xC00000U)
#define CIM_ETMROPT3_ETMR3_IN3_SEL_SHIFT                   (22U)
#define CIM_ETMROPT3_ETMR3_IN3_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_IN3_SEL_SHIFT)) & CIM_ETMROPT3_ETMR3_IN3_SEL_MASK)
#define CIM_ETMROPT3_ETMR3_IN2_SEL_MASK                    (0x300000U)
#define CIM_ETMROPT3_ETMR3_IN2_SEL_SHIFT                   (20U)
#define CIM_ETMROPT3_ETMR3_IN2_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_IN2_SEL_SHIFT)) & CIM_ETMROPT3_ETMR3_IN2_SEL_MASK)
#define CIM_ETMROPT3_ETMR3_IN1_SEL_MASK                    (0xC0000U)
#define CIM_ETMROPT3_ETMR3_IN1_SEL_SHIFT                   (18U)
#define CIM_ETMROPT3_ETMR3_IN1_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_IN1_SEL_SHIFT)) & CIM_ETMROPT3_ETMR3_IN1_SEL_MASK)
#define CIM_ETMROPT3_ETMR3_IN0_SEL_MASK                    (0x30000U)
#define CIM_ETMROPT3_ETMR3_IN0_SEL_SHIFT                   (16U)
#define CIM_ETMROPT3_ETMR3_IN0_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_IN0_SEL_SHIFT)) & CIM_ETMROPT3_ETMR3_IN0_SEL_MASK)
#define CIM_ETMROPT3_ETMR3_CH7OUTSEL_MASK                  (0x8000U)
#define CIM_ETMROPT3_ETMR3_CH7OUTSEL_SHIFT                 (15U)
#define CIM_ETMROPT3_ETMR3_CH7OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_CH7OUTSEL_SHIFT)) & CIM_ETMROPT3_ETMR3_CH7OUTSEL_MASK)
#define CIM_ETMROPT3_ETMR3_CH6OUTSEL_MASK                  (0x4000U)
#define CIM_ETMROPT3_ETMR3_CH6OUTSEL_SHIFT                 (14U)
#define CIM_ETMROPT3_ETMR3_CH6OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_CH6OUTSEL_SHIFT)) & CIM_ETMROPT3_ETMR3_CH6OUTSEL_MASK)
#define CIM_ETMROPT3_ETMR3_CH5OUTSEL_MASK                  (0x2000U)
#define CIM_ETMROPT3_ETMR3_CH5OUTSEL_SHIFT                 (13U)
#define CIM_ETMROPT3_ETMR3_CH5OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_CH5OUTSEL_SHIFT)) & CIM_ETMROPT3_ETMR3_CH5OUTSEL_MASK)
#define CIM_ETMROPT3_ETMR3_CH4OUTSEL_MASK                  (0x1000U)
#define CIM_ETMROPT3_ETMR3_CH4OUTSEL_SHIFT                 (12U)
#define CIM_ETMROPT3_ETMR3_CH4OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_CH4OUTSEL_SHIFT)) & CIM_ETMROPT3_ETMR3_CH4OUTSEL_MASK)
#define CIM_ETMROPT3_ETMR3_CH3OUTSEL_MASK                  (0x800U)
#define CIM_ETMROPT3_ETMR3_CH3OUTSEL_SHIFT                 (11U)
#define CIM_ETMROPT3_ETMR3_CH3OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_CH3OUTSEL_SHIFT)) & CIM_ETMROPT3_ETMR3_CH3OUTSEL_MASK)
#define CIM_ETMROPT3_ETMR3_CH2OUTSEL_MASK                  (0x400U)
#define CIM_ETMROPT3_ETMR3_CH2OUTSEL_SHIFT                 (10U)
#define CIM_ETMROPT3_ETMR3_CH2OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_CH2OUTSEL_SHIFT)) & CIM_ETMROPT3_ETMR3_CH2OUTSEL_MASK)
#define CIM_ETMROPT3_ETMR3_CH1OUTSEL_MASK                  (0x200U)
#define CIM_ETMROPT3_ETMR3_CH1OUTSEL_SHIFT                 (9U)
#define CIM_ETMROPT3_ETMR3_CH1OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_CH1OUTSEL_SHIFT)) & CIM_ETMROPT3_ETMR3_CH1OUTSEL_MASK)
#define CIM_ETMROPT3_ETMR3_CH0OUTSEL_MASK                  (0x100U)
#define CIM_ETMROPT3_ETMR3_CH0OUTSEL_SHIFT                 (8U)
#define CIM_ETMROPT3_ETMR3_CH0OUTSEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_CH0OUTSEL_SHIFT)) & CIM_ETMROPT3_ETMR3_CH0OUTSEL_MASK)
#define CIM_ETMROPT3_ETMR3_FAULT_SEL_MASK                  (0x70U)
#define CIM_ETMROPT3_ETMR3_FAULT_SEL_SHIFT                 (4U)
#define CIM_ETMROPT3_ETMR3_FAULT_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_FAULT_SEL_SHIFT)) & CIM_ETMROPT3_ETMR3_FAULT_SEL_MASK)
#define CIM_ETMROPT3_ETMR3_EXTCLK_SEL_MASK                  (0x3U)
#define CIM_ETMROPT3_ETMR3_EXTCLK_SEL_SHIFT                 (0U)
#define CIM_ETMROPT3_ETMR3_EXTCLK_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT3_ETMR3_EXTCLK_SEL_SHIFT)) & CIM_ETMROPT3_ETMR3_EXTCLK_SEL_MASK)
/* CIM_ETMROPT4 Register */
#define CIM_ETMROPT4_ETMR4_IN3_SEL_MASK                    (0xC00000U)
#define CIM_ETMROPT4_ETMR4_IN3_SEL_SHIFT                   (22U)
#define CIM_ETMROPT4_ETMR4_IN3_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT4_ETMR4_IN3_SEL_SHIFT)) & CIM_ETMROPT4_ETMR4_IN3_SEL_MASK)
#define CIM_ETMROPT4_ETMR4_IN2_SEL_MASK                    (0x300000U)
#define CIM_ETMROPT4_ETMR4_IN2_SEL_SHIFT                   (20U)
#define CIM_ETMROPT4_ETMR4_IN2_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT4_ETMR4_IN2_SEL_SHIFT)) & CIM_ETMROPT4_ETMR4_IN2_SEL_MASK)
#define CIM_ETMROPT4_ETMR4_IN1_SEL_MASK                    (0xC0000U)
#define CIM_ETMROPT4_ETMR4_IN1_SEL_SHIFT                   (18U)
#define CIM_ETMROPT4_ETMR4_IN1_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT4_ETMR4_IN1_SEL_SHIFT)) & CIM_ETMROPT4_ETMR4_IN1_SEL_MASK)
#define CIM_ETMROPT4_ETMR4_IN0_SEL_MASK                    (0x30000U)
#define CIM_ETMROPT4_ETMR4_IN0_SEL_SHIFT                   (16U)
#define CIM_ETMROPT4_ETMR4_IN0_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT4_ETMR4_IN0_SEL_SHIFT)) & CIM_ETMROPT4_ETMR4_IN0_SEL_MASK)
#define CIM_ETMROPT4_ETMR4_EXTCLK_SEL_MASK                  (0x3U)
#define CIM_ETMROPT4_ETMR4_EXTCLK_SEL_SHIFT                 (0U)
#define CIM_ETMROPT4_ETMR4_EXTCLK_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT4_ETMR4_EXTCLK_SEL_SHIFT)) & CIM_ETMROPT4_ETMR4_EXTCLK_SEL_MASK)
/* CIM_ETMROPT5 Register */
#define CIM_ETMROPT5_ETMR5_IN3_SEL_MASK                    (0xC00000U)
#define CIM_ETMROPT5_ETMR5_IN3_SEL_SHIFT                   (22U)
#define CIM_ETMROPT5_ETMR5_IN3_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT5_ETMR5_IN3_SEL_SHIFT)) & CIM_ETMROPT5_ETMR5_IN3_SEL_MASK)
#define CIM_ETMROPT5_ETMR5_IN2_SEL_MASK                    (0x300000U)
#define CIM_ETMROPT5_ETMR5_IN2_SEL_SHIFT                   (20U)
#define CIM_ETMROPT5_ETMR5_IN2_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT5_ETMR5_IN2_SEL_SHIFT)) & CIM_ETMROPT5_ETMR5_IN2_SEL_MASK)
#define CIM_ETMROPT5_ETMR5_IN1_SEL_MASK                    (0xC0000U)
#define CIM_ETMROPT5_ETMR5_IN1_SEL_SHIFT                   (18U)
#define CIM_ETMROPT5_ETMR5_IN1_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT5_ETMR5_IN1_SEL_SHIFT)) & CIM_ETMROPT5_ETMR5_IN1_SEL_MASK)
#define CIM_ETMROPT5_ETMR5_IN0_SEL_MASK                    (0x30000U)
#define CIM_ETMROPT5_ETMR5_IN0_SEL_SHIFT                   (16U)
#define CIM_ETMROPT5_ETMR5_IN0_SEL(x)                      (((uint32)(((uint32)(x)) << CIM_ETMROPT5_ETMR5_IN0_SEL_SHIFT)) & CIM_ETMROPT5_ETMR5_IN0_SEL_MASK)
#define CIM_ETMROPT5_ETMR5_EXTCLK_SEL_MASK                  (0x3U)
#define CIM_ETMROPT5_ETMR5_EXTCLK_SEL_SHIFT                 (0U)
#define CIM_ETMROPT5_ETMR5_EXTCLK_SEL(x)                    (((uint32)(((uint32)(x)) << CIM_ETMROPT5_ETMR5_EXTCLK_SEL_SHIFT)) & CIM_ETMROPT5_ETMR5_EXTCLK_SEL_MASK)
/* CIM_ETMR_GLB_OPT Register */
#define CIM_ETMR_GLB_OPT_ETMR_GTBE_SEL_MASK                (0x4000U)
#define CIM_ETMR_GLB_OPT_ETMR_GTBE_SEL_SHIFT               (14U)
#define CIM_ETMR_GLB_OPT_ETMR_GTBE_SEL(x)                  (((uint32)(((uint32)(x)) << CIM_ETMR_GLB_OPT_ETMR_GTBE_SEL_SHIFT)) & CIM_ETMR_GLB_OPT_ETMR_GTBE_SEL_MASK)
#define CIM_ETMR_GLB_OPT_ETMR5SS1C_MASK                    (0x20U)
#define CIM_ETMR_GLB_OPT_ETMR5SS1C_SHIFT                   (5U)
#define CIM_ETMR_GLB_OPT_ETMR5SS1C(x)                      (((uint32)(((uint32)(x)) << CIM_ETMR_GLB_OPT_ETMR5SS1C_SHIFT)) & CIM_ETMR_GLB_OPT_ETMR5SS1C_MASK)
#define CIM_ETMR_GLB_OPT_ETMR4SS1C_MASK                    (0x10U)
#define CIM_ETMR_GLB_OPT_ETMR4SS1C_SHIFT                   (4U)
#define CIM_ETMR_GLB_OPT_ETMR4SS1C(x)                      (((uint32)(((uint32)(x)) << CIM_ETMR_GLB_OPT_ETMR4SS1C_SHIFT)) & CIM_ETMR_GLB_OPT_ETMR4SS1C_MASK)
#define CIM_ETMR_GLB_OPT_ETMR3SS1C_MASK                    (0x8U)
#define CIM_ETMR_GLB_OPT_ETMR3SS1C_SHIFT                   (3U)
#define CIM_ETMR_GLB_OPT_ETMR3SS1C(x)                      (((uint32)(((uint32)(x)) << CIM_ETMR_GLB_OPT_ETMR3SS1C_SHIFT)) & CIM_ETMR_GLB_OPT_ETMR3SS1C_MASK)
#define CIM_ETMR_GLB_OPT_ETMR2SS1C_MASK                    (0x4U)
#define CIM_ETMR_GLB_OPT_ETMR2SS1C_SHIFT                   (2U)
#define CIM_ETMR_GLB_OPT_ETMR2SS1C(x)                      (((uint32)(((uint32)(x)) << CIM_ETMR_GLB_OPT_ETMR2SS1C_SHIFT)) & CIM_ETMR_GLB_OPT_ETMR2SS1C_MASK)
#define CIM_ETMR_GLB_OPT_ETMR1SS1C_MASK                    (0x2U)
#define CIM_ETMR_GLB_OPT_ETMR1SS1C_SHIFT                   (1U)
#define CIM_ETMR_GLB_OPT_ETMR1SS1C(x)                      (((uint32)(((uint32)(x)) << CIM_ETMR_GLB_OPT_ETMR1SS1C_SHIFT)) & CIM_ETMR_GLB_OPT_ETMR1SS1C_MASK)
#define CIM_ETMR_GLB_OPT_ETMR0SS1C_MASK                    (0x1U)
#define CIM_ETMR_GLB_OPT_ETMR0SS1C_SHIFT                   (0U)
#define CIM_ETMR_GLB_OPT_ETMR0SS1C(x)                      (((uint32)(((uint32)(x)) << CIM_ETMR_GLB_OPT_ETMR0SS1C_SHIFT)) & CIM_ETMR_GLB_OPT_ETMR0SS1C_MASK)
/* CIM_SWFAULT Register */
#define CIM_SWFAULT_SW_FAULT_MASK                          (0x1U)
#define CIM_SWFAULT_SW_FAULT_SHIFT                         (0U)
#define CIM_SWFAULT_SW_FAULT(x)                            (((uint32)(((uint32)(x)) << CIM_SWFAULT_SW_FAULT_SHIFT)) & CIM_SWFAULT_SW_FAULT_MASK)
/* CIM_DCCM_EI Register */
#define CIM_DCCM_EI_DCCM2_EER_INJ_MASK                     (0x2U)
#define CIM_DCCM_EI_DCCM2_EER_INJ_SHIFT                    (1U)
#define CIM_DCCM_EI_DCCM2_EER_INJ(x)                       (((uint32)(((uint32)(x)) << CIM_DCCM_EI_DCCM2_EER_INJ_SHIFT)) & CIM_DCCM_EI_DCCM2_EER_INJ_MASK)
#define CIM_DCCM_EI_DCCM_EER_INJ_MASK                      (0x1U)
#define CIM_DCCM_EI_DCCM_EER_INJ_SHIFT                     (0U)
#define CIM_DCCM_EI_DCCM_EER_INJ(x)                        (((uint32)(((uint32)(x)) << CIM_DCCM_EI_DCCM_EER_INJ_SHIFT)) & CIM_DCCM_EI_DCCM_EER_INJ_MASK)
/* CIM_UID0 Register */
#define CIM_UID0_UID0_MASK                                 (0xFFFFFFFFU)
#define CIM_UID0_UID0_SHIFT                                (0U)
#define CIM_UID0_UID0(x)                                   (((uint32)(((uint32)(x)) << CIM_UID0_UID0_SHIFT)) & CIM_UID0_UID0_MASK)
/* CIM_UID1 Register */
#define CIM_UID1_UID1_MASK                                 (0xFFFFFFFFU)
#define CIM_UID1_UID1_SHIFT                                (0U)
#define CIM_UID1_UID1(x)                                   (((uint32)(((uint32)(x)) << CIM_UID1_UID1_SHIFT)) & CIM_UID1_UID1_MASK)
/* CIM_UID2 Register */
#define CIM_UID2_UID2_MASK                                 (0xFFFFFFFFU)
#define CIM_UID2_UID2_SHIFT                                (0U)
#define CIM_UID2_UID2(x)                                   (((uint32)(((uint32)(x)) << CIM_UID2_UID2_SHIFT)) & CIM_UID2_UID2_MASK)
/* CIM_UID3 Register */
#define CIM_UID3_UID3_MASK                                 (0xFFFFFFFFU)
#define CIM_UID3_UID3_SHIFT                                (0U)
#define CIM_UID3_UID3(x)                                   (((uint32)(((uint32)(x)) << CIM_UID3_UID3_SHIFT)) & CIM_UID3_UID3_MASK)
/* CIM_DIEINFO Register */
#define CIM_DIEINFO_FAMID_MASK                             (0xF0000000U)
#define CIM_DIEINFO_FAMID_SHIFT                            (28U)
#define CIM_DIEINFO_FAMID(x)                               (((uint32)(((uint32)(x)) << CIM_DIEINFO_FAMID_SHIFT)) & CIM_DIEINFO_FAMID_MASK)
#define CIM_DIEINFO_GENID_MASK                             (0xF000000U)
#define CIM_DIEINFO_GENID_SHIFT                            (24U)
#define CIM_DIEINFO_GENID(x)                               (((uint32)(((uint32)(x)) << CIM_DIEINFO_GENID_SHIFT)) & CIM_DIEINFO_GENID_MASK)
#define CIM_DIEINFO_SUBFAMIDH_MASK                         (0xF00000U)
#define CIM_DIEINFO_SUBFAMIDH_SHIFT                        (20U)
#define CIM_DIEINFO_SUBFAMIDH(x)                           (((uint32)(((uint32)(x)) << CIM_DIEINFO_SUBFAMIDH_SHIFT)) & CIM_DIEINFO_SUBFAMIDH_MASK)
#define CIM_DIEINFO_SUBFAMIDL_MASK                         (0xF0000U)
#define CIM_DIEINFO_SUBFAMIDL_SHIFT                        (16U)
#define CIM_DIEINFO_SUBFAMIDL(x)                           (((uint32)(((uint32)(x)) << CIM_DIEINFO_SUBFAMIDL_SHIFT)) & CIM_DIEINFO_SUBFAMIDL_MASK)
#define CIM_DIEINFO_MAJVER_MASK                            (0xF0U)
#define CIM_DIEINFO_MAJVER_SHIFT                           (4U)
#define CIM_DIEINFO_MAJVER(x)                              (((uint32)(((uint32)(x)) << CIM_DIEINFO_MAJVER_SHIFT)) & CIM_DIEINFO_MAJVER_MASK)
#define CIM_DIEINFO_MINVER_MASK                            (0xFU)
#define CIM_DIEINFO_MINVER_SHIFT                           (0U)
#define CIM_DIEINFO_MINVER(x)                              (((uint32)(((uint32)(x)) << CIM_DIEINFO_MINVER_SHIFT)) & CIM_DIEINFO_MINVER_MASK)
/* CIM_CHIPINFO0 Register */
#define CIM_CHIPINFO0_PKGS_MASK                            (0xF00000U)
#define CIM_CHIPINFO0_PKGS_SHIFT                           (20U)
#define CIM_CHIPINFO0_PKGS(x)                              (((uint32)(((uint32)(x)) << CIM_CHIPINFO0_PKGS_SHIFT)) & CIM_CHIPINFO0_PKGS_MASK)
#define CIM_CHIPINFO0_OCRAMS_MASK                          (0xF0000U)
#define CIM_CHIPINFO0_OCRAMS_SHIFT                         (16U)
#define CIM_CHIPINFO0_OCRAMS(x)                            (((uint32)(((uint32)(x)) << CIM_CHIPINFO0_OCRAMS_SHIFT)) & CIM_CHIPINFO0_OCRAMS_MASK)
#define CIM_CHIPINFO0_DFLASHS_MASK                         (0xF000U)
#define CIM_CHIPINFO0_DFLASHS_SHIFT                        (12U)
#define CIM_CHIPINFO0_DFLASHS(x)                           (((uint32)(((uint32)(x)) << CIM_CHIPINFO0_DFLASHS_SHIFT)) & CIM_CHIPINFO0_DFLASHS_MASK)
#define CIM_CHIPINFO0_PFLASHS_MASK                         (0xF00U)
#define CIM_CHIPINFO0_PFLASHS_SHIFT                        (8U)
#define CIM_CHIPINFO0_PFLASHS(x)                           (((uint32)(((uint32)(x)) << CIM_CHIPINFO0_PFLASHS_SHIFT)) & CIM_CHIPINFO0_PFLASHS_MASK)
/* CIM_CHIPINFO1 Register */
#define CIM_CHIPINFO1_FLEXCAN7_FD_EN_MASK                  (0x80U)
#define CIM_CHIPINFO1_FLEXCAN7_FD_EN_SHIFT                 (7U)
#define CIM_CHIPINFO1_FLEXCAN7_FD_EN(x)                    (((uint32)(((uint32)(x)) << CIM_CHIPINFO1_FLEXCAN7_FD_EN_SHIFT)) & CIM_CHIPINFO1_FLEXCAN7_FD_EN_MASK)
#define CIM_CHIPINFO1_FLEXCAN6_FD_EN_MASK                  (0x40U)
#define CIM_CHIPINFO1_FLEXCAN6_FD_EN_SHIFT                 (6U)
#define CIM_CHIPINFO1_FLEXCAN6_FD_EN(x)                    (((uint32)(((uint32)(x)) << CIM_CHIPINFO1_FLEXCAN6_FD_EN_SHIFT)) & CIM_CHIPINFO1_FLEXCAN6_FD_EN_MASK)
#define CIM_CHIPINFO1_FLEXCAN5_FD_EN_MASK                  (0x20U)
#define CIM_CHIPINFO1_FLEXCAN5_FD_EN_SHIFT                 (5U)
#define CIM_CHIPINFO1_FLEXCAN5_FD_EN(x)                    (((uint32)(((uint32)(x)) << CIM_CHIPINFO1_FLEXCAN5_FD_EN_SHIFT)) & CIM_CHIPINFO1_FLEXCAN5_FD_EN_MASK)
#define CIM_CHIPINFO1_FLEXCAN4_FD_EN_MASK                  (0x10U)
#define CIM_CHIPINFO1_FLEXCAN4_FD_EN_SHIFT                 (4U)
#define CIM_CHIPINFO1_FLEXCAN4_FD_EN(x)                    (((uint32)(((uint32)(x)) << CIM_CHIPINFO1_FLEXCAN4_FD_EN_SHIFT)) & CIM_CHIPINFO1_FLEXCAN4_FD_EN_MASK)
#define CIM_CHIPINFO1_FLEXCAN3_FD_EN_MASK                  (0x8U)
#define CIM_CHIPINFO1_FLEXCAN3_FD_EN_SHIFT                 (3U)
#define CIM_CHIPINFO1_FLEXCAN3_FD_EN(x)                    (((uint32)(((uint32)(x)) << CIM_CHIPINFO1_FLEXCAN3_FD_EN_SHIFT)) & CIM_CHIPINFO1_FLEXCAN3_FD_EN_MASK)
#define CIM_CHIPINFO1_FLEXCAN2_FD_EN_MASK                  (0x4U)
#define CIM_CHIPINFO1_FLEXCAN2_FD_EN_SHIFT                 (2U)
#define CIM_CHIPINFO1_FLEXCAN2_FD_EN(x)                    (((uint32)(((uint32)(x)) << CIM_CHIPINFO1_FLEXCAN2_FD_EN_SHIFT)) & CIM_CHIPINFO1_FLEXCAN2_FD_EN_MASK)
#define CIM_CHIPINFO1_FLEXCAN1_FD_EN_MASK                  (0x2U)
#define CIM_CHIPINFO1_FLEXCAN1_FD_EN_SHIFT                 (1U)
#define CIM_CHIPINFO1_FLEXCAN1_FD_EN(x)                    (((uint32)(((uint32)(x)) << CIM_CHIPINFO1_FLEXCAN1_FD_EN_SHIFT)) & CIM_CHIPINFO1_FLEXCAN1_FD_EN_MASK)
#define CIM_CHIPINFO1_FLEXCAN0_FD_EN_MASK                  (0x1U)
#define CIM_CHIPINFO1_FLEXCAN0_FD_EN_SHIFT                 (0U)
#define CIM_CHIPINFO1_FLEXCAN0_FD_EN(x)                    (((uint32)(((uint32)(x)) << CIM_CHIPINFO1_FLEXCAN0_FD_EN_SHIFT)) & CIM_CHIPINFO1_FLEXCAN0_FD_EN_MASK)
/* CIM_CPUINFO Register */
#define CIM_CPUINFO_AHBPSZ_MASK                            (0x70000U)
#define CIM_CPUINFO_AHBPSZ_SHIFT                           (16U)
#define CIM_CPUINFO_AHBPSZ(x)                              (((uint32)(((uint32)(x)) << CIM_CPUINFO_AHBPSZ_SHIFT)) & CIM_CPUINFO_AHBPSZ_MASK)
#define CIM_CPUINFO_DCACHESZ_MASK                          (0xF000U)
#define CIM_CPUINFO_DCACHESZ_SHIFT                         (12U)
#define CIM_CPUINFO_DCACHESZ(x)                            (((uint32)(((uint32)(x)) << CIM_CPUINFO_DCACHESZ_SHIFT)) & CIM_CPUINFO_DCACHESZ_MASK)
#define CIM_CPUINFO_ICACHESZ_MASK                          (0xF00U)
#define CIM_CPUINFO_ICACHESZ_SHIFT                         (8U)
#define CIM_CPUINFO_ICACHESZ(x)                            (((uint32)(((uint32)(x)) << CIM_CPUINFO_ICACHESZ_SHIFT)) & CIM_CPUINFO_ICACHESZ_MASK)
#define CIM_CPUINFO_DTCMSZ_MASK                            (0xF0U)
#define CIM_CPUINFO_DTCMSZ_SHIFT                           (4U)
#define CIM_CPUINFO_DTCMSZ(x)                              (((uint32)(((uint32)(x)) << CIM_CPUINFO_DTCMSZ_SHIFT)) & CIM_CPUINFO_DTCMSZ_MASK)
#define CIM_CPUINFO_ITCMSZ_MASK                            (0xFU)
#define CIM_CPUINFO_ITCMSZ_SHIFT                           (0U)
#define CIM_CPUINFO_ITCMSZ(x)                              (((uint32)(((uint32)(x)) << CIM_CPUINFO_ITCMSZ_SHIFT)) & CIM_CPUINFO_ITCMSZ_MASK)
/* CIM_BOOT_CFG Register */
#define CIM_BOOT_CFG_INITAHBPEN_MASK                       (0x40000000U)
#define CIM_BOOT_CFG_INITAHBPEN_SHIFT                      (30U)
#define CIM_BOOT_CFG_INITAHBPEN(x)                         (((uint32)(((uint32)(x)) << CIM_BOOT_CFG_INITAHBPEN_SHIFT)) & CIM_BOOT_CFG_INITAHBPEN_MASK)
#define CIM_BOOT_CFG_INITDTCMRMWEN_MASK                    (0x8000000U)
#define CIM_BOOT_CFG_INITDTCMRMWEN_SHIFT                   (27U)
#define CIM_BOOT_CFG_INITDTCMRMWEN(x)                      (((uint32)(((uint32)(x)) << CIM_BOOT_CFG_INITDTCMRMWEN_SHIFT)) & CIM_BOOT_CFG_INITDTCMRMWEN_MASK)
#define CIM_BOOT_CFG_INITITCMRMWEN_MASK                    (0x4000000U)
#define CIM_BOOT_CFG_INITITCMRMWEN_SHIFT                   (26U)
#define CIM_BOOT_CFG_INITITCMRMWEN(x)                      (((uint32)(((uint32)(x)) << CIM_BOOT_CFG_INITITCMRMWEN_SHIFT)) & CIM_BOOT_CFG_INITITCMRMWEN_MASK)
#define CIM_BOOT_CFG_INITDTCMEN_MASK                       (0x2000000U)
#define CIM_BOOT_CFG_INITDTCMEN_SHIFT                      (25U)
#define CIM_BOOT_CFG_INITDTCMEN(x)                         (((uint32)(((uint32)(x)) << CIM_BOOT_CFG_INITDTCMEN_SHIFT)) & CIM_BOOT_CFG_INITDTCMEN_MASK)
#define CIM_BOOT_CFG_INITITCMEN_MASK                       (0x1000000U)
#define CIM_BOOT_CFG_INITITCMEN_SHIFT                      (24U)
#define CIM_BOOT_CFG_INITITCMEN(x)                         (((uint32)(((uint32)(x)) << CIM_BOOT_CFG_INITITCMEN_SHIFT)) & CIM_BOOT_CFG_INITITCMEN_MASK)
#define CIM_BOOT_CFG_SECURE_BOOT_CFG_MASK                  (0x300000U)
#define CIM_BOOT_CFG_SECURE_BOOT_CFG_SHIFT                 (20U)
#define CIM_BOOT_CFG_SECURE_BOOT_CFG(x)                    (((uint32)(((uint32)(x)) << CIM_BOOT_CFG_SECURE_BOOT_CFG_SHIFT)) & CIM_BOOT_CFG_SECURE_BOOT_CFG_MASK)
#define CIM_BOOT_CFG_BOOT_SEL_MASK                         (0xE0000U)
#define CIM_BOOT_CFG_BOOT_SEL_SHIFT                        (17U)
#define CIM_BOOT_CFG_BOOT_SEL(x)                           (((uint32)(((uint32)(x)) << CIM_BOOT_CFG_BOOT_SEL_SHIFT)) & CIM_BOOT_CFG_BOOT_SEL_MASK)


/**
 * @}
 */ /* end of group CIM_Register_Masks */


/**
 * @}
 */ /* end of group CIM_Peripheral_Access_Layer */

#endif /* PSIP_CIM_H */

