/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file vector_table_copy.c
 * @brief 
 * 
 */

#include "Platform_Types.h"
#include "OsIf.h"
#include "YTM32B1HA0_features.h"

static volatile uint32 * const s_vectors[NUMBER_OF_CORES] = FEATURE_INTERRUPT_INT_VECTORS;
extern uint32 IVT_RAM_start[1U];
extern uint32 IVT_start[1U];
extern uint32 IVT_end[1U];

void VectorTableCopy(void)
{
    uint8 coreId = (uint8)OsIf_GetCoreID();
    uint32* ramStart = (uint32*)IVT_RAM_start;
    const uint32* romStart = (const uint32*)IVT_start;
    uint32 size=((uint32)IVT_end-(uint32)IVT_start)/sizeof(uint32);
    (void)s_vectors;

    for (uint32 n = 0; n < size; n++)
    {
        ramStart[n] = romStart[n];
    }
    *s_vectors[coreId] = (uint32)IVT_RAM_start;
}

void DefaultISR(void)
{
   while(1){};
}

#ifndef USING_OS_AUTOSAROS
__attribute__ ((weak)) void NMI_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void HardFault_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void MemManage_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void BusFault_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void UsageFault_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SVC_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DebugMon_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void PendSV_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SysTick_Handler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA2_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA4_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA6_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA8_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA9_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA10_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA11_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA12_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA13_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA14_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA15_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA16_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA17_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA18_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA19_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA20_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA21_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA22_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA23_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA24_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA25_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA26_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA27_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA28_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA29_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA30_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA31_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void DMA_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void FPU_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void EFM_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void EFM_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void PCU_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void EFM_Ecc_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void Wdg_Lld_Isr(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void I2C0_Master_Slave_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SPI0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SPI1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SPI2_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void I2C1_Master_Slave_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD2_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void QSPI_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void ADC0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void ADC1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void ACMP0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void ACMP1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void EMU_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void RTC_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void RTC_Seconds_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR0_Ch0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR0_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR0_Ch2_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR0_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void PTU0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR1_Ch0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR1_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR1_Ch2_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR1_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SCU_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void lpTMR0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void GPIOA_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void GPIOB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void GPIOC_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void GPIOD_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void GPIOE_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void PTU1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_Wake_Up_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_0_15_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_16_31_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_32_47_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_48_63_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_64_79_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_80_95_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_96_111_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN0_ORed_112_127_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_Wake_Up_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_0_15_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_16_31_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_32_47_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_48_63_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_64_79_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_80_95_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_96_111_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN1_ORed_112_127_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN2_ORed_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN2_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN2_Wake_Up_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN2_ORed_0_15_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN2_ORed_16_31_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN2_ORed_32_47_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN2_ORed_48_63_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR0_Ch0_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR0_Ch2_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR0_Ch4_Ch5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR0_Ch6_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR0_Fault_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR0_Ovf_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR1_Ch0_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR1_Ch2_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR1_Ch4_Ch5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR1_Ch6_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR1_Fault_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR1_Ovf_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR2_Ch0_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR2_Ch2_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR2_Ch4_Ch5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR2_Ch6_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR2_Fault_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR2_Ovf_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR3_Ch0_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR3_Ch2_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR3_Ch4_Ch5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR3_Ch6_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR3_Fault_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR3_Ovf_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR4_Ch0_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR4_Ch2_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR4_Ch4_Ch5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR4_Ch6_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR4_Fault_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR4_Ovf_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR5_Ch0_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR5_Ch2_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR5_Ch4_Ch5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR5_Ch6_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR5_Fault_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void eTMR5_Ovf_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR2_Ch0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR2_Ch1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR2_Ch2_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void pTMR2_Ch3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SENT0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SENT1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void FMU_Alarm_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void FMU_MISC_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void TRNG_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void HCU_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void INTM_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void TMR0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD4_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void I2C2_Master_Slave_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SPI3_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SPI4_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SPI5_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN3_ORed_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN3_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN3_Wake_Up_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN3_ORed_0_15_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN3_ORed_16_31_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN3_ORed_32_47_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN3_ORed_48_63_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN4_ORed_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN4_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN4_Wake_Up_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN4_ORed_0_15_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN4_ORed_16_31_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN4_ORed_32_47_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN4_ORed_48_63_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN5_ORed_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN5_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN5_Wake_Up_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN5_ORed_0_15_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN5_ORed_16_31_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void WKU_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD6_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD8_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void LINFlexD9_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SPI6_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SPI7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void I2C3_Master_Slave_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void I2C4_Master_Slave_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN6_ORed_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN6_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN6_Wake_Up_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN6_ORed_0_15_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN6_ORed_16_31_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void TMR1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CORE_CTI_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SAI0_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void SAI1_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void ENET_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void ENET_TX_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void ENET_RX_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void ENET_ECC_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN7_ORed_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN7_Error_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN7_Wake_Up_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN7_ORed_0_15_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void CAN7_ORed_16_31_MB_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void MPWM0_Ch0_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void MPWM0_Ch8_Ch15_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void MPWM1_Ch0_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void MPWM1_Ch8_Ch15_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void MPWM2_Ch0_Ch7_IRQHandler(void) 
{
    DefaultISR();
}
__attribute__ ((weak)) void MPWM2_Ch8_Ch15_IRQHandler(void) 
{
    DefaultISR();
}
#endif
