/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */
#ifndef FLS_QSPI_PBCFG_H
#define FLS_QSPI_PBCFG_H
/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Fls_Qspi_Types.h"
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_QSPI_VENDOR_ID_PBCFG               (180)
#define FLS_QSPI_AR_REL_MAJOR_VER_PBCFG        (4)
#define FLS_QSPI_AR_REL_MINOR_VER_PBCFG        (4)
#define FLS_QSPI_AR_REL_REVISION_VER_PBCFG     (0)
#define FLS_QSPI_SW_MAJOR_VER_PBCFG            (2)
#define FLS_QSPI_SW_MINOR_VER_PBCFG            (3)
#define FLS_QSPI_SW_PATCH_VER_PBCFG            (0)
/*==================================================================================================
*                                       MACROS DEFINITIONS
==================================================================================================*/
/*GT25QXX LUT sequence list*/
/*Read*/
#define GT25QXX_LUT_SEQUNCE_Read   (0U)
/*Write*/
#define GT25QXX_LUT_SEQUNCE_Write   (5U)
/*WriteEnable*/
#define GT25QXX_LUT_SEQUNCE_WriteEnable   (9U)
/*Erase4k*/
#define GT25QXX_LUT_SEQUNCE_Erase4k   (11U)
/*ReadSR1*/
#define GT25QXX_LUT_SEQUNCE_ReadSR1   (14U)
/*Reset*/
#define GT25QXX_LUT_SEQUNCE_Reset   (17U)
/*ReadDeviceId*/
#define GT25QXX_LUT_SEQUNCE_ReadDeviceId   (21U)
/*WriteSR*/
#define GT25QXX_LUT_SEQUNCE_WriteSR   (25U)
/*InitRest*/
#define GT25QXX_LUT_SEQUNCE_InitRest   (28U)
/*QuadRead*/
#define GT25QXX_LUT_SEQUNCE_QuadRead   (34U)
/*ReadSR2*/
#define GT25QXX_LUT_SEQUNCE_ReadSR2   (40U)
/*ReadSR3*/
#define GT25QXX_LUT_SEQUNCE_ReadSR3   (43U)
/*Erase1k*/
#define GT25QXX_LUT_SEQUNCE_Erase1k   (46U)
/*Erase32K*/
#define GT25QXX_LUT_SEQUNCE_Erase32K   (49U)
/*Erase64K*/
#define GT25QXX_LUT_SEQUNCE_Erase64K   (52U)
/*QuadWrite*/
#define GT25QXX_LUT_SEQUNCE_QuadWrite   (55U)
/*DualRead*/
#define GT25QXX_LUT_SEQUNCE_DualRead   (60U)
/*WriteSR2*/
#define GT25QXX_LUT_SEQUNCE_WriteSR2   (65U)

/*Exit memory config list*/
#define FLS_QSPI_MEMORY_CFG_GT25QXX   (0U)

/*Exit Fls memory list */
#define FLS_QSPI_DEVICE_FlsMem_0   (0U)

/*==================================================================================================
*                                       EXTERN VARIABLES DECLARATIONS
==================================================================================================*/
extern const Qspi_MemoryConnectionType Fls_Qspi_ExtFlsConnectCfg[1];
extern const Qspi_ControllerConfigType Fls_Qspi_QspiUnitCfg[1];
extern const Qspi_MemoryConfigType Fls_Qspi_MemoryDeviceCfg[1];
#endif /* FLS_QSPI_PBCFG_H */