/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */

#include "Fls_Qspi_PBcfg.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_QSPI_VENDOR_ID_PBCFG_C               (180)
#define FLS_QSPI_AR_REL_MAJOR_VER_PBCFG_C        (4)
#define FLS_QSPI_AR_REL_MINOR_VER_PBCFG_C        (4)
#define FLS_QSPI_AR_REL_REVISION_VER_PBCFG_C     (0)
#define FLS_QSPI_SW_MAJOR_VER_PBCFG_C            (2)
#define FLS_QSPI_SW_MINOR_VER_PBCFG_C            (3)
#define FLS_QSPI_SW_PATCH_VER_PBCFG_C            (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and Fls_Qspi_PBcfg.h file are of the same vendor*/
#if (FLS_QSPI_VENDOR_ID_PBCFG_C != FLS_QSPI_VENDOR_ID_PBCFG)
#error "Fls_Qspi_PBcfg.h and Fls_PBcfg.h have different vendor ids"
#endif

/* Check if source file and Fls_Qspi_PBcfg.h file are of the same Autosar version */
#if ((FLS_QSPI_AR_REL_MAJOR_VER_PBCFG_C != FLS_QSPI_AR_REL_MAJOR_VER_PBCFG) || \
         (FLS_QSPI_AR_REL_MINOR_VER_PBCFG_C != FLS_QSPI_AR_REL_MINOR_VER_PBCFG) || \
         (FLS_QSPI_AR_REL_REVISION_VER_PBCFG_C != FLS_QSPI_AR_REL_REVISION_VER_PBCFG) \
        )
#error "AutoSar Version Numbers of Fls_Qspi_PBcfg.h and Fls_PBcfg.h are different"
#endif

/* Check if source file and Fls_Qspi_PBcfg.h file are of the same Software version */
#if ((FLS_QSPI_SW_MAJOR_VER_PBCFG_C != FLS_QSPI_SW_MAJOR_VER_PBCFG) || \
         (FLS_QSPI_SW_MINOR_VER_PBCFG_C != FLS_QSPI_SW_MINOR_VER_PBCFG) || \
         (FLS_QSPI_SW_PATCH_VER_PBCFG_C != FLS_QSPI_SW_PATCH_VER_PBCFG) \
        )
#error "Software Version Numbers of Fls_Qspi_PBcfg.h and Fls_PBcfg.h are different"
#endif

/*==================================================================================================
 *                                       Function Prototypes
==================================================================================================*/
#define FLS_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"
FLS_CONST const Qspi_MemoryConnectionType Fls_Qspi_ExtFlsConnectCfg[1] = 
{
    {
        .QspiInstance = 0,
        .ConnectionType = QSPI_SIDE_A,
        .MemAlignment = 1,
    },
};

FLS_CONST const Qspi_ControllerConfigType Fls_Qspi_QspiUnitCfg[1] = 
{
    {
        .DataRate = QSPI_DATA_RATE_SDR,
        .MemSizeA = 0x200000,
        .MemSizeB = 0x0,
        .CsHoldTime = 0,
        .CsSetupTime=0,
        .ColumnAddr =0,
        .WordAddresable = FALSE,
        .SampleDelay = 1,
        .SampleEdge = QSPI_RISING_EDGE_SAMPLE,
        .DqsLatencyEnable = FALSE,
        .DataAlign = QSPI_FLASH_DATA_ALIGN_REFCLK,
        .Endianess = QSPI_END_ALL_SWAP,
        .Io2IdleValueA = STD_HIGH,
        .Io3IdleValueA = STD_HIGH,
        .Io2IdleValueB = STD_HIGH,
        .Io3IdleValueB = STD_HIGH,
        .AhbConfig = 
            {
                {/*Masters*/
                    0, /* BUFFER 0 master ID*/
                    1, /* BUFFER 1 master ID*/
                    2, /* BUFFER 2 master ID*/
                    3, /* BUFFER 3 master ID*/
                },
                {/*Sizes*/
                    0, /* BUFFER 0 size*/
                    0, /* BUFFER 1 size*/
                    0, /* BUFFER 2 size*/
                    256, /* BUFFER 3 size*/
                },
                .AllMasters = FALSE,
                .HighPriority = FALSE,
            },
    },
};



FLS_CONST const Qspi_InstrOpType Fls_Qspi_GT25QXX_LutList[68] =
{
    /*Read*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x03),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_ADDR|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_READ|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x80),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_STOP|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x80),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*Write*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x02),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_ADDR|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_WRITE|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x10),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*WriteEnable*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x6),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*Erase4k*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x20),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_ADDR|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*ReadSR1*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x5),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_READ|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x1),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*Reset*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x66),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_STOP|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x0),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x99),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*ReadDeviceId*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x90),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_ADDR|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_READ|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x2),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*WriteSR*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x1),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_WRITE|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x1),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*InitRest*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0xAB),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_STOP|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x0),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x66),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_STOP|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x0),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x99),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*QuadRead*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0xEB),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_ADDR|(Qspi_InstrOpType)QSPI_LUT_PADS_4|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_MODE|(Qspi_InstrOpType)QSPI_LUT_PADS_4|(Qspi_InstrOpType)0xF0),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_DUMMY|(Qspi_InstrOpType)QSPI_LUT_PADS_4|(Qspi_InstrOpType)0x4),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_READ|(Qspi_InstrOpType)QSPI_LUT_PADS_4|(Qspi_InstrOpType)0x80),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*ReadSR2*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x35),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_READ|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x1),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*ReadSR3*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x15),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_READ|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x1),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*Erase1k*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x82),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_ADDR|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*Erase32K*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x52),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*Erase64K*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0xD8),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*QuadWrite*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x32),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_ADDR|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_WRITE|(Qspi_InstrOpType)QSPI_LUT_PADS_4|(Qspi_InstrOpType)0x10),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_STOP|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x0),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*DualRead*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0xBB),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_ADDR|(Qspi_InstrOpType)QSPI_LUT_PADS_2|(Qspi_InstrOpType)0x18),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_DUMMY|(Qspi_InstrOpType)QSPI_LUT_PADS_2|(Qspi_InstrOpType)0x4),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_READ|(Qspi_InstrOpType)QSPI_LUT_PADS_2|(Qspi_InstrOpType)0x80),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
    /*WriteSR2*/
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_CMD|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x31),
    (Qspi_InstrOpType)((Qspi_InstrOpType)QSPI_LUT_INSTR_WRITE|(Qspi_InstrOpType)QSPI_LUT_PADS_1|(Qspi_InstrOpType)0x01),
    (Qspi_InstrOpType)(QSPI_LUT_INSTR_STOP),
};

FLS_CONST const Qspi_MemoryConfigType Fls_Qspi_MemoryDeviceCfg[1]={
    {
        /*GT25QXX*/
        .MemSize = 0x200000U,
        .PageSize = 256U,
        .ReadLut = 34U,
        .WriteLut= 55U,
        .Read0xxLut = QSPI_LUT_INVALID,
        .Read0xxLutAHB = QSPI_LUT_INVALID,
        .ReadIdSettings = 
        {
            .ReadIdLut = 21U,
            .ReadIdSize = 2U,
            .ReadIdExpected = 0x14C4U,
        },
        .EraseSettings =
        {
            .EraseTypes=
            {
                {/*Erase type0*/
                    .EraseLut = 11U,
                    .Size = 12U,     
                },
                {/*Erase type1*/
                    .EraseLut = 46U,
                    .Size = 10U,
                },
                {/*Erase type3*/
                    .EraseLut = 49U,
                    .Size = 15U,
                },
                {/*Erase type4*/
                    .EraseLut = 52U,
                    .Size = 16U,
                },
            },
            .ChipEraseLut = QSPI_LUT_INVALID,
        },
        .StatusConfig =
        {
            .StatusRegInitReadLut = 14U, 
            .StatusRegReadLut = 14U,
            .StatusRegWriteLut = 25U,
            .WriteEnableSRLut = 9U,
            .WriteEnableLut = 9U,
            .RegSize = 1U,
            .BusyOffset = 0U,
            .BusyValue = 1U,
            .WriteEnableOffset = 1U,
            .BlockProtectionOffset = 2U,
            .BlockProtectionWidth = 4U,
            .BlockProtectionValue = 0U,
        },
        .SuspendSettings = 
        {
            .EraseSuspendLut = QSPI_LUT_INVALID,
            .EraseResumeLut = QSPI_LUT_INVALID,
            .ProgramSuspendLut = QSPI_LUT_INVALID,
            .ProgramResumeLut = QSPI_LUT_INVALID,
        },
        .ResetSettings = 
        {
            .ResetCmdLut = 17U,
            .ResetCmdCount = 2U,
        },
        .InitResetSettings = 
        {
            .ResetCmdLut = 28U,
            .ResetCmdCount = 3U,
        },
        .InitConfiguration = 
        {
            .OpCount = 0U,
            .Operations = NULL_PTR,
        },
        .LutSequences =
        {
            .OpCount = 68,
            .LutOps = Fls_Qspi_GT25QXX_LutList,
        },
        .InitCallout = NULL_PTR,
        .ResetCallout = NULL_PTR,
        .ErrorCheckCallout = NULL_PTR,
        .EccCheckCallout = NULL_PTR,
        .CtrlAutoCfgPtr = &Fls_Qspi_QspiUnitCfg[0],
    },
};

#define FLS_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"
