/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */
#ifndef FLS_QSPI_CFG_H
#define FLS_QSPI_CFG_H
/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_QSPI_VENDOR_ID_CFG               (180)
#define FLS_QSPI_AR_REL_MAJOR_VER_CFG        (4)
#define FLS_QSPI_AR_REL_MINOR_VER_CFG        (4)
#define FLS_QSPI_AR_REL_REVISION_VER_CFG     (0)
#define FLS_QSPI_SW_MAJOR_VER_CFG            (2)
#define FLS_QSPI_SW_MINOR_VER_CFG            (3)
#define FLS_QSPI_SW_PATCH_VER_CFG            (0)

/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/

/* Timeout for QSPI command completion */
#define QSPI_CMD_COMPLETE_TIMEOUT         (10000U)
/* Delay after changing the value of the QSPI software reset bits */
#define QSPI_SOFTWARE_RESET_DELAY         (100U)
/*! @brief Minimum delay in CPU cycles between Tx FIFO reset and Tx FIFO push */
#define QSPI_TX_BUFFER_RESET_DELAY        (100U)
/* Maximum number of retries for Write Enable command */
#define QSPI_MAX_RETRY                    (3U)
/* Timeout for external flash startup initialization sequence completion */
#define QSPI_FLS_INIT_TIMEOUT             (10000U)
/* Timeout for external flash software reset completion */
#define QSPI_RESET_TIMEOUT                (100U)
/* Timeout for a complete read operation */
#define QSPI_READ_TIMEOUT                 (2147483647U)


/* Number of serial flash devices */
#define QSPI_MEM_INSTANCE_COUNT           (1U)




/*QSPI hardware Features*/
#define FEATURE_QSPI_AMBA_BASE               (0x68000000U)

/*! @brief AHB base pointers initializer for all QSPI units */
#define QSPI_AHB_PTRS                        {FEATURE_QSPI_AMBA_BASE}

/*! @brief Size of AHB buffer. */
#define FEATURE_QSPI_AHB_BUF_SIZE            (256U)
 /*! @brief Size of Tx FIFO. */
#define FEATURE_QSPI_TX_BUF_SIZE                      128U
/*! @brief Size of Rx FIFO. */
#define FEATURE_QSPI_RX_BUF_SIZE                      128U
/* Minimum entries of 4 bytes fill needed to allow Tx operation to start */
#define FEATURE_QSPI_TX_MIN_BUF_FILL         4U
/*! @brief Number of LUT registers that make up a LUT sequence */
#define FEATURE_QSPI_LUT_SEQUENCE_SIZE                4U

#endif /* FLS_QSPI_CFG_H */