/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */

#include "Fls_Types.h"
#include "Fls_Qspi_PBcfg.h"
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_VENDOR_ID_PBCFG_C                      (180)
#define FLS_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define FLS_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define FLS_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define FLS_SW_MAJOR_VERSION_PBCFG_C               (2)
#define FLS_SW_MINOR_VERSION_PBCFG_C               (3)
#define FLS_SW_PATCH_VERSION_PBCFG_C               (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and Fls_Qspi_PBcfg.h file are of the same vendor*/
#if (FLS_VENDOR_ID_PBCFG_C != FLS_QSPI_VENDOR_ID_PBCFG)
#error "Fls_Qspi_PBcfg.h and Fls_PBcfg.h have different vendor ids"
#endif

/* Check if source file and Fls_Qspi_PBcfg.h file are of the same Autosar version */
#if ((FLS_AR_RELEASE_MAJOR_VERSION_PBCFG_C != FLS_QSPI_AR_REL_MAJOR_VER_PBCFG) || \
     (FLS_AR_RELEASE_MINOR_VERSION_PBCFG_C != FLS_QSPI_AR_REL_MINOR_VER_PBCFG) || \
     (FLS_AR_RELEASE_REVISION_VERSION_PBCFG_C != FLS_QSPI_AR_REL_REVISION_VER_PBCFG) \
    )
#error "AutoSar Version Numbers of Fls_Qspi_PBcfg.h and Fls_PBcfg.h are different"
#endif

/* Check if source file and Fls_Qspi_PBcfg.h file are of the same software version */
#if ((FLS_SW_MAJOR_VERSION_PBCFG_C != FLS_QSPI_SW_MAJOR_VER_PBCFG) || \
     (FLS_SW_MINOR_VERSION_PBCFG_C != FLS_QSPI_SW_MINOR_VER_PBCFG) || \
     (FLS_SW_PATCH_VERSION_PBCFG_C != FLS_QSPI_SW_PATCH_VER_PBCFG) \
    )
#error "Software Version Numbers of Fls_Qspi_PBcfg.h and Fls_PBcfg.h are different"
#endif
/*==================================================================================================
 *                                       Function Prototypes
==================================================================================================*/

#define FLS_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"
/*================================================================================================== */
FLS_CONST const Fls_SectorType Fls_SectorConfig[6] ={
    {
        .SectorId = FlsConf_FlsConfigSet_DFlsSector_0,
        .SectorStartAddress = 0x0U,
        .SectorSize = 0x400U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x6000000U,
        .PhySectorSize = 0x400U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_INTERN,
        .SectFlashUnit = FLS_DEVICE_INSTANCE_INVALID,
    },
    {
        .SectorId = FlsConf_FlsConfigSet_DFlsSector_1,
        .SectorStartAddress = 0x400U,
        .SectorSize = 0x400U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x6000400U,
        .PhySectorSize = 0x400U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_INTERN,
        .SectFlashUnit = FLS_DEVICE_INSTANCE_INVALID,
    },
    {
        .SectorId = FlsConf_FlsConfigSet_ExtFlsSector_1,
        .SectorStartAddress = 0x800U,
        .SectorSize = 0x1000U,
        .PageSize = 0x100U,
        .SectorHwStartAddress = 0x0U,
        .PhySectorSize = 0x1000U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_QSPI,
        .SectFlashUnit = FLS_QSPI_DEVICE_FlsMem_0,
    },
    {
        .SectorId = FlsConf_FlsConfigSet_ExtFlsSector_2,
        .SectorStartAddress = 0x1800U,
        .SectorSize = 0x1000U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x1000U,
        .PhySectorSize = 0x1000U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_QSPI,
        .SectFlashUnit = FLS_QSPI_DEVICE_FlsMem_0,
    },
    {
        .SectorId = FlsConf_FlsConfigSet_ExtFlsSector_3,
        .SectorStartAddress = 0x2800U,
        .SectorSize = 0x1000U,
        .PageSize = 0x100U,
        .SectorHwStartAddress = 0x2000U,
        .PhySectorSize = 0x1000U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_QSPI,
        .SectFlashUnit = FLS_QSPI_DEVICE_FlsMem_0,
    },
    {
        .SectorId = FlsConf_FlsConfigSet_ExtFlsSector_4,
        .SectorStartAddress = 0x3800U,
        .SectorSize = 0x1000U,
        .PageSize = 0x100U,
        .SectorHwStartAddress = 0x3000U,
        .PhySectorSize = 0x1000U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_QSPI,
        .SectFlashUnit = FLS_QSPI_DEVICE_FlsMem_0,
    },
};


FLS_CONST static const Fls_QspiFlsMenConfigType Fls_ExitDeviceConnectCfg[1] = 
{
    {
        .FlashConnectionCfg = &Fls_Qspi_ExtFlsConnectCfg[FLS_QSPI_MEMORY_CFG_GT25QXX],
        .FlashUnitId = FLS_QSPI_MEMORY_CFG_GT25QXX,
        .AHBReadCfg = FALSE,
    },
};
FLS_CONST static const uint8 Fls_ExitDeviceQspiChnList[1] = {
    0U,
};

FLS_CONST static const Fls_ExtFlsConfigType Fls_ExitDevicesCfg = {
    .FlashUnitsCount = 1,
    .FlashMemCfg = Fls_ExitDeviceConnectCfg,
    .FlashConfigCount = 1,
    .MemCfg = Fls_Qspi_MemoryDeviceCfg,
    .QspiUnitsCount = 1,
    .QspiConfig = Fls_ExitDeviceQspiChnList,
    .QspiConfigCount = 1,
    .QspiUnitCfg = Fls_Qspi_QspiUnitCfg,
};

FLS_CONST const Fls_ConfigType Fls_Config = {
    .AcEraseFunPtr = NULL_PTR,
    .AcWriteFunPtr = NULL_PTR,
    .JobEndNotificationFunPtr = NULL_PTR,
    .JobErrorNotificationFunPtr = NULL_PTR,
    .DefaultMode = MEMIF_MODE_SLOW,
    .MaxReadFastMode = 10240U,
    .MaxReadNormalMode = 1024U,
    .MaxWriteFastMode = 256U,
    .MaxWriteNormalMode = 256U,
    .ConfiguredSectorNumber = 6U,
    .SectorList = Fls_SectorConfig,
    .ExtFlsCfgConfig = &Fls_ExitDevicesCfg
};

#define FLS_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"

