/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * @file main.c
 * @brief
 *
*/

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "Fls_Lld_QspiFls.h"
#include "Fls_Lld_Qspi.h"
#include "MemIf_Types.h"
#include "Platform_Types.h"
#include "Std_Types.h"


/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
#define QSPI_FISRT_SECTOR_ADDRESS (0x800U)

#define DFLS_SECOND_SECTOR_ADDRESS (0x400U)
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
uint8  Fls_TestReadBuffer[1024];

uint8 Fls_TestWriteBuffer[1024];

uint8 GT250Q_Regs[3];

Qspi_StatusType GT25Q_Status;

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    uint16 LoopCnt = 0;
    Std_ReturnType RetVal = E_NOT_OK;
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0);
#if (MCU_NO_PLL == STD_OFF)
    while (MCU_PLL_LOCKED != Mcu_GetPllStatus())
    {
        /* Wait until PLL is locked */
    }
    Mcu_DistributePllClock();
#endif
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    /*Test erase and write a external flash page size*/
    /*erase a sector*/
    RetVal = Fls_Erase(QSPI_FISRT_SECTOR_ADDRESS, 0x1000U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    /*write a page data*/
    for (LoopCnt = 0; LoopCnt < 1024U; LoopCnt++)
    {
        Fls_TestWriteBuffer[LoopCnt] = LoopCnt % 0x100;
        Fls_TestReadBuffer[LoopCnt] = 0U;
    }
    RetVal = Fls_Write(QSPI_FISRT_SECTOR_ADDRESS, Fls_TestWriteBuffer, 0x400U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    /*Read a page data*/
    RetVal = Fls_Read(QSPI_FISRT_SECTOR_ADDRESS, Fls_TestReadBuffer, 0x400U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    /*check read result*/
    for (LoopCnt = 0; LoopCnt < 1024U; LoopCnt++)
    {
        if (Fls_TestReadBuffer[LoopCnt] != Fls_TestWriteBuffer[LoopCnt])
        {
            while (1)
            {
                __ASM("NOP");
            }
        }
    }
    /*erase,write,read tow sectors consecutively*/
    RetVal = Fls_Erase(QSPI_FISRT_SECTOR_ADDRESS, 0x2000U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    RetVal = Fls_BlankCheck(QSPI_FISRT_SECTOR_ADDRESS, 0x2000U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    RetVal = Fls_Write(QSPI_FISRT_SECTOR_ADDRESS, (uint8 *)0x02010000U, 0x2000U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    RetVal = Fls_Compare(QSPI_FISRT_SECTOR_ADDRESS, (uint8 *)0x02010000U, 0x2000U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    /*The internal flash sector and external flash sector mux erase,write ,read and compare */
    RetVal = Fls_Erase(DFLS_SECOND_SECTOR_ADDRESS, 0x1400U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    /*read internal sector last 0x10 byte and external sector first 0xA0 byte*/
    RetVal = Fls_Read(0x7F0, Fls_TestReadBuffer, 0x100U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    for (LoopCnt = 0; LoopCnt < 256U; LoopCnt++)
    {
        if (Fls_TestReadBuffer[LoopCnt] != 0xFFU)
        {
            while (1)
            {
                __ASM("NOP");
            }
        }
    }
    /*Check blank*/
    RetVal = Fls_BlankCheck(DFLS_SECOND_SECTOR_ADDRESS, 0x1400U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    /*Write data*/
    RetVal = Fls_Write(0x7F8, (uint8 *)0x02010000U, 0x108U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    RetVal = Fls_Compare(0x7F8, (uint8 *)0x02010000U, 0x108U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    RetVal = Fls_Read(0x7F8, Fls_TestReadBuffer, 0x100U);
    if (E_OK != RetVal)
    {
        while (1)
        {
            __ASM("NOP");
        }
    }
    do
    {
        Fls_MainFunction();
    } while (Fls_GetStatus() == MEMIF_BUSY);
    while (Fls_GetJobResult() != MEMIF_JOB_OK)
    {
        __ASM("NOP");
    }
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    Port_Init(&Port_Config);
    Platform_Init(NULL_PTR);
    Fls_Init(&Fls_Config);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
