# Fls示例代码

## 工程名称：Fls_Qspi_Demo

---
## 功能描述

本示例用于演示 MCAL Fls 模块中QSPI的配置和使用:

- **Fls**: 
  - 根据 EVB上外置SPI Nor Flash 特性配置QSPI相关参数以及LUT；
  - 配置 外置SPI  Nor Flash扇区和 DFLASH 扇区；
  - 测试 EVB上外置SPI Nor Flash 的擦除、写入、读取、比较以及空白检查等操作；
  - 测试 外置SPI  Nor Flash扇区和 DFLASH 扇区混合擦除，写入，读取等操作；

复位后，初始化 Fls 模块并执行以下测试:
+ 擦除在 Fls_Config 中配置的SPI Nor Flash扇区0；
+ 将 256 字节数据写入SPI Nor Flash扇区0中，写入完成后读取SPI Nor Flash扇区0中数据，并与写入的数据逐一进行一致性检查；
+ 擦除在 Fls_Config 中配置的SPI Nor Flash扇区0和扇区1，并在擦除完成后，进行空扇区检查； 
+ 向扇区0和扇区1中写入4096字节数据，并在写入完成后使用Fls_Compare进行数据正确性检查；
+ 再次擦除在 Fls_Config 中配置的DFLASH扇区1以及SPI Nor Flash扇区0，擦除完成后，进行空白扇区检查，并读取虚拟地址0x7F0开始的256字节数据，检查是否全为0xFF；
+ 向0x7F8开始的262字节空间中写入数据，写入完成后再读出数据，并检查写入数据是否正确；


---


## 操作步骤

+ ***步骤1***：使用 YCT 工具打开示例的配置工程文件（`Fls_Qspi_Demo.yct`），根据您的需求配置工具链（默认使用 VS Code + GCC）。
+ ***步骤2***：生成代码，如果需要，您可以更改配置（以适应您自己的硬件设计），如果这样做，请确保所有修改都正确无误，并且在生成代码之前没有错误存在。
+ ***步骤3***：根据您的配置，使用相应的工具（VS Code/IAR/Keil IDE）打开生成的工程。
+ ***步骤4***：编译生成的工程，打开 EVB 电源并通过可用的调试器（如 J-Link 调试探针）将编译好的可执行文件下载到 EVB。
+ ***步骤5***：调试、运行示例代码。
  
---

## 硬件需求
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **调试器**：J-Link HW v9 或更高版本，安装了 YUNTU `YTM32B1HA01` 补丁（支持包）。

---

## 软件需求

+ **配置和代码生成工具**
  + **MCAL**: Yuntu Config Tool(YCT) v2.7.0 或更高版本
+ **编译器工具链**
  + **GCC**: GNU GCC v10.3 或更高版本
  + **Keil/MDK**: ARM Keil/MDK v5.36 或更高版本(编译器推荐使用`armclang v6.18.2`)
  + **IAR**: IAR v9.50 或更高版本
  + **VS Code**: Microsoft Visual Studio Code IDE v1.76 或更高版本（需要 C/C++ 支持，GNU 工具链，CMake v3.25，ninja，Cortex-Debug 扩展安装）
+ **Debugger driver**
    + **J-Link**: SEGGER J-Link v7.82 或更高版本，需要安装 YUNTU `YTM32B1HA01` 补丁（支持包）。
    + **Ozone Debugger tool**: SEGGER Ozone v3.28 或更高版本。

    ***注意***: 需要安装 **YTM32B1HA0** 补丁，补丁可通过 **YCT** 工具或联系 ***云途 销售/FAE 团队***获取.


---