# Fls Example Code

## Project Name：Fls_Qspi_Demo


---


## Function description

This project is designed to demonstrate the configuration and usage of QSPI in MCAL Fls module:

- **Fls**: 
  - Configure QSPI parameters and LUT based on the characteristics of the external SPI Nor Flash on the EVB
  - Configure the external SPI Nor Flash sectors and DFLASH sectors
  - Test the erase, write, read, compare, and blank check operations on the external SPI Nor Flash on the EVB.
  - Test mixed erase, write, and read operations on the external SPI Nor Flash sectors and DFLASH sectors.

After reset, the demo project initializes the Fls driver and performs the following tests:
+ Erase sector 0 of the SPI Nor Flash configured in Fls_Config.
+ Write 256 bytes of data to sector 0 of the SPI Nor Flash, read the data back from sector 0 after writing, and perform a consistency check by comparing it with the written data.
+ Erase sector 0 and sector 1 of the SPI Nor Flash configured in Fls_Config, and after erasing, perform a blank check.
+ Write 4096 bytes of data to sectors 0 and 1, and after writing, use Fls_Compare to check the correctness of the data.
+ Erase sector 1 of the DFLASH and sector 0 of the SPI Nor Flash configured in Fls_Config again. After erasing, perform a blank sector check and read 256 bytes of data starting from virtual address 0x7F0 to check if they are all 0xFF.
+ Write data to the 262-byte space starting from 0x7F8, read the data back after writing, and check if the written data is correct.

---


## Setup

+ ***Step1***: Open the `Fls_Qspi_Demo.yct` with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***：Generate the codes， you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-Link debugger probe.
+ ***Step5***: At last, enjoy the demo example.
  
---

## Hardware Requirements
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **Debugger**: J-Link HW v9 or higher, with YUNTU `YTM32B1HA01` patch (support package) installed.

---

## Software Requirements

+ **Configuration and Code Generation Tools**
  + **MCAL**: Yuntu Config Tool (YCT) v2.7.0 or higher
+ **Compiler Toolchain**
  + **GCC**: GNU GCC v10.3.1 or higher
  + **Keil/MDK**: ARM Keil/MDK v5.36 or higher(`armclang v6.18.2` is recommended to be used as the compiler)
  + **IAR**: IAR v9.50 or higher
  + **VS Code**: Microsoft Visual Studio Code IDE v1.76 or higher (requires C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extension installed)
+ **Debugger Driver**
    + **J-Link**: SEGGER J-Link v7.82 or higher, with YUNTU `YTM32B1HA01` patch (support package) installed.
    + **Ozone Debugger Tool**: SEGGER Ozone v3.28 or higher.

    ***Note***: The **YTM32B1HA0** patch needs to be installed, which can be obtained through the **YCT** tool or by contacting the ***Yuntu Sales/FAE team***.


---