/**
*   @file    Compliler_Cfg.h
*   @version
*
*   @brief   AUTOSAR compliler config
*
*   @addtogroup PLATFORM_GENERAL
*   @{
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V2.3.0
*
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/

/*==================================================================================================
*                                           CONSTANTS
==================================================================================================*/

/*==================================================================================================
*                                       DEFINES AND MACROS
==================================================================================================*/

#ifndef COMPILER_CFG_H
#define COMPILER_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

#if defined ( __CC_ARM )

/* ARM Compiler 4/5 */
#define __ARM_DS5_C_YTM32B1MXX 1

#elif defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)

/* ARM Compiler 6 */
#define __ARM_C6_C_YTM32B1MXX  1

#elif defined ( __ICCARM__ )

/* IAR Compiler */
#define __IAR_C_YTM32B1MXX     1

#elif defined ( __GNUC__ )

/* GNU Compiler */
#define __GNU_C_YTM32B1MXX     1  /* PRQA S 0602, 0603 */

#elif defined ( __ghs__ )

/* GreenHills Compiler */
#define __GHS_C_YTM32B1MXX     1

#endif

#ifdef __cplusplus
}
#endif

/*==================================================================================================
*                                            ENUMS
==================================================================================================*/

/*==================================================================================================
*                                 STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/

/*==================================================================================================
*                                 STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/

/*==================================================================================================
*                                     FUNCTION PROTOTYPES
==================================================================================================*/

#endif /* COMPILER_CFG_H */
/** @} */

