/*
* @file    Fls_Lld_QspiFls.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Fls_Lld_QspiFls
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.3.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef FLS_LLD_QSPIFLS_H
#define FLS_LLD_QSPIFLS_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Fls_Types.h"
#include "Fls_Qspi_Types.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_LLD_QSPIFLS_VENDOR_ID                     (180)
#define FLS_LLD_QSPIFLS_AR_REL_MAJOR_VER              (4)
#define FLS_LLD_QSPIFLS_AR_REL_MINOR_VER              (4)
#define FLS_LLD_QSPIFLS_AR_REL_REVISION_VER           (0)
#define FLS_LLD_QSPIFLS_SW_MAJOR_VER                  (2)
#define FLS_LLD_QSPIFLS_SW_MINOR_VER                  (3)
#define FLS_LLD_QSPIFLS_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/* Counters for timeout detection */
extern uint32  Fls_Qspi_ElapsedTicks;
extern uint32  Fls_Qspi_TimeoutTicks;
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/

/**
 * @brief   Main function for handling QSPI jobs.
 * @param   void
 * @return  void
 */
extern void Fls_Lld_LLDMainFunctionQspiJobs(void);
/**
 * @brief   Erase a sector in extern flash device.
 * @details This function erases a sector in extern flash device.
 * @param[in]   AsynchEnable           Asynchronous operation enable flag
 * @param[in]   SectorOffset           Sector offset in bytes
 * @param[in]   PhysicalSectorSize     Physical sector size in bytes
 * @return  Fls_Lld_ReturnType
 */
extern Fls_Lld_ReturnType Fls_Lld_SectorEraseQspiJobs(boolean AsynchEnable,
        Fls_AddressType SectorOffset,
        const Fls_LengthType PhysicalSectorSize);
/**
 * @brief   Write data to extern flash device.
 * @details This function writes data to extern flash device.
 * @param[in]   SectorOffset           Sector offset in bytes
 * @param[in]   Length                 Length of data to be written in bytes
 * @param[in]   JobDataSrcPtr          Pointer to the source buffer
 * @param[in]   AsynchEnable           Asynchronous operation enable flag
 * @return  Fls_Lld_ReturnType
 */
extern Fls_Lld_ReturnType Fls_Lld_SectorWriteQspiJobs(const Fls_AddressType SectorOffset,
        const Fls_AddressType Length,
        const uint8 *JobDataSrcPtr,
        const boolean AsynchEnable
                                                     );
/**
 * @brief   Initialize QSPI controllers
 * @param   void
 * @return  Qspi_StatusType
 */
extern Qspi_StatusType Fls_Lld_InitControllers(void);

/**
 * @brief   Initialize Qspi external flash devices
 * @param   void
 * @return  Qspi_StatusType
 */
extern Qspi_StatusType Fls_Lld_InitMemories(void);

/**
 * @brief   Check the identification of the external flash device against the configured one.
 * @param   void
 * @return  boolean
 */
extern boolean Fls_Lld_CheckDevicesId(void);

#ifdef __cplusplus
}
#endif

#endif /* End of file Fls_Lld_QspiFls.h */
