/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file rtc_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "rtc_config.h"


/*rtc_config0*/











static rtc_alarm_config_t rtc_config0Alarm={
    .alarmTime={
        .year=2023,
        .month=10,
        .day=1,
        .hour=13,
        .minutes=37,
        .seconds=22
    },
    .repetitionInterval=2,
    .numberOfRepeats=0,
    .repeatForever=false,
    .alarmIntEnable=false,
    .rtcAlarmCallback=NULL,
    .callbackParams=NULL,
};

static rtc_overflow_config_t rtc_config0Overflow={
    .overflowIntEnable=false,
    .rtcOverflowCallback=NULL,
    .callbackParams=NULL,
};

static rtc_seconds_config_t rtc_config0Seconds={
    .secondsIntConfig=RTC_INT_1HZ,
    .secondsIntEnable=false,
    .rtcSecondsCallback=NULL,
    .callbackParams=NULL,
};


const rtc_init_config_t rtc_config0 = {
    .compensationInterval=0,
    .compensation=0,
    .clockSource=RTC_CLK_SRC_OSC_32KHZ,
    .clockOutConfig=RTC_CLKOUT_SRC_SEC,
    .debugEnable=true,
    .rtcAlarmConfig=&rtc_config0Alarm,
    .rtcOverflowConfig=&rtc_config0Overflow,
    .rtcSecondsConfig=&rtc_config0Seconds,
};

