/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics Co., Ltd.
 *  All rights reserved.
 * 
 *  SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "printf.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define WKU_INST (0U)
#define POWERDOWN_MODE (1U)
#define RTC_INST       (0U)
#define LOW_POWER_MODE POWERDOWN_MODE

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
volatile uint32_t wkuSts = 0;
volatile bool isFirstBoot = true; // 新增：首次启动标志
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void WKU_IRQHandler(void)
{
    /* Wakeup from power down mode, MCU will enter WKU ISR */
    wkuSts = WKU->PFR[0];
    /* Clear status */
    WKU->PFR[0] = WKU->PFR[0];
    /* Add DSB to avoid re-entry irq */
    __DSB();

    isFirstBoot = false; // 唤醒后标记为非首次启动
}
/*
 * @brief 将时间日期结构体打包并写入REGFILE备份寄存器
 * @param timedate_ptr 指向 rtc_timedate_t 结构体的指针
 * @param base_addr REGFILE基地址 (0x40061000U)
 */
void Write_TimeDate_to_REGFILE(const rtc_timedate_t *timedate_ptr, REGFILE_Type *base_addr)
{
    // 写入DR0: 完整的年份 (2023)
    base_addr->DR[0] = (uint32_t)(timedate_ptr->year);

    // 打包并写入DR1: 高16位为day(1), 低16位为month(10)
    base_addr->DR[1] = ((uint32_t)(timedate_ptr->day) << 16) | (uint32_t)(timedate_ptr->month);

    // 打包并写入DR2: 依次为seconds(20), minutes(37), hour(13)
    base_addr->DR[2] = ((uint32_t)(timedate_ptr->seconds) << 16) |
                       ((uint32_t)(timedate_ptr->minutes) << 8) |
                       (uint32_t)(timedate_ptr->hour);

    // DR3~DR7
    base_addr->DR[3] = 0x00000000U;
    base_addr->DR[4] = 0x00000000U;
    base_addr->DR[5] = 0x00000000U;
    base_addr->DR[6] = 0x00000000U;
}

/**
 * @brief 从REGFILE备份寄存器读取并解包到时间日期结构体
 * @param timedate_ptr 指向 rtc_timedate_t 结构体的指针（用于输出）
 * @param base_addr REGFILE基地址 (0x40061000U)
 */
void Read_TimeDate_from_REGFILE(rtc_timedate_t *timedate_ptr, const REGFILE_Type *base_addr)
{
    // 从DR0读取年份
    timedate_ptr->year = (uint16_t)(base_addr->DR[0]);

    // 从DR1解包: 低16位是month, 高16位是day
    timedate_ptr->month = (uint16_t)(base_addr->DR[1] & 0xFFFFU);
    timedate_ptr->day = (uint16_t)((base_addr->DR[1] >> 16) & 0xFFFFU);

    // 从DR2解包: 依次为hour, minutes, seconds
    timedate_ptr->hour = (uint16_t)(base_addr->DR[2] & 0xFFU);
    timedate_ptr->minutes = (uint16_t)((base_addr->DR[2] >> 8) & 0xFFU);
    timedate_ptr->seconds = (uint8_t)((base_addr->DR[2] >> 16) & 0xFFU);
}

/**
 * @brief 计算两个时间点之间的时间差（Power Down时间）
 */
static void CalculatePowerDownTime(const rtc_timedate_t *startTime, const rtc_timedate_t *endTime)
{
    uint32_t totalSecondsStart = startTime->seconds + 
                                startTime->minutes * 60 + 
                                startTime->hour * 3600;
    
    uint32_t totalSecondsEnd = endTime->seconds + 
                              endTime->minutes * 60 + 
                              endTime->hour * 3600;
    
    uint32_t timeDiffSeconds = totalSecondsEnd - totalSecondsStart;
    
    
    if (timeDiffSeconds < 0) 
    {
        timeDiffSeconds += 24 * 3600;
    }
    
    uint32_t hours = timeDiffSeconds / 3600;
    uint32_t minutes = (timeDiffSeconds % 3600) / 60;
    uint32_t seconds = timeDiffSeconds % 60;
    
    PRINTF("Power Down Time: %02lu:%02lu:%02lu\n", hours, minutes, seconds);
    PRINTF("Total seconds in power down: %lu\n", timeDiffSeconds);
}

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    const rtc_timedate_t currentTime = { .year = 2023, .month = 10, .day = 1, .hour = 13, .minutes = 37, .seconds = 20 };

    REGFILE_Type *regfile_base = (REGFILE_Type *)0x40061000U;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */

    /* if POR or Reset pin */
    if ((RCU_RSSR_POR_LVD_MASK | RCU_RSSR_PIN_MASK) & RCU->RSSR)
    {
        //PRINTF("POR or PIN reset.\n");
        RCU->RSSR = RCU_RSSR_POR_LVD_MASK | RCU_RSSR_PIN_MASK;
        isFirstBoot = true;
    }
    else
    {
        isFirstBoot = false;
        REGFILE->DR[7]++;
        PRINTF("Powerdown wakeup count: %lu\n", REGFILE->DR[7]);
    }

    if(isFirstBoot)
    {
        RTC_DRV_Deinit(RTC_INST);
        RTC_DRV_Init(RTC_INST, &rtc_config0);
        RTC_DRV_SetTimeDate(RTC_INST, &currentTime);
        RTC_DRV_StartCounter(RTC_INST);
    }

    if(!isFirstBoot)
    {
        // 唤醒后：读取保存的时间，获取当前时间，计算时间差
        rtc_timedate_t savedTime;
        rtc_timedate_t currentTime;
        
        // 读取进入低功耗前保存的时间
        Read_TimeDate_from_REGFILE(&savedTime, regfile_base);
        PRINTF("Time before power down: %04u-%02u-%02u %02u:%02u:%02u\n", 
               savedTime.year, savedTime.month, savedTime.day,
               savedTime.hour, savedTime.minutes, savedTime.seconds);
        
        // 获取当前RTC时间
        RTC_DRV_GetCurrentTimeDate(RTC_INST, &currentTime);
        PRINTF("Current RTC time: %04u-%02u-%02u %02u:%02u:%02u\n", 
               currentTime.year, currentTime.month, currentTime.day,
               currentTime.hour, currentTime.minutes, currentTime.seconds);
        
        // 计算Power Down时间
        CalculatePowerDownTime(&savedTime, &currentTime);

    }

    WKU_DRV_InitReset(WKU_INST, &wkup_resetConfig0);
    WKU_DRV_InitPinWakeup(WKU_INST, WKP_PIN_CH_NUM0, wkup_pinsConfig0);

    Write_TimeDate_to_REGFILE(&currentTime, regfile_base);
    OSIF_TimeDelay(5000);
    POWER_SYS_SetMode(LOW_POWER_MODE, POWER_MANAGER_POLICY_AGREEMENT);
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    return status;
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    if(STATUS_SUCCESS != CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT))
    {
        /* USER CODE BEGIN ERROR_HANDLER 1 */
        SystemSoftwareReset();
        /* USER CODE END ERROR_HANDLER 1 */
    }
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
    POWER_SYS_Init(&powerConfigsArr,POWER_MANAGER_CONFIG_CNT,NULL,POWER_MANAGER_CALLBACK_CNT);
    INT_SYS_ConfigInit();
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
