# Power_Mode_Demo

---

## Functional Description

This example demonstrates the RTC time management and sleep duration calculation functionality under the chip's low-power modes.

First Boot Procedure:When the system is powered on for the first time, the program performs a complete initialization configuration of the RTC module, sets the initial date and time, and then starts the RTC counter to begin timing.

Wake-up Procedure:After the MCU is awakened from Power Down mode by a low level on the PTD2 pin, the program reads the timestamp stored in non-volatile memory before entering sleep, compares it with the current RTC time, and calculates the sleep duration.
---

## Hardware Requirements

+ **Development Board**: YTM32B1ME0-EVB-Q144
+ **Debugger**: J-LINK v9.2 or higher

---

## Software Requirements

+ **SDK**: YTM32B1ME0_1_4_0 or higher
+ **GCC**: GNU GCC v10.3 or higher
+ **Keil/MDK**: ARM Keil/MDK v5.36 or higher
+ **IAR**: IAR v8.40 or higher
+ **VS Code**: Microsoft Visual Studio Code IDE v1.76 or higher (with GNU GCC toolchain, CMake v3.25, ninja, and Cortex-Debug extension installed)
+ **J-LINK**: SEGGER JLINK v6.96 or higher (YTM32B1ME0 patch/support package required)
+ **Ozone**: SEGGER Ozone v3.28 or higher

---