;  ---------------------------------------------------------------------------------------
;   @file:    YTM32B1LE1_startup_iar.S
;   @purpose: IAR Startup File
;             YTM32B1LE1
;   @version: 1.0
;   @date:    2024-08-05
;  ---------------------------------------------------------------------------------------
    MODULE  ?cstartup

    ;; Forward declaration of sections.
    SECTION CSTACK:DATA:NOROOT(3)

    SECTION .intvec:CODE:ROOT(2)

    EXTERN  main
    EXTERN  SystemInit
    EXTERN  init_data_bss
    PUBLIC  __vector_table
    PUBLIC  __Vectors
    PUBLIC  __Vectors_End
    PUBLIC  __Vectors_Size

    DATA

__vector_table
    DCD   sfe(CSTACK)
    DCD   Reset_Handler                      ; Reset Handler
    DCD   NMI_Handler                        ; Non Maskable Interrupt
    DCD   HardFault_Handler                  ; Cortex-M0 Hard Fault Interrupt
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   SVC_Handler                        ; Cortex-M0 SV Call Interrupt
    DCD   0
    DCD   0
    DCD   PendSV_Handler                     ; Cortex-M0 Pend SV Interrupt
    DCD   SysTick_Handler                    ; Cortex-M0 System Tick Interrupt

    DCD   DMA0_IRQHandler                                   ;  DMA0 Handler
    DCD   DMA1_IRQHandler                                   ;  DMA1 Handler
    DCD   DMA2_IRQHandler                                   ;  DMA2 Handler
    DCD   DMA3_IRQHandler                                   ;  DMA3 Handler
    DCD   DMA_Error_IRQHandler                              ;  DMA_Error Handler
    DCD   EMU0_IRQHandler                                   ;  EMU0 Handler
    DCD   MPWM0_Ovf_IRQHandler                              ;  MPWM0_Ovf Handler
    DCD   MPWM0_Ch0_Ch7_IRQHandler                          ;  MPWM0_Ch0_Ch7 Handler
    DCD   lpTMR0_IRQHandler                                 ;  lpTMR0 Handler
    DCD   GPIOA_IRQHandler                                  ;  GPIOA Handler
    DCD   CAN0_ORed_Err_Wakeup_IRQHandler                   ;  CAN0_ORed_Err_Wakeup Handler
    DCD   CAN0_ORed_0_15_MB_IRQHandler                      ;  CAN0_ORed_0_15_MB Handler
    DCD   eTMR0_CH_0_7_IRQHandler                           ;  eTMR0_CH_0_7 Handler
    DCD   eTMR0_Fault_IRQHandler                            ;  eTMR0_Fault Handler
    DCD   eTMR0_Ovf_IRQHandler                              ;  eTMR0_Ovf Handler
    DCD   GPIOB_IRQHandler                                  ;  GPIOB Handler
    DCD   GPIOC_IRQHandler                                  ;  GPIOC Handler
    DCD   CAN0_ORed_16_31_MB_IRQHandler                     ;  CAN0_ORed_16_31_MB Handler
    DCD   EFM_IRQHandler                                    ;  EFM Handler
    DCD   GPIOD_IRQHandler                                  ;  GPIOD Handler
    DCD   pTMR0_IRQHandler                                  ;  pTMR0 Handler
    DCD   PCU_CMU_IRQHandler                                ;  PCU_CMU Handler
    DCD   WDG0_IRQHandler                                   ;  WDG0 Handler
    DCD   GPIOE_IRQHandler                                  ;  GPIOE Handler
    DCD   I2C0_IRQHandler                                   ;  I2C0 Handler
    DCD   Reserved9_IRQHandler                              ;  Reserved9 Handler
    DCD   SPI0_IRQHandler                                   ;  SPI0 Handler
    DCD   SPI1_IRQHandler                                   ;  SPI1 Handler
    DCD   ADC0_IRQHandler                                   ;  ADC0 Handler
    DCD   ACMP0_IRQHandler                                  ;  ACMP0 Handler
    DCD   UART1_IRQHandler                                  ;  UART1 Handler
    DCD   UART0_IRQHandler                                  ;  UART0 Handler

__Vectors_End

__Vectors       EQU   __vector_table
__Vectors_Size  EQU   __Vectors_End - __Vectors


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
    THUMB

    PUBWEAK Reset_Handler
    SECTION .text:CODE:REORDER:NOROOT(2)
Reset_Handler
    CPSID   I               ; Mask interrupts
    ;; Init the rest of the registers
    LDR     R1,=0
    LDR     R2,=0
    LDR     R3,=0
    LDR     R4,=0
    LDR     R5,=0
    LDR     R6,=0
    LDR     R7,=0
    MOV     R8,R7
    MOV     R9,R7
    MOV     R10,R7
    MOV     R11,R7
    MOV     R12,R7

#ifndef START_NO_ECC_INIT
    IMPORT __RAM_START, __RAM_END
    ;; INIT ECC RAM

    LDR R1, =__RAM_START
    LDR R2, =__RAM_END

    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     SRAM_LOOP_END

    MOVS    R0, #0
    MOVS    R3, #4
            
SRAM_LOOP             
    STR     R0, [R1]
    ADD     R1, R1, R3
    SUBS    R2, #4
    BGE     SRAM_LOOP

SRAM_LOOP_END
#endif
    ;; Initialize the stack pointer
    LDR     R0, =sfe(CSTACK)
    MOV     R13,R0

#ifndef __NO_SYSTEM_INIT
    ;; Call the CMSIS system init routine
    LDR     R0, =SystemInit
    BLX     R0
#endif

    ;; Init .data and .bss sections
    LDR     R0, =init_data_bss
    BLX     R0
    CPSIE   I               ; Unmask interrupts

    BL      main
JumpToSelf
    B   JumpToSelf

    PUBWEAK NMI_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
    B .

    PUBWEAK HardFault_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
HardFault_Handler
    B .


    PUBWEAK SVC_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
SVC_Handler
    B .

    PUBWEAK PendSV_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
PendSV_Handler
    B .

    PUBWEAK SysTick_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
SysTick_Handler
    B .

    PUBWEAK   DMA0_IRQHandler
    PUBWEAK   DMA1_IRQHandler
    PUBWEAK   DMA2_IRQHandler
    PUBWEAK   DMA3_IRQHandler
    PUBWEAK   DMA_Error_IRQHandler
    PUBWEAK   EMU0_IRQHandler
    PUBWEAK   MPWM0_Ovf_IRQHandler
    PUBWEAK   MPWM0_Ch0_Ch7_IRQHandler
    PUBWEAK   lpTMR0_IRQHandler
    PUBWEAK   GPIOA_IRQHandler
    PUBWEAK   CAN0_ORed_Err_Wakeup_IRQHandler
    PUBWEAK   CAN0_ORed_0_15_MB_IRQHandler
    PUBWEAK   eTMR0_CH_0_7_IRQHandler
    PUBWEAK   eTMR0_Fault_IRQHandler
    PUBWEAK   eTMR0_Ovf_IRQHandler
    PUBWEAK   GPIOB_IRQHandler
    PUBWEAK   GPIOC_IRQHandler
    PUBWEAK   CAN0_ORed_16_31_MB_IRQHandler
    PUBWEAK   EFM_IRQHandler
    PUBWEAK   GPIOD_IRQHandler
    PUBWEAK   pTMR0_IRQHandler
    PUBWEAK   PCU_CMU_IRQHandler
    PUBWEAK   WDG0_IRQHandler
    PUBWEAK   GPIOE_IRQHandler
    PUBWEAK   I2C0_IRQHandler
    PUBWEAK   Reserved9_IRQHandler
    PUBWEAK   SPI0_IRQHandler
    PUBWEAK   SPI1_IRQHandler
    PUBWEAK   ADC0_IRQHandler
    PUBWEAK   ACMP0_IRQHandler
    PUBWEAK   UART1_IRQHandler
    PUBWEAK   UART0_IRQHandler
    PUBWEAK DefaultISR
    SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
HardFault_Handler
SVC_Handler
PendSV_Handler
SysTick_Handler
DMA0_IRQHandler
DMA1_IRQHandler
DMA2_IRQHandler
DMA3_IRQHandler
DMA_Error_IRQHandler
EMU0_IRQHandler
MPWM0_Ovf_IRQHandler
MPWM0_Ch0_Ch7_IRQHandler
lpTMR0_IRQHandler
GPIOA_IRQHandler
CAN0_ORed_Err_Wakeup_IRQHandler
CAN0_ORed_0_15_MB_IRQHandler
eTMR0_CH_0_7_IRQHandler
eTMR0_Fault_IRQHandler
eTMR0_Ovf_IRQHandler
GPIOB_IRQHandler
GPIOC_IRQHandler
CAN0_ORed_16_31_MB_IRQHandler
EFM_IRQHandler
GPIOD_IRQHandler
pTMR0_IRQHandler
PCU_CMU_IRQHandler
WDG0_IRQHandler
GPIOE_IRQHandler
I2C0_IRQHandler
Reserved9_IRQHandler
SPI0_IRQHandler
SPI1_IRQHandler
ADC0_IRQHandler
ACMP0_IRQHandler
UART1_IRQHandler
UART0_IRQHandler
DefaultISR
    B DefaultISR

    END