/* ---------------------------------------------------------------------------------------
 *  @file:    YTM32B1LE1_startup_gcc.S
 *  @purpose: GNU Compiler Collection Startup File
 *            YTM32B1LE1
 *  @version: 1.0
 *  @date:    2024-08-05
 * ---------------------------------------------------------------------------------------*/
/*****************************************************************************/
/* Version: GNU Compiler Collection                                          */
/*****************************************************************************/
    .syntax unified
    .arch armv6-m

    .section .isr_vector, "a"
    .align 2
    .globl __isr_vector
__isr_vector:
    .long   __StackTop                                        /* Top of Stack */
    .long   Reset_Handler                                     /* Reset Handler */
    .long   NMI_Handler                                                  /* NMI Handler*/
    .long   HardFault_Handler                                            /* HardFault Handler*/
    .long   0                                                 /* Reserved*/
    .long   0                                                 /* Reserved*/
    .long   0                                                 /* Reserved*/
    .long   0                                                 /* Reserved*/
    .long   0                                                 /* Reserved*/
    .long   0                                                 /* Reserved*/
    .long   0                                                 /* Reserved*/
    .long   SVC_Handler                                                  /* SVC Handler*/
    .long   0                                                 /* Reserved*/
    .long   0                                                 /* Reserved*/
    .long   PendSV_Handler                                               /* PendSV Handler*/
    .long   SysTick_Handler                                              /* SysTick Handler*/

/* External Interrupts*/
    .long   DMA0_IRQHandler                                             /* DMA0 Handler*/
    .long   DMA1_IRQHandler                                             /* DMA1 Handler*/
    .long   DMA2_IRQHandler                                             /* DMA2 Handler*/
    .long   DMA3_IRQHandler                                             /* DMA3 Handler*/
    .long   DMA_Error_IRQHandler                                        /* DMA_Error Handler*/
    .long   EMU0_IRQHandler                                             /* EMU0 Handler*/
    .long   MPWM0_Ovf_IRQHandler                                        /* MPWM0_Ovf Handler*/
    .long   MPWM0_Ch0_Ch7_IRQHandler                                    /* MPWM0_Ch0_Ch7 Handler*/
    .long   lpTMR0_IRQHandler                                           /* lpTMR0 Handler*/
    .long   GPIOA_IRQHandler                                            /* GPIOA Handler*/
    .long   CAN0_ORed_Err_Wakeup_IRQHandler                             /* CAN0_ORed_Err_Wakeup Handler*/
    .long   CAN0_ORed_0_15_MB_IRQHandler                                /* CAN0_ORed_0_15_MB Handler*/
    .long   eTMR0_CH_0_7_IRQHandler                                     /* eTMR0_CH_0_7 Handler*/
    .long   eTMR0_Fault_IRQHandler                                      /* eTMR0_Fault Handler*/
    .long   eTMR0_Ovf_IRQHandler                                        /* eTMR0_Ovf Handler*/
    .long   GPIOB_IRQHandler                                            /* GPIOB Handler*/
    .long   GPIOC_IRQHandler                                            /* GPIOC Handler*/
    .long   CAN0_ORed_16_31_MB_IRQHandler                               /* CAN0_ORed_16_31_MB Handler*/
    .long   EFM_IRQHandler                                              /* EFM Handler*/
    .long   GPIOD_IRQHandler                                            /* GPIOD Handler*/
    .long   pTMR0_IRQHandler                                            /* pTMR0 Handler*/
    .long   PCU_CMU_IRQHandler                                          /* PCU_CMU Handler*/
    .long   WDG0_IRQHandler                                             /* WDG0 Handler*/
    .long   GPIOE_IRQHandler                                            /* GPIOE Handler*/
    .long   I2C0_IRQHandler                                             /* I2C0 Handler*/
    .long   Reserved9_IRQHandler                                        /* Reserved9 Handler*/
    .long   SPI0_IRQHandler                                             /* SPI0 Handler*/
    .long   SPI1_IRQHandler                                             /* SPI1 Handler*/
    .long   ADC0_IRQHandler                                             /* ADC0 Handler*/
    .long   ACMP0_IRQHandler                                            /* ACMP0 Handler*/
    .long   UART1_IRQHandler                                            /* UART1 Handler*/
    .long   UART0_IRQHandler                                            /* UART0 Handler*/

    .size    __isr_vector, . - __isr_vector

    .text
    .thumb

/* Reset Handler */

    .thumb_func
    .align 2
    .globl   Reset_Handler
    .weak    Reset_Handler
    .type    Reset_Handler, %function
Reset_Handler:
    cpsid   i               /* Mask interrupts */

    /* Init the rest of the registers */
    ldr     r1,=0
    ldr     r2,=0
    ldr     r3,=0
    ldr     r4,=0
    ldr     r5,=0
    ldr     r6,=0
    ldr     r7,=0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7

#ifndef START_NO_ECC_INIT

    /* Init ECC RAM */
    ldr     r1, =__RAM_START
    ldr     r2, =__RAM_END

    subs    r2, r1
    subs    r2, #1
    ble     SRAM_LOOP_END

    movs    r0, #0
    movs    r3, #4
SRAM_LOOP:
    str     r0, [r1]
    add     r1, r1, r3
    subs    r2, #4
    bge     SRAM_LOOP
SRAM_LOOP_END:
#endif
    
    /* Initialize the stack pointer */
    ldr     r0,=__StackTop
    mov     r13,r0

#ifndef __NO_SYSTEM_INIT
    /* Call the system init routine */
    ldr     r0,=SystemInit
    blx     r0
#endif

    /* Init .data and .bss sections */
    ldr     r0,=init_data_bss
    blx     r0
    cpsie   i               /* Unmask interrupts */
    bl      main
JumpToSelf:
    b       JumpToSelf

    .pool
    .size Reset_Handler, . - Reset_Handler

    .align  1
    .thumb_func
    .weak DefaultISR
    .type DefaultISR, %function
DefaultISR:
Infinite_Loop:
    b Infinite_Loop
    .size DefaultISR, . - DefaultISR

/*    Macro to define default handlers. Default handler
 *    will be weak symbol and just dead loops. They can be
 *    overwritten by other handlers */
    .macro def_irq_handler  handler_name
    .weak \handler_name
    .set  \handler_name, DefaultISR
    .endm

    /* Exception Handlers */
    def_irq_handler    NMI_Handler
    def_irq_handler    HardFault_Handler
    def_irq_handler    Reserved0_Handler
    def_irq_handler    Reserved1_Handler
    def_irq_handler    Reserved2_Handler
    def_irq_handler    Reserved3_Handler
    def_irq_handler    Reserved4_Handler
    def_irq_handler    Reserved5_Handler
    def_irq_handler    Reserved6_Handler
    def_irq_handler    SVC_Handler
    def_irq_handler    Reserved7_Handler
    def_irq_handler    Reserved8_Handler
    def_irq_handler    PendSV_Handler
    def_irq_handler    SysTick_Handler

    /* Device Exception Handlers */

    def_irq_handler    DMA0_IRQHandler
    def_irq_handler    DMA1_IRQHandler
    def_irq_handler    DMA2_IRQHandler
    def_irq_handler    DMA3_IRQHandler
    def_irq_handler    DMA_Error_IRQHandler
    def_irq_handler    EMU0_IRQHandler
    def_irq_handler    MPWM0_Ovf_IRQHandler
    def_irq_handler    MPWM0_Ch0_Ch7_IRQHandler
    def_irq_handler    lpTMR0_IRQHandler
    def_irq_handler    GPIOA_IRQHandler
    def_irq_handler    CAN0_ORed_Err_Wakeup_IRQHandler
    def_irq_handler    CAN0_ORed_0_15_MB_IRQHandler
    def_irq_handler    eTMR0_CH_0_7_IRQHandler
    def_irq_handler    eTMR0_Fault_IRQHandler
    def_irq_handler    eTMR0_Ovf_IRQHandler
    def_irq_handler    GPIOB_IRQHandler
    def_irq_handler    GPIOC_IRQHandler
    def_irq_handler    CAN0_ORed_16_31_MB_IRQHandler
    def_irq_handler    EFM_IRQHandler
    def_irq_handler    GPIOD_IRQHandler
    def_irq_handler    pTMR0_IRQHandler
    def_irq_handler    PCU_CMU_IRQHandler
    def_irq_handler    WDG0_IRQHandler
    def_irq_handler    GPIOE_IRQHandler
    def_irq_handler    I2C0_IRQHandler
    def_irq_handler    Reserved9_IRQHandler
    def_irq_handler    SPI0_IRQHandler
    def_irq_handler    SPI1_IRQHandler
    def_irq_handler    ADC0_IRQHandler
    def_irq_handler    ACMP0_IRQHandler
    def_irq_handler    UART1_IRQHandler
    def_irq_handler    UART0_IRQHandler

    .end