;  ---------------------------------------------------------------------------------------
;   @file:    YTM32B1LE0_startup_iar.s
;   @purpose: IAR Startup File
;             YTM32B1LE0
;   @version: 1.7
;   @date:    2024-02-22
;  ---------------------------------------------------------------------------------------
    MODULE  ?cstartup

    ;; Forward declaration of sections.
    SECTION CSTACK:DATA:NOROOT(3)

    SECTION .intvec:CODE:ROOT(2)

    EXTERN  main
    EXTERN  SystemInit
    EXTERN  init_data_bss
    PUBLIC  __vector_table
    PUBLIC  __Vectors
    PUBLIC  __Vectors_End
    PUBLIC  __Vectors_Size

    DATA

__vector_table
    DCD   sfe(CSTACK)
    DCD   Reset_Handler                      ; Reset Handler
    DCD   NMI_Handler                        ; Non Maskable Interrupt
    DCD   HardFault_Handler                  ; Cortex-M0 Hard Fault Interrupt
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   SVC_Handler                        ; Cortex-M0 SV Call Interrupt
    DCD   0
    DCD   0
    DCD   PendSV_Handler                     ; Cortex-M0 Pend SV Interrupt
    DCD   SysTick_Handler                    ; Cortex-M0 System Tick Interrupt

    DCD   DMA0_IRQHandler                                   ;  DMA0 Handler
    DCD   DMA1_IRQHandler                                   ;  DMA1 Handler
    DCD   DMA2_IRQHandler                                   ;  DMA2 Handler
    DCD   DMA3_IRQHandler                                   ;  DMA3 Handler
    DCD   DMA_Error_IRQHandler                              ;  DMA_Error Handler
    DCD   EMU_IRQHandler                                    ;  EMU Handler
    DCD   RTC_IRQHandler                                    ;  RTC Handler
    DCD   SPI2_IRQHandler                                   ;  SPI2 Handler
    DCD   lpTMR0_IRQHandler                                 ;  lpTMR0 Handler
    DCD   GPIO_IRQHandler                                   ;  GPIO Handler
    DCD   CAN0_ORed_Err_Wakeup_IRQHandler                   ;  CAN0_ORed_Err_Wakeup Handler
    DCD   CAN0_ORed_0_15_MB_IRQHandler                      ;  CAN0_ORed_0_15_MB Handler
    DCD   eTMR0_CH_0_7_IRQHandler                           ;  eTMR0_CH_0_7 Handler
    DCD   eTMR0_Fault_IRQHandler                            ;  eTMR0_Fault Handler
    DCD   eTMR0_Ovf_IRQHandler                              ;  eTMR0_Ovf Handler
    DCD   eTMR1_IRQHandler                                  ;  eTMR1 Handler
    DCD   eTMR2_IRQHandler                                  ;  eTMR2 Handler
    DCD   CAN0_ORed_16_31_MB_IRQHandler                     ;  CAN0_ORed_16_31_MB Handler
    DCD   EFM_IRQHandler                                    ;  EFM Handler
    DCD   Reserved9_IRQHandler                              ;  Reserved9 Handler
    DCD   pTMR0_IRQHandler                                  ;  pTMR0 Handler
    DCD   PCU_CMU_IRQHandler                                ;  PCU_CMU Handler
    DCD   WDG_IRQHandler                                    ;  WDG Handler
    DCD   UART2_IRQHandler                                  ;  UART2 Handler
    DCD   I2C0_IRQHandler                                   ;  I2C0 Handler
    DCD   I2C1_IRQHandler                                   ;  I2C1 Handler
    DCD   SPI0_IRQHandler                                   ;  SPI0 Handler
    DCD   SPI1_IRQHandler                                   ;  SPI1 Handler
    DCD   ADC0_IRQHandler                                   ;  ADC0 Handler
    DCD   ACMP0_IRQHandler                                  ;  ACMP0 Handler
    DCD   UART1_IRQHandler                                  ;  UART1 Handler
    DCD   UART0_IRQHandler                                  ;  UART0 Handler

__Vectors_End

__Vectors       EQU   __vector_table
__Vectors_Size  EQU   __Vectors_End - __Vectors

#define RSSR_REG  (0x4007F000)
#define RSSR_FLAG (0x00040000)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
    THUMB

    PUBWEAK Reset_Handler
    SECTION .text:CODE:REORDER:NOROOT(2)
Reset_Handler
    CPSID   I               ; Mask interrupts
    ;; Init the rest of the registers
    LDR     R1,=0
    LDR     R2,=0
    LDR     R3,=0
    LDR     R4,=0
    LDR     R5,=0
    LDR     R6,=0
    LDR     R7,=0
    MOV     R8,R7
    MOV     R9,R7
    MOV     R10,R7
    MOV     R11,R7
    MOV     R12,R7

#ifndef START_NO_ECC_INIT
    /* Init VECTOR SRAM ECC */
    IMPORT  __VECTOR_RAM, __VECTOR_END
    LDR     R1, =__VECTOR_RAM
    LDR     R2, =__VECTOR_END
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     VEC_SRAM_LOOP_END
    MOVS    R0, #0
    MOVS    R3, #4
VEC_SRAM_LOOP
    STR     R0, [R1]
    ADD     R1, R1, R3
    SUBS    R2, #4
    BGE     VEC_SRAM_LOOP
VEC_SRAM_LOOP_END

    /* Check if the reset is caused by watchdog */
    LDR     R0, =RSSR_REG
    LDR     R0, [R0]
    LDR     R1, =RSSR_FLAG
    ANDS    R0, R1
    BNE     SAFLIB_SRAM_LOOP_END
    /* Init SafLib SRAM ECC */
    IMPORT  __SAFLIB_RAM_START, __SAFLIB_RAM_END
    LDR     R1, =__SAFLIB_RAM_START
    LDR     R2, =__SAFLIB_RAM_END
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     SAFLIB_SRAM_LOOP_END
    MOVS    R0, #0
    MOVS    R3, #4
SAFLIB_SRAM_LOOP
    STR     R0, [R1]
    ADD     R1, R1, R3
    SUBS    R2, #4
    BGE     SAFLIB_SRAM_LOOP
SAFLIB_SRAM_LOOP_END

    /* Init SRAM ECC */
    IMPORT  __RAM_START, __RAM_END
    LDR     R1, =__RAM_START
    LDR     R2, =__RAM_END
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     SRAM_LOOP_END
    MOVS    R0, #0
    MOVS    R3, #4
SRAM_LOOP             
    STR     R0, [R1]
    ADD     R1, R1, R3
    SUBS    R2, #4
    BGE     SRAM_LOOP
SRAM_LOOP_END
#endif

    ;; Initialize the stack pointer
    LDR     R0, =sfe(CSTACK)
    MOV     R13,R0

#ifndef __NO_SYSTEM_INIT
    ;; Call the CMSIS system init routine
    LDR     R0, =SystemInit
    BLX     R0
#endif

    ;; Init .data and .bss sections
    LDR     R0, =init_data_bss
    BLX     R0
    CPSIE   I               ; Unmask interrupts

    BL      main
JumpToSelf
    B   JumpToSelf

    PUBWEAK NMI_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
    B .

    PUBWEAK HardFault_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
HardFault_Handler
    B .


    PUBWEAK SVC_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
SVC_Handler
    B .

    PUBWEAK PendSV_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
PendSV_Handler
    B .

    PUBWEAK SysTick_Handler
    SECTION .text:CODE:REORDER:NOROOT(1)
SysTick_Handler
    B .

    PUBWEAK   DMA0_IRQHandler
    PUBWEAK   DMA1_IRQHandler
    PUBWEAK   DMA2_IRQHandler
    PUBWEAK   DMA3_IRQHandler
    PUBWEAK   DMA_Error_IRQHandler
    PUBWEAK   EMU_IRQHandler
    PUBWEAK   RTC_IRQHandler
    PUBWEAK   SPI2_IRQHandler
    PUBWEAK   lpTMR0_IRQHandler
    PUBWEAK   GPIO_IRQHandler
    PUBWEAK   CAN0_ORed_Err_Wakeup_IRQHandler
    PUBWEAK   CAN0_ORed_0_15_MB_IRQHandler
    PUBWEAK   eTMR0_CH_0_7_IRQHandler
    PUBWEAK   eTMR0_Fault_IRQHandler
    PUBWEAK   eTMR0_Ovf_IRQHandler
    PUBWEAK   eTMR1_IRQHandler
    PUBWEAK   eTMR2_IRQHandler
    PUBWEAK   CAN0_ORed_16_31_MB_IRQHandler
    PUBWEAK   EFM_IRQHandler
    PUBWEAK   Reserved9_IRQHandler
    PUBWEAK   pTMR0_IRQHandler
    PUBWEAK   PCU_CMU_IRQHandler
    PUBWEAK   WDG_IRQHandler
    PUBWEAK   UART2_IRQHandler
    PUBWEAK   I2C0_IRQHandler
    PUBWEAK   I2C1_IRQHandler
    PUBWEAK   SPI0_IRQHandler
    PUBWEAK   SPI1_IRQHandler
    PUBWEAK   ADC0_IRQHandler
    PUBWEAK   ACMP0_IRQHandler
    PUBWEAK   UART1_IRQHandler
    PUBWEAK   UART0_IRQHandler
    PUBWEAK DefaultISR
    SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
HardFault_Handler
SVC_Handler
PendSV_Handler
SysTick_Handler
DMA0_IRQHandler
DMA1_IRQHandler
DMA2_IRQHandler
DMA3_IRQHandler
DMA_Error_IRQHandler
EMU_IRQHandler
RTC_IRQHandler
SPI2_IRQHandler
lpTMR0_IRQHandler
GPIO_IRQHandler
CAN0_ORed_Err_Wakeup_IRQHandler
CAN0_ORed_0_15_MB_IRQHandler
eTMR0_CH_0_7_IRQHandler
eTMR0_Fault_IRQHandler
eTMR0_Ovf_IRQHandler
eTMR1_IRQHandler
eTMR2_IRQHandler
CAN0_ORed_16_31_MB_IRQHandler
EFM_IRQHandler
Reserved9_IRQHandler
pTMR0_IRQHandler
PCU_CMU_IRQHandler
WDG_IRQHandler
UART2_IRQHandler
I2C0_IRQHandler
I2C1_IRQHandler
SPI0_IRQHandler
SPI1_IRQHandler
ADC0_IRQHandler
ACMP0_IRQHandler
UART1_IRQHandler
UART0_IRQHandler
DefaultISR
    B DefaultISR

    END
