;/* ---------------------------------------------------------------------------------------
; *  @file:    YTM32B1LE0_startup_armc.S
; *  @purpose: ARM compiler Startup File
; *            YTM32B1LE0
; *  @version: 1.7
; *  @date:    2024-02-22
; * ---------------------------------------------------------------------------------------*/

    PRESERVE8
    THUMB

    AREA    |.text|, CODE, READONLY

    EXPORT  __VECTOR_TABLE
    EXPORT  __Vectors_End
    EXPORT  __Vectors_Size

    EXPORT __BSS_START
    EXPORT __BSS_END

    EXPORT __DATA_ROM
    EXPORT __VECTOR_ROM_START
    EXPORT __VECTOR_ROM_END
    EXPORT __DATA_RAM_START
    EXPORT __DATA_RAM_END
                    
    EXPORT __RAM_START
    EXPORT __RAM_END
                    
    EXPORT __RAM_VECTOR_TABLE_SIZE
    EXPORT __VECTOR_RAM
    EXPORT __VECTOR_ROM
    EXPORT __VECTOR_END

    EXPORT __SAFLIB_RAM_START
    EXPORT __SAFLIB_RAM_END
                    
    IMPORT  |Image$$ARM_LIB_STACK$$ZI$$Limit|
    IMPORT  |Image$$ARM_LIB_STACK$$Limit|
    IMPORT  |Image$$ARM_LIB_STACK$$Length|
    IMPORT  |Image$$ARM_LIB_HEAP$$Length|
                
    IMPORT  |Image$$RW_m_data$$ZI$$Base|
    IMPORT  |Image$$RW_m_data$$ZI$$Limit|
    IMPORT  |Image$$RW_m_data$$RW$$Base|
    IMPORT  |Image$$RW_m_data$$RW$$Length|
    IMPORT  |Image$$RW_m_data$$RW$$Limit|

    IMPORT  |Image$$RW_m_data$$Base|
    IMPORT  |Image$$RW_m_data$$Limit|
    IMPORT  |Image$$RW_m_data$$Length|

    IMPORT |Image$$ER_m_text$$Limit|

    IMPORT |Image$$VECTOR_RAM$$Length|
    IMPORT |Image$$VECTOR_RAM$$Base|
                    
    IMPORT |Image$$VECTOR_ROM$$Length|
    IMPORT |Image$$VECTOR_ROM$$Base|
    IMPORT |Image$$VECTOR_ROM$$Limit|

    IMPORT |Image$$SAFLIB_RAM$$Base|
    IMPORT |Image$$SAFLIB_RAM$$Limit|

__RAM_VECTOR_TABLE_SIZE DCD |Image$$VECTOR_ROM$$Length|
__VECTOR_RAM            DCD |Image$$VECTOR_RAM$$Base|
__VECTOR_END            DCD |Image$$SAFLIB_RAM$$Base|
__VECTOR_ROM            DCD |Image$$VECTOR_ROM$$Base|
__VECTOR_ROM_START      DCD |Image$$VECTOR_ROM$$Base|
__VECTOR_ROM_END        DCD |Image$$VECTOR_ROM$$Limit|

__BSS_START             DCD |Image$$RW_m_data$$ZI$$Base|
__BSS_END               DCD |Image$$RW_m_data$$ZI$$Limit|

__DATA_RAM_START        DCD |Image$$RW_m_data$$RW$$Base|
__DATA_RAM_END          DCD |Image$$RW_m_data$$RW$$Limit|
__DATA_ROM              DCD |Image$$ER_m_text$$Limit|

__RAM_START             DCD |Image$$RW_m_data$$Base|
__RAM_END               DCD |Image$$ARM_LIB_STACK$$ZI$$Limit|

__SAFLIB_RAM_START      DCD |Image$$SAFLIB_RAM$$Base|
__SAFLIB_RAM_END        DCD |Image$$RW_m_data$$RW$$Base|

; Vector Table Mapped to Address 0 at Reset
    AREA    RESET, DATA, READONLY
    ALIGN   4
__VECTOR_TABLE
    DCD   |Image$$ARM_LIB_STACK$$ZI$$Limit|     ; top of stack
    DCD   Reset_Handler                         ; Reset Handler
    DCD   NMI_Handler                           ; Non Maskable Interrupt
    DCD   HardFault_Handler                     ; Cortex-M0 Hard Fault Interrupt
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   SVC_Handler                           ; Cortex-M0 SV Call Interrupt
    DCD   0
    DCD   0
    DCD   PendSV_Handler                        ; Cortex-M0 Pend SV Interrupt
    DCD   SysTick_Handler                       ; Cortex-M0 System Tick Interrupt

    DCD   DMA0_IRQHandler                       ;  DMA0 Handler
    DCD   DMA1_IRQHandler                       ;  DMA1 Handler
    DCD   DMA2_IRQHandler                       ;  DMA2 Handler
    DCD   DMA3_IRQHandler                       ;  DMA3 Handler
    DCD   DMA_Error_IRQHandler                  ;  DMA_Error Handler
    DCD   EMU_IRQHandler                        ;  EMU Handler
    DCD   RTC_IRQHandler                        ;  RTC Handler
    DCD   SPI2_IRQHandler                       ;  SPI2 Handler
    DCD   lpTMR0_IRQHandler                     ;  lpTMR0 Handler
    DCD   GPIO_IRQHandler                       ;  GPIO Handler
    DCD   CAN0_ORed_Err_Wakeup_IRQHandler       ;  CAN0_ORed_Err_Wakeup Handler
    DCD   CAN0_ORed_0_15_MB_IRQHandler          ;  CAN0_ORed_0_15_MB Handler
    DCD   eTMR0_CH_0_7_IRQHandler               ;  eTMR0_CH_0_7 Handler
    DCD   eTMR0_Fault_IRQHandler                ;  eTMR0_FAULT Handler
    DCD   eTMR0_Ovf_IRQHandler                  ;  eTMR0_OVERFLOW Handler
    DCD   eTMR1_IRQHandler                      ;  eTMR1 Handler
    DCD   eTMR2_IRQHandler                      ;  eTMR2 Handler
    DCD   CAN0_ORed_16_31_MB_IRQHandler         ;  CAN0_ORed_16_31_MB Handler
    DCD   EFM_IRQHandler                        ;  EFM Handler
    DCD   Reserved9_IRQHandler                  ;  Reserved9 Handler
    DCD   pTMR0_IRQHandler                      ;  pTMR0 Handler
    DCD   PCU_CMU_IRQHandler                    ;  PCU_CMU Handler
    DCD   WDG_IRQHandler                        ;  WDG Handler
    DCD   UART2_IRQHandler                      ;  UART2 Handler
    DCD   I2C0_IRQHandler                       ;  I2C0 Handler
    DCD   I2C1_IRQHandler                       ;  I2C1 Handler
    DCD   SPI0_IRQHandler                       ;  SPI0 Handler
    DCD   SPI1_IRQHandler                       ;  SPI1 Handler
    DCD   ADC0_IRQHandler                       ;  ADC0 Handler
    DCD   ACMP0_IRQHandler                      ;  ACMP0 Handler
    DCD   UART1_IRQHandler                      ;  UART1 Handler
    DCD   UART0_IRQHandler                      ;  UART0 Handler

__Vectors_End

__Vectors_Size  EQU   __Vectors_End - __VECTOR_TABLE

#define RSSR_REG  (0x4007F000)
#define RSSR_FLAG (0x00040000)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



    AREA    |.text|, CODE, READONLY
                
Reset_Handler   PROC
    ALIGN   4
    EXPORT  Reset_Handler               [WEAK]
    IMPORT  __main
    IMPORT  SystemInit
    IMPORT  init_data_bss

    CPSID   I               ; Mask interrupts
    ;; Init the rest of the registers
    LDR     R1,=0
    LDR     R2,=0
    LDR     R3,=0
    LDR     R4,=0
    LDR     R5,=0
    LDR     R6,=0
    LDR     R7,=0
    MOV     R8,R7
    MOV     R9,R7
    MOV     R10,R7
    MOV     R11,R7
    MOV     R12,R7

#ifndef START_NO_ECC_INIT
    /* Init VECTOR SRAM ECC */
    LDR     R1, =__VECTOR_RAM
    LDR     R1, [R1]
    LDR     R2, =__VECTOR_END
    LDR     R2, [R2]
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     VEC_SRAM_LOOP_END
    MOVS    R0, #0
    MOVS    R3, #4
VEC_SRAM_LOOP
    STR     R0, [R1]
    ADD     R1, R1, R3
    SUBS    R2, #4
    BGE     VEC_SRAM_LOOP
VEC_SRAM_LOOP_END

    /* Check if the reset is caused by watchdog */
    LDR     R0, =RSSR_REG
    LDR     R0, [R0]
    LDR     R1, =RSSR_FLAG
    ANDS    R0, R1
    BNE     SAFLIB_SRAM_LOOP_END
    /* Init SafLib SRAM ECC */
    LDR     R1, =__SAFLIB_RAM_START
    LDR     R1, [R1]
    LDR     R2, =__SAFLIB_RAM_END
    LDR     R2, [R2]
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     SAFLIB_SRAM_LOOP_END
    MOVS    R0, #0
    MOVS    R3, #4
SAFLIB_SRAM_LOOP
    STR     R0, [R1]
    ADD     R1, R1, R3
    SUBS    R2, #4
    BGE     SAFLIB_SRAM_LOOP
SAFLIB_SRAM_LOOP_END

    /* Init SRAM ECC */
    LDR     R1, =__RAM_START
    LDR     R1, [R1]
    LDR     R2, =__RAM_END
    LDR     R2, [R2]
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     SRAM_LOOP_END
    MOVS    R0, #0
    MOVS    R3, #4
SRAM_LOOP
    STR     R0, [R1]
    ADD     R1, R1, R3
    SUBS    R2, #4
    BGE     SRAM_LOOP
SRAM_LOOP_END
#endif
                
    LDR     R0, =__VECTOR_TABLE
    LDR     R1, [R0]
    MSR     MSP, R1
                
    LDR     R0, =SystemInit
    BLX     R0
    LDR     R0, =init_data_bss
    BLX     R0
                
    CPSIE   I               ; Unmask interrupts
                
    LDR     R0, =__main
    BX      R0
    ENDP    


NMI_Handler     PROC
    EXPORT  NMI_Handler             [WEAK]
    B       .
    ENDP

HardFault_Handler\
    PROC
    EXPORT  HardFault_Handler       [WEAK]
    B       .
    ENDP

SVC_Handler     PROC
    EXPORT  SVC_Handler             [WEAK]
    B       .
    ENDP

PendSV_Handler  PROC
    EXPORT  PendSV_Handler          [WEAK]
    B       .
    ENDP

SysTick_Handler PROC
    EXPORT  SysTick_Handler         [WEAK]
    B       .
    ENDP

DefaultISR      PROC
    EXPORT   DefaultISR             [WEAK]
    B       .
    ENDP

Default_Handler PROC
    EXPORT   DMA0_IRQHandler                    [WEAK]
    EXPORT   DMA1_IRQHandler                    [WEAK]
    EXPORT   DMA2_IRQHandler                    [WEAK]
    EXPORT   DMA3_IRQHandler                    [WEAK]
    EXPORT   DMA_Error_IRQHandler               [WEAK]
    EXPORT   EMU_IRQHandler                     [WEAK]
    EXPORT   RTC_IRQHandler                     [WEAK]
    EXPORT   SPI2_IRQHandler                    [WEAK]
    EXPORT   lpTMR0_IRQHandler                  [WEAK]
    EXPORT   GPIO_IRQHandler                    [WEAK]
    EXPORT   CAN0_ORed_Err_Wakeup_IRQHandler    [WEAK]
    EXPORT   CAN0_ORed_0_15_MB_IRQHandler       [WEAK]
    EXPORT   eTMR0_CH_0_7_IRQHandler            [WEAK]
    EXPORT   eTMR0_Fault_IRQHandler             [WEAK]
    EXPORT   eTMR0_Ovf_IRQHandler               [WEAK]
    EXPORT   eTMR1_IRQHandler                   [WEAK]
    EXPORT   eTMR2_IRQHandler                   [WEAK]
    EXPORT   CAN0_ORed_16_31_MB_IRQHandler      [WEAK]
    EXPORT   EFM_IRQHandler                     [WEAK]
    EXPORT   Reserved9_IRQHandler               [WEAK]
    EXPORT   pTMR0_IRQHandler                   [WEAK]
    EXPORT   PCU_CMU_IRQHandler                 [WEAK]
    EXPORT   WDG_IRQHandler                     [WEAK]
    EXPORT   UART2_IRQHandler                   [WEAK]
    EXPORT   I2C0_IRQHandler                    [WEAK]
    EXPORT   I2C1_IRQHandler                    [WEAK]
    EXPORT   SPI0_IRQHandler                    [WEAK]
    EXPORT   SPI1_IRQHandler                    [WEAK]
    EXPORT   ADC0_IRQHandler                    [WEAK]
    EXPORT   ACMP0_IRQHandler                   [WEAK]
    EXPORT   UART1_IRQHandler                   [WEAK]
    EXPORT   UART0_IRQHandler                   [WEAK]

DMA0_IRQHandler
DMA1_IRQHandler
DMA2_IRQHandler
DMA3_IRQHandler
DMA_Error_IRQHandler
EMU_IRQHandler
RTC_IRQHandler
SPI2_IRQHandler
lpTMR0_IRQHandler
GPIO_IRQHandler
CAN0_ORed_Err_Wakeup_IRQHandler
CAN0_ORed_0_15_MB_IRQHandler
eTMR0_CH_0_7_IRQHandler
eTMR0_Fault_IRQHandler
eTMR0_Ovf_IRQHandler
eTMR1_IRQHandler
eTMR2_IRQHandler
CAN0_ORed_16_31_MB_IRQHandler
EFM_IRQHandler
Reserved9_IRQHandler
pTMR0_IRQHandler
PCU_CMU_IRQHandler
WDG_IRQHandler
UART2_IRQHandler
I2C0_IRQHandler
I2C1_IRQHandler
SPI0_IRQHandler
SPI1_IRQHandler
ADC0_IRQHandler
ACMP0_IRQHandler
UART1_IRQHandler
UART0_IRQHandler
    B       .

    ENDP
    ALIGN 4

    END