;/* ---------------------------------------------------------------------------------------
; *  @file:    YTM32B1HA0_startup_armc_retention.S
; *  @purpose: ARM compiler Startup File
; *            YTM32B1HA0
; *  @version: 1.1
; *  @date:    2024-02-27
; * ---------------------------------------------------------------------------------------*/

    PRESERVE8
    THUMB

    AREA    |.text|, CODE, READONLY

    EXPORT  __VECTOR_TABLE
    EXPORT  __Vectors_End
    EXPORT  __Vectors_Size

    EXPORT __BSS_START
    EXPORT __BSS_END

    EXPORT __DATA_ROM
    EXPORT __VECTOR_ROM_START
    EXPORT __VECTOR_ROM_END
    EXPORT __DATA_RAM_START
    EXPORT __DATA_RAM_END
    
    EXPORT __RAM_START
    EXPORT __RAM_END

    EXPORT __RAM_VECTOR_TABLE_SIZE
    EXPORT __VECTOR_RAM
    EXPORT __VECTOR_ROM
        
    IMPORT  |Image$$ARM_LIB_STACK$$ZI$$Limit|
    IMPORT  |Image$$ARM_LIB_STACK$$Limit|
    IMPORT  |Image$$ARM_LIB_STACK$$Length|
    IMPORT  |Image$$ARM_LIB_HEAP$$Length|
    
    IMPORT  |Image$$RW_m_data$$RW$$Base|
    IMPORT  |Image$$RW_m_data$$RW$$Length|
    IMPORT  |Image$$RW_m_data$$RW$$Limit|
        
    IMPORT  |Image$$RW_m_data$$Base|
    IMPORT  |Image$$RW_m_data$$Limit|
    IMPORT  |Image$$RW_m_data$$Length|

    IMPORT  |Image$$RW_m_data$$Base|
    IMPORT  |Image$$RW_m_data$$Length|
    IMPORT  |Image$$RW_m_data$$Limit|
    IMPORT  |Image$$RW_m_data$$ZI$$Base|
    IMPORT  |Image$$RW_m_data$$ZI$$Length|
    IMPORT  |Image$$RW_m_data$$ZI$$Limit|

    IMPORT  |Image$$RW_m_retention$$Base|

    IMPORT |Image$$ER_m_text$$Limit|

    IMPORT |Image$$VECTOR_RAM$$Length|
    IMPORT |Image$$VECTOR_RAM$$Base|
        
    IMPORT |Image$$VECTOR_ROM$$Length|
    IMPORT |Image$$VECTOR_ROM$$Base|
    IMPORT |Image$$VECTOR_ROM$$Limit|
                
__RAM_VECTOR_TABLE_SIZE     DCD |Image$$VECTOR_ROM$$Length|
__VECTOR_RAM                DCD |Image$$VECTOR_RAM$$Base|
__VECTOR_ROM                DCD |Image$$VECTOR_ROM$$Base|
__VECTOR_ROM_START          DCD |Image$$VECTOR_ROM$$Base|
__VECTOR_ROM_END            DCD |Image$$VECTOR_ROM$$Limit|

__BSS_START                 DCD  |Image$$RW_m_data$$ZI$$Base|
__BSS_END                   DCD  |Image$$RW_m_data$$ZI$$Limit|

__DATA_RAM_START            DCD  |Image$$RW_m_data$$RW$$Base|
__DATA_RAM_END              DCD  |Image$$RW_m_data$$RW$$Limit|

__DATA_ROM                  DCD  |Image$$ER_m_text$$Limit|

__RETENTION_RAM_START       DCD  |Image$$RW_m_retention$$Base|
__RETENTION_RAM_END         DCD  |Image$$VECTOR_RAM$$Base| - 1
    
__RAM_START                 DCD  |Image$$VECTOR_RAM$$Base|
__RAM_END                   DCD  |Image$$ARM_LIB_STACK$$ZI$$Limit| - 1

; Vector Table Mapped to Address 0 at Reset
    AREA    RESET, DATA, READONLY
    ALIGN   4
__VECTOR_TABLE
    DCD   |Image$$ARM_LIB_STACK$$ZI$$Limit|     ; top of stack
    DCD   Reset_Handler                         ; Reset Handler
    DCD   NMI_Handler                           ; Non Maskable Interrupt
    DCD   HardFault_Handler                     ;  Hard Fault Interrupt
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   0
    DCD   SVC_Handler                           ;  SV Call Interrupt
    DCD   0
    DCD   0
    DCD   PendSV_Handler                        ;  Pend SV Interrupt
    DCD   SysTick_Handler                       ;  System Tick Interrupt

    DCD   DMA0_IRQHandler                       ;  DMA0 Handler
    DCD   DMA1_IRQHandler                       ;  DMA1 Handler
    DCD   DMA2_IRQHandler                       ;  DMA2 Handler
    DCD   DMA3_IRQHandler                       ;  DMA3 Handler
    DCD   DMA4_IRQHandler                       ;  DMA4 Handler
    DCD   DMA5_IRQHandler                       ;  DMA5 Handler
    DCD   DMA6_IRQHandler                       ;  DMA6 Handler
    DCD   DMA7_IRQHandler                       ;  DMA7 Handler
    DCD   DMA8_IRQHandler                       ;  DMA8 Handler
    DCD   DMA9_IRQHandler                       ;  DMA9 Handler
    DCD   DMA10_IRQHandler                      ;  DMA10 Handler
    DCD   DMA11_IRQHandler                      ;  DMA11 Handler
    DCD   DMA12_IRQHandler                      ;  DMA12 Handler
    DCD   DMA13_IRQHandler                      ;  DMA13 Handler
    DCD   DMA14_IRQHandler                      ;  DMA14 Handler
    DCD   DMA15_IRQHandler                      ;  DMA15 Handler
    DCD   DMA16_IRQHandler                      ;  DMA16 Handler
    DCD   DMA17_IRQHandler                      ;  DMA17 Handler
    DCD   DMA18_IRQHandler                      ;  DMA18 Handler
    DCD   DMA19_IRQHandler                      ;  DMA19 Handler
    DCD   DMA20_IRQHandler                      ;  DMA20 Handler
    DCD   DMA21_IRQHandler                      ;  DMA21 Handler
    DCD   DMA22_IRQHandler                      ;  DMA22 Handler
    DCD   DMA23_IRQHandler                      ;  DMA23 Handler
    DCD   DMA24_IRQHandler                      ;  DMA24 Handler
    DCD   DMA25_IRQHandler                      ;  DMA25 Handler
    DCD   DMA26_IRQHandler                      ;  DMA26 Handler
    DCD   DMA27_IRQHandler                      ;  DMA27 Handler
    DCD   DMA28_IRQHandler                      ;  DMA28 Handler
    DCD   DMA29_IRQHandler                      ;  DMA29 Handler
    DCD   DMA30_IRQHandler                      ;  DMA30 Handler
    DCD   DMA31_IRQHandler                      ;  DMA31 Handler
    DCD   DMA_Error_IRQHandler                  ;  DMA_Error Handler
    DCD   FPU_IRQHandler                        ;  FPU Handler
    DCD   EFM_IRQHandler                        ;  EFM Handler
    DCD   EFM_Error_IRQHandler                  ;  EFM_Error Handler
    DCD   PCU_IRQHandler                        ;  PCU Handler
    DCD   EFM_Ecc_IRQHandler                    ;  EFM_Ecc Handler
    DCD   WDG_IRQHandler                        ;  WDG Handler
    DCD   Reserved5_IRQHandler                  ;  Reserved5 Handler
    DCD   I2C0_Master_Slave_IRQHandler                 ;  I2C0_Master_Slave Handler
    DCD   SPI0_IRQHandler                       ;  SPI0 Handler
    DCD   SPI1_IRQHandler                       ;  SPI1 Handler
    DCD   SPI2_IRQHandler                       ;  SPI2 Handler
    DCD   I2C1_Master_Slave_IRQHandler                 ;  I2C1_Master_Slave Handler
    DCD   LINFlexD0_IRQHandler                  ;  LINFlexD0 Handler
    DCD   Reserved6_IRQHandler                  ;  Reserved6 Handler
    DCD   LINFlexD1_IRQHandler                  ;  LINFlexD1 Handler
    DCD   Reserved7_IRQHandler                  ;  Reserved7 Handler
    DCD   LINFlexD2_IRQHandler                  ;  LINFlexD2 Handler
    DCD   Reserved8_IRQHandler                  ;  Reserved8 Handler
    DCD   QSPI_IRQHandler                       ;  QSPI Handler
    DCD   Reserved9_IRQHandler                  ;  Reserved9 Handler
    DCD   ADC0_IRQHandler                       ;  ADC0 Handler
    DCD   ADC1_IRQHandler                       ;  ADC1 Handler
    DCD   ACMP0_IRQHandler                      ;  ACMP0 Handler
    DCD   ACMP1_IRQHandler                      ;  ACMP1 Handler
    DCD   Reserved10_IRQHandler                 ;  Reserved10 Handler
    DCD   EMU_IRQHandler                        ;  EMU Handler
    DCD   Reserved11_IRQHandler                 ;  Reserved11 Handler
    DCD   RTC_IRQHandler                        ;  RTC Handler
    DCD   RTC_Seconds_IRQHandler                 ;  RTC_Seconds Handler
    DCD   pTMR0_Ch0_IRQHandler                  ;  pTMR0_Ch0 Handler
    DCD   pTMR0_Ch1_IRQHandler                  ;  pTMR0_Ch1 Handler
    DCD   pTMR0_Ch2_IRQHandler                  ;  pTMR0_Ch2 Handler
    DCD   pTMR0_Ch3_IRQHandler                  ;  pTMR0_Ch3 Handler
    DCD   PTU0_IRQHandler                       ;  PTU0 Handler
    DCD   pTMR1_Ch0_IRQHandler                  ;  pTMR1_Ch0 Handler
    DCD   pTMR1_Ch1_IRQHandler                  ;  pTMR1_Ch1 Handler
    DCD   pTMR1_Ch2_IRQHandler                  ;  pTMR1_Ch2 Handler
    DCD   pTMR1_Ch3_IRQHandler                  ;  pTMR1_Ch3 Handler
    DCD   CMU_IRQHandler                        ;  CMU Handler
    DCD   lpTMR0_IRQHandler                     ;  lpTMR0 Handler
    DCD   GPIOA_IRQHandler                      ;  GPIOA Handler
    DCD   GPIOB_IRQHandler                      ;  GPIOB Handler
    DCD   GPIOC_IRQHandler                      ;  GPIOC Handler
    DCD   GPIOD_IRQHandler                      ;  GPIOD Handler
    DCD   GPIOE_IRQHandler                      ;  GPIOE Handler
    DCD   Reserved12_IRQHandler                 ;  Reserved12 Handler
    DCD   Reserved13_IRQHandler                 ;  Reserved13 Handler
    DCD   Reserved14_IRQHandler                 ;  Reserved14 Handler
    DCD   Reserved15_IRQHandler                 ;  Reserved15 Handler
    DCD   PTU1_IRQHandler                       ;  PTU1 Handler
    DCD   Reserved16_IRQHandler                 ;  Reserved16 Handler
    DCD   CAN0_ORed_BusOff_Warning_IRQHandler                 ;  CAN0_ORed_BusOff_Warning Handler
    DCD   CAN0_Error_IRQHandler                 ;  CAN0_Error Handler
    DCD   CAN0_Wake_Up_IRQHandler                 ;  CAN0_Wake_Up Handler
    DCD   CAN0_ORed_0_15_MB_IRQHandler                 ;  CAN0_ORed_0_15_MB Handler
    DCD   CAN0_ORed_16_31_MB_IRQHandler                 ;  CAN0_ORed_16_31_MB Handler
    DCD   CAN0_ORed_32_47_MB_IRQHandler                 ;  CAN0_ORed_32_47_MB Handler
    DCD   CAN0_ORed_48_63_MB_IRQHandler                 ;  CAN0_ORed_48_63_MB Handler
    DCD   CAN0_ORed_64_79_MB_IRQHandler                 ;  CAN0_ORed_64_79_MB Handler
    DCD   CAN0_ORed_80_95_MB_IRQHandler                 ;  CAN0_ORed_80_95_MB Handler
    DCD   CAN0_ORed_96_111_MB_IRQHandler                 ;  CAN0_ORed_96_111_MB Handler
    DCD   CAN0_ORed_112_127_MB_IRQHandler                 ;  CAN0_ORed_112_127_MB Handler
    DCD   CAN1_ORed_BusOff_Warning_IRQHandler                 ;  CAN1_ORed_BusOff_Warning Handler
    DCD   CAN1_Error_IRQHandler                 ;  CAN1_Error Handler
    DCD   CAN1_Wake_Up_IRQHandler                 ;  CAN1_Wake_Up Handler
    DCD   CAN1_ORed_0_15_MB_IRQHandler                 ;  CAN1_ORed_0_15_MB Handler
    DCD   CAN1_ORed_16_31_MB_IRQHandler                 ;  CAN1_ORed_16_31_MB Handler
    DCD   CAN1_ORed_32_47_MB_IRQHandler                 ;  CAN1_ORed_32_47_MB Handler
    DCD   CAN1_ORed_48_63_MB_IRQHandler                 ;  CAN1_ORed_48_63_MB Handler
    DCD   CAN1_ORed_64_79_MB_IRQHandler                 ;  CAN1_ORed_64_79_MB Handler
    DCD   CAN1_ORed_80_95_MB_IRQHandler                 ;  CAN1_ORed_80_95_MB Handler
    DCD   CAN1_ORed_96_111_MB_IRQHandler                 ;  CAN1_ORed_96_111_MB Handler
    DCD   CAN1_ORed_112_127_MB_IRQHandler                 ;  CAN1_ORed_112_127_MB Handler
    DCD   CAN2_ORed_BusOff_Warning_IRQHandler                 ;  CAN2_ORed_BusOff_Warning Handler
    DCD   CAN2_Error_IRQHandler                 ;  CAN2_Error Handler
    DCD   CAN2_Wake_Up_IRQHandler                 ;  CAN2_Wake_Up Handler
    DCD   CAN2_ORed_0_15_MB_IRQHandler                 ;  CAN2_ORed_0_15_MB Handler
    DCD   CAN2_ORed_16_31_MB_IRQHandler                 ;  CAN2_ORed_16_31_MB Handler
    DCD   CAN2_ORed_32_47_MB_IRQHandler                 ;  CAN2_ORed_32_47_MB Handler
    DCD   CAN2_ORed_48_63_MB_IRQHandler                 ;  CAN2_ORed_48_63_MB Handler
    DCD   eTMR0_Ch0_Ch1_IRQHandler                 ;  eTMR0_Ch0_Ch1 Handler
    DCD   eTMR0_Ch2_Ch3_IRQHandler                 ;  eTMR0_Ch2_Ch3 Handler
    DCD   eTMR0_Ch4_Ch5_IRQHandler                 ;  eTMR0_Ch4_Ch5 Handler
    DCD   eTMR0_Ch6_Ch7_IRQHandler                 ;  eTMR0_Ch6_Ch7 Handler
    DCD   eTMR0_Fault_IRQHandler                 ;  eTMR0_Fault Handler
    DCD   eTMR0_Ovf_IRQHandler                  ;  eTMR0_Ovf Handler
    DCD   eTMR1_Ch0_Ch1_IRQHandler                 ;  eTMR1_Ch0_Ch1 Handler
    DCD   eTMR1_Ch2_Ch3_IRQHandler                 ;  eTMR1_Ch2_Ch3 Handler
    DCD   eTMR1_Ch4_Ch5_IRQHandler                 ;  eTMR1_Ch4_Ch5 Handler
    DCD   eTMR1_Ch6_Ch7_IRQHandler                 ;  eTMR1_Ch6_Ch7 Handler
    DCD   eTMR1_Fault_IRQHandler                 ;  eTMR1_Fault Handler
    DCD   eTMR1_Ovf_IRQHandler                  ;  eTMR1_Ovf Handler
    DCD   eTMR2_Ch0_Ch1_IRQHandler                 ;  eTMR2_Ch0_Ch1 Handler
    DCD   eTMR2_Ch2_Ch3_IRQHandler                 ;  eTMR2_Ch2_Ch3 Handler
    DCD   eTMR2_Ch4_Ch5_IRQHandler                 ;  eTMR2_Ch4_Ch5 Handler
    DCD   eTMR2_Ch6_Ch7_IRQHandler                 ;  eTMR2_Ch6_Ch7 Handler
    DCD   eTMR2_Fault_IRQHandler                 ;  eTMR2_Fault Handler
    DCD   eTMR2_Ovf_IRQHandler                  ;  eTMR2_Ovf Handler
    DCD   eTMR3_Ch0_Ch1_IRQHandler                 ;  eTMR3_Ch0_Ch1 Handler
    DCD   eTMR3_Ch2_Ch3_IRQHandler                 ;  eTMR3_Ch2_Ch3 Handler
    DCD   eTMR3_Ch4_Ch5_IRQHandler                 ;  eTMR3_Ch4_Ch5 Handler
    DCD   eTMR3_Ch6_Ch7_IRQHandler                 ;  eTMR3_Ch6_Ch7 Handler
    DCD   eTMR3_Fault_IRQHandler                 ;  eTMR3_Fault Handler
    DCD   eTMR3_Ovf_IRQHandler                  ;  eTMR3_Ovf Handler
    DCD   eTMR4_Ch0_Ch1_IRQHandler                 ;  eTMR4_Ch0_Ch1 Handler
    DCD   eTMR4_Ch2_Ch3_IRQHandler                 ;  eTMR4_Ch2_Ch3 Handler
    DCD   eTMR4_Ch4_Ch5_IRQHandler                 ;  eTMR4_Ch4_Ch5 Handler
    DCD   eTMR4_Ch6_Ch7_IRQHandler                 ;  eTMR4_Ch6_Ch7 Handler
    DCD   eTMR4_Fault_IRQHandler                 ;  eTMR4_Fault Handler
    DCD   eTMR4_Ovf_IRQHandler                  ;  eTMR4_Ovf Handler
    DCD   eTMR5_Ch0_Ch1_IRQHandler                 ;  eTMR5_Ch0_Ch1 Handler
    DCD   eTMR5_Ch2_Ch3_IRQHandler                 ;  eTMR5_Ch2_Ch3 Handler
    DCD   eTMR5_Ch4_Ch5_IRQHandler                 ;  eTMR5_Ch4_Ch5 Handler
    DCD   eTMR5_Ch6_Ch7_IRQHandler                 ;  eTMR5_Ch6_Ch7 Handler
    DCD   eTMR5_Fault_IRQHandler                 ;  eTMR5_Fault Handler
    DCD   eTMR5_Ovf_IRQHandler                  ;  eTMR5_Ovf Handler
    DCD   pTMR2_Ch0_IRQHandler                  ;  pTMR2_Ch0 Handler
    DCD   pTMR2_Ch1_IRQHandler                  ;  pTMR2_Ch1 Handler
    DCD   pTMR2_Ch2_IRQHandler                  ;  pTMR2_Ch2 Handler
    DCD   pTMR2_Ch3_IRQHandler                  ;  pTMR2_Ch3 Handler
    DCD   Reserved17_IRQHandler                 ;  Reserved17 Handler
    DCD   Reserved18_IRQHandler                 ;  Reserved18 Handler
    DCD   Reserved19_IRQHandler                 ;  Reserved19 Handler
    DCD   Reserved20_IRQHandler                 ;  Reserved20 Handler
    DCD   SENT0_IRQHandler                      ;  SENT0 Handler
    DCD   SENT1_IRQHandler                      ;  SENT1 Handler
    DCD   FMU_Alarm_IRQHandler                  ;  FMU_Alarm Handler
    DCD   FMU_MISC_IRQHandler                   ;  FMU_MISC Handler
    DCD   TRNG_IRQHandler                       ;  TRNG Handler
    DCD   HCU_IRQHandler                        ;  HCU Handler
    DCD   INTM_IRQHandler                       ;  INTM Handler
    DCD   TMR0_IRQHandler                       ;  TMR0 Handler
    DCD   LINFlexD3_IRQHandler                  ;  LINFlexD3 Handler
    DCD   LINFlexD4_IRQHandler                  ;  LINFlexD4 Handler
    DCD   LINFlexD5_IRQHandler                  ;  LINFlexD5 Handler
    DCD   I2C2_Master_Slave_IRQHandler                 ;  I2C2_Master_Slave Handler
    DCD   SPI3_IRQHandler                       ;  SPI3 Handler
    DCD   SPI4_IRQHandler                       ;  SPI4 Handler
    DCD   SPI5_IRQHandler                       ;  SPI5 Handler
    DCD   CAN3_ORed_BusOff_Warning_IRQHandler                 ;  CAN3_ORed_BusOff_Warning Handler
    DCD   CAN3_Error_IRQHandler                 ;  CAN3_Error Handler
    DCD   CAN3_Wake_Up_IRQHandler                 ;  CAN3_Wake_Up Handler
    DCD   CAN3_ORed_0_15_MB_IRQHandler                 ;  CAN3_ORed_0_15_MB Handler
    DCD   CAN3_ORed_16_31_MB_IRQHandler                 ;  CAN3_ORed_16_31_MB Handler
    DCD   CAN3_ORed_32_47_MB_IRQHandler                 ;  CAN3_ORed_32_47_MB Handler
    DCD   CAN3_ORed_48_63_MB_IRQHandler                 ;  CAN3_ORed_48_63_MB Handler
    DCD   CAN4_ORed_BusOff_Warning_IRQHandler                 ;  CAN4_ORed_BusOff_Warning Handler
    DCD   CAN4_Error_IRQHandler                 ;  CAN4_Error Handler
    DCD   CAN4_Wake_Up_IRQHandler                 ;  CAN4_Wake_Up Handler
    DCD   CAN4_ORed_0_15_MB_IRQHandler                 ;  CAN4_ORed_0_15_MB Handler
    DCD   CAN4_ORed_16_31_MB_IRQHandler                 ;  CAN4_ORed_16_31_MB Handler
    DCD   CAN4_ORed_32_47_MB_IRQHandler                 ;  CAN4_ORed_32_47_MB Handler
    DCD   CAN4_ORed_48_63_MB_IRQHandler                 ;  CAN4_ORed_48_63_MB Handler
    DCD   CAN5_ORed_BusOff_Warning_IRQHandler                 ;  CAN5_ORed_BusOff_Warning Handler
    DCD   CAN5_Error_IRQHandler                 ;  CAN5_Error Handler
    DCD   CAN5_Wake_Up_IRQHandler                 ;  CAN5_Wake_Up Handler
    DCD   CAN5_ORed_0_15_MB_IRQHandler                 ;  CAN5_ORed_0_15_MB Handler
    DCD   CAN5_ORed_16_31_MB_IRQHandler                 ;  CAN5_ORed_16_31_MB Handler
    DCD   WKU_IRQHandler                        ;  WKU Handler
    DCD   LINFlexD6_IRQHandler                  ;  LINFlexD6 Handler
    DCD   LINFlexD7_IRQHandler                  ;  LINFlexD7 Handler
    DCD   LINFlexD8_IRQHandler                  ;  LINFlexD8 Handler
    DCD   LINFlexD9_IRQHandler                  ;  LINFlexD9 Handler
    DCD   SPI6_IRQHandler                       ;  SPI6 Handler
    DCD   SPI7_IRQHandler                       ;  SPI7 Handler
    DCD   I2C3_Master_Slave_IRQHandler                 ;  I2C3_Master_Slave Handler
    DCD   I2C4_Master_Slave_IRQHandler                 ;  I2C4_Master_Slave Handler
    DCD   Reserved21_IRQHandler                 ;  Reserved21 Handler
    DCD   CAN6_ORed_BusOff_Warning_IRQHandler                 ;  CAN6_ORed_BusOff_Warning Handler
    DCD   CAN6_Error_IRQHandler                 ;  CAN6_Error Handler
    DCD   CAN6_Wake_Up_IRQHandler                 ;  CAN6_Wake_Up Handler
    DCD   CAN6_ORed_0_15_MB_IRQHandler                 ;  CAN6_ORed_0_15_MB Handler
    DCD   CAN6_ORed_16_31_MB_IRQHandler                 ;  CAN6_ORed_16_31_MB Handler
    DCD   TMR1_IRQHandler                       ;  TMR1 Handler
    DCD   Reserved22_IRQHandler                 ;  Reserved22 Handler
    DCD   CORE_CTI_IRQHandler                   ;  CORE_CTI Handler
    DCD   Reserved23_IRQHandler                 ;  Reserved23 Handler
    DCD   SAI0_IRQHandler                       ;  SAI0 Handler
    DCD   SAI1_IRQHandler                       ;  SAI1 Handler
    DCD   ENET_IRQHandler                       ;  ENET Handler
    DCD   ENET_TX_IRQHandler                    ;  ENET_TX Handler
    DCD   ENET_RX_IRQHandler                    ;  ENET_RX Handler
    DCD   ENET_ECC_IRQHandler                   ;  ENET_ECC Handler
    DCD   Reserved24_IRQHandler                 ;  Reserved24 Handler
    DCD   Reserved25_IRQHandler                 ;  Reserved25 Handler
    DCD   CAN7_ORed_BusOff_Warning_IRQHandler                 ;  CAN7_ORed_BusOff_Warning Handler
    DCD   CAN7_Error_IRQHandler                 ;  CAN7_Error Handler
    DCD   CAN7_Wake_Up_IRQHandler                 ;  CAN7_Wake_Up Handler
    DCD   CAN7_ORed_0_15_MB_IRQHandler                 ;  CAN7_ORed_0_15_MB Handler
    DCD   CAN7_ORed_16_31_MB_IRQHandler                 ;  CAN7_ORed_16_31_MB Handler
    DCD   MPWM0_Ch0_Ch7_IRQHandler                 ;  MPWM0_Ch0_Ch7 Handler
    DCD   MPWM0_Ch8_Ch15_IRQHandler                 ;  MPWM0_Ch8_Ch15 Handler
    DCD   MPWM1_Ch0_Ch7_IRQHandler                 ;  MPWM1_Ch0_Ch7 Handler
    DCD   MPWM1_Ch8_Ch15_IRQHandler                 ;  MPWM1_Ch8_Ch15 Handler
    DCD   MPWM2_Ch0_Ch7_IRQHandler                 ;  MPWM2_Ch0_Ch7 Handler
    DCD   MPWM2_Ch8_Ch15_IRQHandler                 ;  MPWM2_Ch8_Ch15 Handler

__Vectors_End

__Vectors_Size  EQU   __Vectors_End - __VECTOR_TABLE

RCU_RSSR_REG_ADDR  EQU  0x401FC000
POR_LVR_BIT_MASK   EQU  0x00000001
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



    AREA    |.text|, CODE, READONLY
                
Reset_Handler   PROC
    ALIGN   4
    EXPORT  Reset_Handler               [WEAK]
    IMPORT  __main
    IMPORT  SystemInit
    IMPORT  init_data_bss

    CPSID   I               ; Mask interrupts
    ;; Init the rest of the registers
    LDR     R1,=0
    LDR     R2,=0
    LDR     R3,=0
    LDR     R4,=0
    LDR     R5,=0
    LDR     R6,=0
    LDR     R7,=0
    MOV     R8,R7
    MOV     R9,R7
    MOV     R10,R7
    MOV     R11,R7
    MOV     R12,R7

    LDR     R1, =__RAM_START
    LDR     R1, [R1]
    LDR     R2, =__RAM_END
    LDR     R2, [R2]
    SUBS    R2, R1
    MOV     R0, #0
    MOV     R3, #0
SRAM_LOOP
    STM     R1!, {R0, R3}
	SUBS    R2, #8
	CMP     R2, #0
    BGE     SRAM_LOOP

	;; Check POR flag, if set, do ECC initialization for retention ram
    LDR     R0, =RCU_RSSR_REG_ADDR
	LDR     R1, =POR_LVR_BIT_MASK
	LDR     R2, [R0, #0]
	AND     R1, R1, R2
	CMP     R1, #0
	BEQ     LC6
	LDR     R1, =__RETENTION_RAM_START
	LDR     R1, [R1]
	LDR     R2, =__RETENTION_RAM_END
	LDR     R2, [R2]
	SUBS    R2, R1
	MOV     R0, #0
	MOV     R3, #0
RETENTION_RAM_LOOP
	STM     R1!, {R0, R3}
	SUBS    R2, #8
	CMP     R2, #0
	BGE     RETENTION_RAM_LOOP
	
LC6
    LDR     R0, =__VECTOR_TABLE
    LDR     R1, [R0]
    MSR     MSP, R1
    
    LDR     R0, =SystemInit
    BLX     R0
    LDR     R0, =init_data_bss
    BLX     R0
    
    CPSIE   I               ; Unmask interrupts
    
    LDR     R0, =__main
    BX      R0
    ENDP    


NMI_Handler     PROC
    EXPORT  NMI_Handler             [WEAK]
    B       .
    ENDP

HardFault_Handler\
    PROC
    EXPORT  HardFault_Handler       [WEAK]
    B       .
    ENDP

SVC_Handler     PROC
    EXPORT  SVC_Handler             [WEAK]
    B       .
    ENDP

PendSV_Handler  PROC
    EXPORT  PendSV_Handler          [WEAK]
    B       .
    ENDP

SysTick_Handler PROC
    EXPORT  SysTick_Handler         [WEAK]
    B       .
    ENDP

DefaultISR      PROC
    EXPORT   DefaultISR             [WEAK]
    B       .
    ENDP

Default_Handler PROC
    EXPORT   DMA0_IRQHandler                [WEAK]
    EXPORT   DMA1_IRQHandler                [WEAK]
    EXPORT   DMA2_IRQHandler                [WEAK]
    EXPORT   DMA3_IRQHandler                [WEAK]
    EXPORT   DMA4_IRQHandler                [WEAK]
    EXPORT   DMA5_IRQHandler                [WEAK]
    EXPORT   DMA6_IRQHandler                [WEAK]
    EXPORT   DMA7_IRQHandler                [WEAK]
    EXPORT   DMA8_IRQHandler                [WEAK]
    EXPORT   DMA9_IRQHandler                [WEAK]
    EXPORT   DMA10_IRQHandler               [WEAK]
    EXPORT   DMA11_IRQHandler               [WEAK]
    EXPORT   DMA12_IRQHandler               [WEAK]
    EXPORT   DMA13_IRQHandler               [WEAK]
    EXPORT   DMA14_IRQHandler               [WEAK]
    EXPORT   DMA15_IRQHandler               [WEAK]
    EXPORT   DMA16_IRQHandler               [WEAK]
    EXPORT   DMA17_IRQHandler               [WEAK]
    EXPORT   DMA18_IRQHandler               [WEAK]
    EXPORT   DMA19_IRQHandler               [WEAK]
    EXPORT   DMA20_IRQHandler               [WEAK]
    EXPORT   DMA21_IRQHandler               [WEAK]
    EXPORT   DMA22_IRQHandler               [WEAK]
    EXPORT   DMA23_IRQHandler               [WEAK]
    EXPORT   DMA24_IRQHandler               [WEAK]
    EXPORT   DMA25_IRQHandler               [WEAK]
    EXPORT   DMA26_IRQHandler               [WEAK]
    EXPORT   DMA27_IRQHandler               [WEAK]
    EXPORT   DMA28_IRQHandler               [WEAK]
    EXPORT   DMA29_IRQHandler               [WEAK]
    EXPORT   DMA30_IRQHandler               [WEAK]
    EXPORT   DMA31_IRQHandler               [WEAK]
    EXPORT   DMA_Error_IRQHandler           [WEAK]
    EXPORT   FPU_IRQHandler                 [WEAK]
    EXPORT   EFM_IRQHandler                 [WEAK]
    EXPORT   EFM_Error_IRQHandler           [WEAK]
    EXPORT   PCU_IRQHandler                 [WEAK]
    EXPORT   EFM_Ecc_IRQHandler             [WEAK]
    EXPORT   WDG_IRQHandler                 [WEAK]
    EXPORT   Reserved5_IRQHandler           [WEAK]
    EXPORT   I2C0_Master_Slave_IRQHandler   [WEAK]
    EXPORT   SPI0_IRQHandler                [WEAK]
    EXPORT   SPI1_IRQHandler                [WEAK]
    EXPORT   SPI2_IRQHandler                [WEAK]
    EXPORT   I2C1_Master_Slave_IRQHandler   [WEAK]
    EXPORT   LINFlexD0_IRQHandler           [WEAK]
    EXPORT   Reserved6_IRQHandler           [WEAK]
    EXPORT   LINFlexD1_IRQHandler           [WEAK]
    EXPORT   Reserved7_IRQHandler           [WEAK]
    EXPORT   LINFlexD2_IRQHandler           [WEAK]
    EXPORT   Reserved8_IRQHandler           [WEAK]
    EXPORT   QSPI_IRQHandler                [WEAK]
    EXPORT   Reserved9_IRQHandler           [WEAK]
    EXPORT   ADC0_IRQHandler                [WEAK]
    EXPORT   ADC1_IRQHandler                [WEAK]
    EXPORT   ACMP0_IRQHandler               [WEAK]
    EXPORT   ACMP1_IRQHandler               [WEAK]
    EXPORT   Reserved10_IRQHandler          [WEAK]
    EXPORT   EMU_IRQHandler                 [WEAK]
    EXPORT   Reserved11_IRQHandler          [WEAK]
    EXPORT   RTC_IRQHandler                 [WEAK]
    EXPORT   RTC_Seconds_IRQHandler         [WEAK]
    EXPORT   pTMR0_Ch0_IRQHandler           [WEAK]
    EXPORT   pTMR0_Ch1_IRQHandler           [WEAK]
    EXPORT   pTMR0_Ch2_IRQHandler           [WEAK]
    EXPORT   pTMR0_Ch3_IRQHandler           [WEAK]
    EXPORT   PTU0_IRQHandler                [WEAK]
    EXPORT   pTMR1_Ch0_IRQHandler           [WEAK]
    EXPORT   pTMR1_Ch1_IRQHandler           [WEAK]
    EXPORT   pTMR1_Ch2_IRQHandler           [WEAK]
    EXPORT   pTMR1_Ch3_IRQHandler           [WEAK]
    EXPORT   CMU_IRQHandler                 [WEAK]
    EXPORT   lpTMR0_IRQHandler              [WEAK]
    EXPORT   GPIOA_IRQHandler               [WEAK]
    EXPORT   GPIOB_IRQHandler               [WEAK]
    EXPORT   GPIOC_IRQHandler               [WEAK]
    EXPORT   GPIOD_IRQHandler               [WEAK]
    EXPORT   GPIOE_IRQHandler               [WEAK]
    EXPORT   Reserved12_IRQHandler          [WEAK]
    EXPORT   Reserved13_IRQHandler          [WEAK]
    EXPORT   Reserved14_IRQHandler          [WEAK]
    EXPORT   Reserved15_IRQHandler          [WEAK]
    EXPORT   PTU1_IRQHandler                [WEAK]
    EXPORT   Reserved16_IRQHandler          [WEAK]
    EXPORT   CAN0_ORed_BusOff_Warning_IRQHandler [WEAK]
    EXPORT   CAN0_Error_IRQHandler          [WEAK]
    EXPORT   CAN0_Wake_Up_IRQHandler        [WEAK]
    EXPORT   CAN0_ORed_0_15_MB_IRQHandler   [WEAK]
    EXPORT   CAN0_ORed_16_31_MB_IRQHandler  [WEAK]
    EXPORT   CAN0_ORed_32_47_MB_IRQHandler  [WEAK]
    EXPORT   CAN0_ORed_48_63_MB_IRQHandler  [WEAK]
    EXPORT   CAN0_ORed_64_79_MB_IRQHandler  [WEAK]
    EXPORT   CAN0_ORed_80_95_MB_IRQHandler  [WEAK]
    EXPORT   CAN0_ORed_96_111_MB_IRQHandler [WEAK]
    EXPORT   CAN0_ORed_112_127_MB_IRQHandler [WEAK]
    EXPORT   CAN1_ORed_BusOff_Warning_IRQHandler [WEAK]
    EXPORT   CAN1_Error_IRQHandler          [WEAK]
    EXPORT   CAN1_Wake_Up_IRQHandler        [WEAK]
    EXPORT   CAN1_ORed_0_15_MB_IRQHandler   [WEAK]
    EXPORT   CAN1_ORed_16_31_MB_IRQHandler  [WEAK]
    EXPORT   CAN1_ORed_32_47_MB_IRQHandler  [WEAK]
    EXPORT   CAN1_ORed_48_63_MB_IRQHandler  [WEAK]
    EXPORT   CAN1_ORed_64_79_MB_IRQHandler  [WEAK]
    EXPORT   CAN1_ORed_80_95_MB_IRQHandler  [WEAK]
    EXPORT   CAN1_ORed_96_111_MB_IRQHandler [WEAK]
    EXPORT   CAN1_ORed_112_127_MB_IRQHandler [WEAK]
    EXPORT   CAN2_ORed_BusOff_Warning_IRQHandler [WEAK]
    EXPORT   CAN2_Error_IRQHandler          [WEAK]
    EXPORT   CAN2_Wake_Up_IRQHandler        [WEAK]
    EXPORT   CAN2_ORed_0_15_MB_IRQHandler   [WEAK]
    EXPORT   CAN2_ORed_16_31_MB_IRQHandler  [WEAK]
    EXPORT   CAN2_ORed_32_47_MB_IRQHandler  [WEAK]
    EXPORT   CAN2_ORed_48_63_MB_IRQHandler  [WEAK]
    EXPORT   eTMR0_Ch0_Ch1_IRQHandler       [WEAK]
    EXPORT   eTMR0_Ch2_Ch3_IRQHandler       [WEAK]
    EXPORT   eTMR0_Ch4_Ch5_IRQHandler       [WEAK]
    EXPORT   eTMR0_Ch6_Ch7_IRQHandler       [WEAK]
    EXPORT   eTMR0_Fault_IRQHandler         [WEAK]
    EXPORT   eTMR0_Ovf_IRQHandler           [WEAK]
    EXPORT   eTMR1_Ch0_Ch1_IRQHandler       [WEAK]
    EXPORT   eTMR1_Ch2_Ch3_IRQHandler       [WEAK]
    EXPORT   eTMR1_Ch4_Ch5_IRQHandler       [WEAK]
    EXPORT   eTMR1_Ch6_Ch7_IRQHandler       [WEAK]
    EXPORT   eTMR1_Fault_IRQHandler         [WEAK]
    EXPORT   eTMR1_Ovf_IRQHandler           [WEAK]
    EXPORT   eTMR2_Ch0_Ch1_IRQHandler       [WEAK]
    EXPORT   eTMR2_Ch2_Ch3_IRQHandler       [WEAK]
    EXPORT   eTMR2_Ch4_Ch5_IRQHandler       [WEAK]
    EXPORT   eTMR2_Ch6_Ch7_IRQHandler       [WEAK]
    EXPORT   eTMR2_Fault_IRQHandler         [WEAK]
    EXPORT   eTMR2_Ovf_IRQHandler           [WEAK]
    EXPORT   eTMR3_Ch0_Ch1_IRQHandler       [WEAK]
    EXPORT   eTMR3_Ch2_Ch3_IRQHandler       [WEAK]
    EXPORT   eTMR3_Ch4_Ch5_IRQHandler       [WEAK]
    EXPORT   eTMR3_Ch6_Ch7_IRQHandler       [WEAK]
    EXPORT   eTMR3_Fault_IRQHandler         [WEAK]
    EXPORT   eTMR3_Ovf_IRQHandler           [WEAK]
    EXPORT   eTMR4_Ch0_Ch1_IRQHandler       [WEAK]
    EXPORT   eTMR4_Ch2_Ch3_IRQHandler       [WEAK]
    EXPORT   eTMR4_Ch4_Ch5_IRQHandler       [WEAK]
    EXPORT   eTMR4_Ch6_Ch7_IRQHandler       [WEAK]
    EXPORT   eTMR4_Fault_IRQHandler         [WEAK]
    EXPORT   eTMR4_Ovf_IRQHandler           [WEAK]
    EXPORT   eTMR5_Ch0_Ch1_IRQHandler       [WEAK]
    EXPORT   eTMR5_Ch2_Ch3_IRQHandler       [WEAK]
    EXPORT   eTMR5_Ch4_Ch5_IRQHandler       [WEAK]
    EXPORT   eTMR5_Ch6_Ch7_IRQHandler       [WEAK]
    EXPORT   eTMR5_Fault_IRQHandler         [WEAK]
    EXPORT   eTMR5_Ovf_IRQHandler           [WEAK]
    EXPORT   pTMR2_Ch0_IRQHandler           [WEAK]
    EXPORT   pTMR2_Ch1_IRQHandler           [WEAK]
    EXPORT   pTMR2_Ch2_IRQHandler           [WEAK]
    EXPORT   pTMR2_Ch3_IRQHandler           [WEAK]
    EXPORT   Reserved17_IRQHandler          [WEAK]
    EXPORT   Reserved18_IRQHandler          [WEAK]
    EXPORT   Reserved19_IRQHandler          [WEAK]
    EXPORT   Reserved20_IRQHandler          [WEAK]
    EXPORT   SENT0_IRQHandler               [WEAK]
    EXPORT   SENT1_IRQHandler               [WEAK]
    EXPORT   FMU_Alarm_IRQHandler           [WEAK]
    EXPORT   FMU_MISC_IRQHandler            [WEAK]
    EXPORT   TRNG_IRQHandler                [WEAK]
    EXPORT   HCU_IRQHandler                 [WEAK]
    EXPORT   INTM_IRQHandler                [WEAK]
    EXPORT   TMR0_IRQHandler                [WEAK]
    EXPORT   LINFlexD3_IRQHandler           [WEAK]
    EXPORT   LINFlexD4_IRQHandler           [WEAK]
    EXPORT   LINFlexD5_IRQHandler           [WEAK]
    EXPORT   I2C2_Master_Slave_IRQHandler   [WEAK]
    EXPORT   SPI3_IRQHandler                [WEAK]
    EXPORT   SPI4_IRQHandler                [WEAK]
    EXPORT   SPI5_IRQHandler                [WEAK]
    EXPORT   CAN3_ORed_BusOff_Warning_IRQHandler [WEAK]
    EXPORT   CAN3_Error_IRQHandler          [WEAK]
    EXPORT   CAN3_Wake_Up_IRQHandler        [WEAK]
    EXPORT   CAN3_ORed_0_15_MB_IRQHandler   [WEAK]
    EXPORT   CAN3_ORed_16_31_MB_IRQHandler  [WEAK]
    EXPORT   CAN3_ORed_32_47_MB_IRQHandler  [WEAK]
    EXPORT   CAN3_ORed_48_63_MB_IRQHandler  [WEAK]
    EXPORT   CAN4_ORed_BusOff_Warning_IRQHandler [WEAK]
    EXPORT   CAN4_Error_IRQHandler          [WEAK]
    EXPORT   CAN4_Wake_Up_IRQHandler        [WEAK]
    EXPORT   CAN4_ORed_0_15_MB_IRQHandler   [WEAK]
    EXPORT   CAN4_ORed_16_31_MB_IRQHandler  [WEAK]
    EXPORT   CAN4_ORed_32_47_MB_IRQHandler  [WEAK]
    EXPORT   CAN4_ORed_48_63_MB_IRQHandler  [WEAK]
    EXPORT   CAN5_ORed_BusOff_Warning_IRQHandler [WEAK]
    EXPORT   CAN5_Error_IRQHandler          [WEAK]
    EXPORT   CAN5_Wake_Up_IRQHandler        [WEAK]
    EXPORT   CAN5_ORed_0_15_MB_IRQHandler   [WEAK]
    EXPORT   CAN5_ORed_16_31_MB_IRQHandler  [WEAK]
    EXPORT   WKU_IRQHandler                 [WEAK]
    EXPORT   LINFlexD6_IRQHandler           [WEAK]
    EXPORT   LINFlexD7_IRQHandler           [WEAK]
    EXPORT   LINFlexD8_IRQHandler           [WEAK]
    EXPORT   LINFlexD9_IRQHandler           [WEAK]
    EXPORT   SPI6_IRQHandler                [WEAK]
    EXPORT   SPI7_IRQHandler                [WEAK]
    EXPORT   I2C3_Master_Slave_IRQHandler   [WEAK]
    EXPORT   I2C4_Master_Slave_IRQHandler   [WEAK]
    EXPORT   Reserved21_IRQHandler          [WEAK]
    EXPORT   CAN6_ORed_BusOff_Warning_IRQHandler [WEAK]
    EXPORT   CAN6_Error_IRQHandler          [WEAK]
    EXPORT   CAN6_Wake_Up_IRQHandler        [WEAK]
    EXPORT   CAN6_ORed_0_15_MB_IRQHandler   [WEAK]
    EXPORT   CAN6_ORed_16_31_MB_IRQHandler  [WEAK]
    EXPORT   TMR1_IRQHandler                [WEAK]
    EXPORT   Reserved22_IRQHandler          [WEAK]
    EXPORT   CORE_CTI_IRQHandler            [WEAK]
    EXPORT   Reserved23_IRQHandler          [WEAK]
    EXPORT   SAI0_IRQHandler                [WEAK]
    EXPORT   SAI1_IRQHandler                [WEAK]
    EXPORT   ENET_IRQHandler                [WEAK]
    EXPORT   ENET_TX_IRQHandler             [WEAK]
    EXPORT   ENET_RX_IRQHandler             [WEAK]
    EXPORT   ENET_ECC_IRQHandler            [WEAK]
    EXPORT   Reserved24_IRQHandler          [WEAK]
    EXPORT   Reserved25_IRQHandler          [WEAK]
    EXPORT   CAN7_ORed_BusOff_Warning_IRQHandler [WEAK]
    EXPORT   CAN7_Error_IRQHandler          [WEAK]
    EXPORT   CAN7_Wake_Up_IRQHandler        [WEAK]
    EXPORT   CAN7_ORed_0_15_MB_IRQHandler   [WEAK]
    EXPORT   CAN7_ORed_16_31_MB_IRQHandler  [WEAK]
    EXPORT   MPWM0_Ch0_Ch7_IRQHandler       [WEAK]
    EXPORT   MPWM0_Ch8_Ch15_IRQHandler      [WEAK]
    EXPORT   MPWM1_Ch0_Ch7_IRQHandler       [WEAK]
    EXPORT   MPWM1_Ch8_Ch15_IRQHandler      [WEAK]
    EXPORT   MPWM2_Ch0_Ch7_IRQHandler       [WEAK]
    EXPORT   MPWM2_Ch8_Ch15_IRQHandler      [WEAK]

DMA0_IRQHandler
DMA1_IRQHandler
DMA2_IRQHandler
DMA3_IRQHandler
DMA4_IRQHandler
DMA5_IRQHandler
DMA6_IRQHandler
DMA7_IRQHandler
DMA8_IRQHandler
DMA9_IRQHandler
DMA10_IRQHandler
DMA11_IRQHandler
DMA12_IRQHandler
DMA13_IRQHandler
DMA14_IRQHandler
DMA15_IRQHandler
DMA16_IRQHandler
DMA17_IRQHandler
DMA18_IRQHandler
DMA19_IRQHandler
DMA20_IRQHandler
DMA21_IRQHandler
DMA22_IRQHandler
DMA23_IRQHandler
DMA24_IRQHandler
DMA25_IRQHandler
DMA26_IRQHandler
DMA27_IRQHandler
DMA28_IRQHandler
DMA29_IRQHandler
DMA30_IRQHandler
DMA31_IRQHandler
DMA_Error_IRQHandler
FPU_IRQHandler
EFM_IRQHandler
EFM_Error_IRQHandler
PCU_IRQHandler
EFM_Ecc_IRQHandler
WDG_IRQHandler
Reserved5_IRQHandler
I2C0_Master_Slave_IRQHandler
SPI0_IRQHandler
SPI1_IRQHandler
SPI2_IRQHandler
I2C1_Master_Slave_IRQHandler
LINFlexD0_IRQHandler
Reserved6_IRQHandler
LINFlexD1_IRQHandler
Reserved7_IRQHandler
LINFlexD2_IRQHandler
Reserved8_IRQHandler
QSPI_IRQHandler
Reserved9_IRQHandler
ADC0_IRQHandler
ADC1_IRQHandler
ACMP0_IRQHandler
ACMP1_IRQHandler
Reserved10_IRQHandler
EMU_IRQHandler
Reserved11_IRQHandler
RTC_IRQHandler
RTC_Seconds_IRQHandler
pTMR0_Ch0_IRQHandler
pTMR0_Ch1_IRQHandler
pTMR0_Ch2_IRQHandler
pTMR0_Ch3_IRQHandler
PTU0_IRQHandler
pTMR1_Ch0_IRQHandler
pTMR1_Ch1_IRQHandler
pTMR1_Ch2_IRQHandler
pTMR1_Ch3_IRQHandler
CMU_IRQHandler
lpTMR0_IRQHandler
GPIOA_IRQHandler
GPIOB_IRQHandler
GPIOC_IRQHandler
GPIOD_IRQHandler
GPIOE_IRQHandler
Reserved12_IRQHandler
Reserved13_IRQHandler
Reserved14_IRQHandler
Reserved15_IRQHandler
PTU1_IRQHandler
Reserved16_IRQHandler
CAN0_ORed_BusOff_Warning_IRQHandler
CAN0_Error_IRQHandler
CAN0_Wake_Up_IRQHandler
CAN0_ORed_0_15_MB_IRQHandler
CAN0_ORed_16_31_MB_IRQHandler
CAN0_ORed_32_47_MB_IRQHandler
CAN0_ORed_48_63_MB_IRQHandler
CAN0_ORed_64_79_MB_IRQHandler
CAN0_ORed_80_95_MB_IRQHandler
CAN0_ORed_96_111_MB_IRQHandler
CAN0_ORed_112_127_MB_IRQHandler
CAN1_ORed_BusOff_Warning_IRQHandler
CAN1_Error_IRQHandler
CAN1_Wake_Up_IRQHandler
CAN1_ORed_0_15_MB_IRQHandler
CAN1_ORed_16_31_MB_IRQHandler
CAN1_ORed_32_47_MB_IRQHandler
CAN1_ORed_48_63_MB_IRQHandler
CAN1_ORed_64_79_MB_IRQHandler
CAN1_ORed_80_95_MB_IRQHandler
CAN1_ORed_96_111_MB_IRQHandler
CAN1_ORed_112_127_MB_IRQHandler
CAN2_ORed_BusOff_Warning_IRQHandler
CAN2_Error_IRQHandler
CAN2_Wake_Up_IRQHandler
CAN2_ORed_0_15_MB_IRQHandler
CAN2_ORed_16_31_MB_IRQHandler
CAN2_ORed_32_47_MB_IRQHandler
CAN2_ORed_48_63_MB_IRQHandler
eTMR0_Ch0_Ch1_IRQHandler
eTMR0_Ch2_Ch3_IRQHandler
eTMR0_Ch4_Ch5_IRQHandler
eTMR0_Ch6_Ch7_IRQHandler
eTMR0_Fault_IRQHandler
eTMR0_Ovf_IRQHandler
eTMR1_Ch0_Ch1_IRQHandler
eTMR1_Ch2_Ch3_IRQHandler
eTMR1_Ch4_Ch5_IRQHandler
eTMR1_Ch6_Ch7_IRQHandler
eTMR1_Fault_IRQHandler
eTMR1_Ovf_IRQHandler
eTMR2_Ch0_Ch1_IRQHandler
eTMR2_Ch2_Ch3_IRQHandler
eTMR2_Ch4_Ch5_IRQHandler
eTMR2_Ch6_Ch7_IRQHandler
eTMR2_Fault_IRQHandler
eTMR2_Ovf_IRQHandler
eTMR3_Ch0_Ch1_IRQHandler
eTMR3_Ch2_Ch3_IRQHandler
eTMR3_Ch4_Ch5_IRQHandler
eTMR3_Ch6_Ch7_IRQHandler
eTMR3_Fault_IRQHandler
eTMR3_Ovf_IRQHandler
eTMR4_Ch0_Ch1_IRQHandler
eTMR4_Ch2_Ch3_IRQHandler
eTMR4_Ch4_Ch5_IRQHandler
eTMR4_Ch6_Ch7_IRQHandler
eTMR4_Fault_IRQHandler
eTMR4_Ovf_IRQHandler
eTMR5_Ch0_Ch1_IRQHandler
eTMR5_Ch2_Ch3_IRQHandler
eTMR5_Ch4_Ch5_IRQHandler
eTMR5_Ch6_Ch7_IRQHandler
eTMR5_Fault_IRQHandler
eTMR5_Ovf_IRQHandler
pTMR2_Ch0_IRQHandler
pTMR2_Ch1_IRQHandler
pTMR2_Ch2_IRQHandler
pTMR2_Ch3_IRQHandler
Reserved17_IRQHandler
Reserved18_IRQHandler
Reserved19_IRQHandler
Reserved20_IRQHandler
SENT0_IRQHandler
SENT1_IRQHandler
FMU_Alarm_IRQHandler
FMU_MISC_IRQHandler
TRNG_IRQHandler
HCU_IRQHandler
INTM_IRQHandler
TMR0_IRQHandler
LINFlexD3_IRQHandler
LINFlexD4_IRQHandler
LINFlexD5_IRQHandler
I2C2_Master_Slave_IRQHandler
SPI3_IRQHandler
SPI4_IRQHandler
SPI5_IRQHandler
CAN3_ORed_BusOff_Warning_IRQHandler
CAN3_Error_IRQHandler
CAN3_Wake_Up_IRQHandler
CAN3_ORed_0_15_MB_IRQHandler
CAN3_ORed_16_31_MB_IRQHandler
CAN3_ORed_32_47_MB_IRQHandler
CAN3_ORed_48_63_MB_IRQHandler
CAN4_ORed_BusOff_Warning_IRQHandler
CAN4_Error_IRQHandler
CAN4_Wake_Up_IRQHandler
CAN4_ORed_0_15_MB_IRQHandler
CAN4_ORed_16_31_MB_IRQHandler
CAN4_ORed_32_47_MB_IRQHandler
CAN4_ORed_48_63_MB_IRQHandler
CAN5_ORed_BusOff_Warning_IRQHandler
CAN5_Error_IRQHandler
CAN5_Wake_Up_IRQHandler
CAN5_ORed_0_15_MB_IRQHandler
CAN5_ORed_16_31_MB_IRQHandler
WKU_IRQHandler
LINFlexD6_IRQHandler
LINFlexD7_IRQHandler
LINFlexD8_IRQHandler
LINFlexD9_IRQHandler
SPI6_IRQHandler
SPI7_IRQHandler
I2C3_Master_Slave_IRQHandler
I2C4_Master_Slave_IRQHandler
Reserved21_IRQHandler
CAN6_ORed_BusOff_Warning_IRQHandler
CAN6_Error_IRQHandler
CAN6_Wake_Up_IRQHandler
CAN6_ORed_0_15_MB_IRQHandler
CAN6_ORed_16_31_MB_IRQHandler
TMR1_IRQHandler
Reserved22_IRQHandler
CORE_CTI_IRQHandler
Reserved23_IRQHandler
SAI0_IRQHandler
SAI1_IRQHandler
ENET_IRQHandler
ENET_TX_IRQHandler
ENET_RX_IRQHandler
ENET_ECC_IRQHandler
Reserved24_IRQHandler
Reserved25_IRQHandler
CAN7_ORed_BusOff_Warning_IRQHandler
CAN7_Error_IRQHandler
CAN7_Wake_Up_IRQHandler
CAN7_ORed_0_15_MB_IRQHandler
CAN7_ORed_16_31_MB_IRQHandler
MPWM0_Ch0_Ch7_IRQHandler
MPWM0_Ch8_Ch15_IRQHandler
MPWM1_Ch0_Ch7_IRQHandler
MPWM1_Ch8_Ch15_IRQHandler
MPWM2_Ch0_Ch7_IRQHandler
MPWM2_Ch8_Ch15_IRQHandler
    B       .

    ENDP
    ALIGN 4

    END