# Flash_Demo

---

## 硬件要求

- **EVB**: YTM32B1LE1-EVB-Q48

---

## 软件要求

- **SDK版本**: YTM32B1LE1_1_4_0 或更高版本
- **配置工具版本**: YCT v2.6.6 或更高版本

---

## EVB硬件设置

以下表格是例程中使用到的外部引脚配置：

|  引脚        |    功能       |
|  ------     |    -----      |
|  PTC9       |    UART1_TX   |
|  PTC8       |    UART1_RX   |

以下表格是EVB硬件连接设置，左端和右端短接：

|  左端        |    右端       |     描述       |
|  ------      |    -----     |     -----      |
|  J1-2        |    5VUSB     |     USB 5V供电  |
|  J2-2        |    5V        |     VDD 5V      |
|  J3-1        |    J3-2      |     单片机工作   |
|  J4-1        |    J4-2      |     VDDA 5V     |
|  J22-3       |    J22-4     |     UART1接收   |
|  J22-5       |    J22-6     |     UART1发送   |

---

## 功能描述

该例程展示了如何操作Flash。
1. Flash需要先调用 FLASH_DRV_Init() 进行初始化。
2. 先调用了 FLASH_DRV_EraseSector() 函数擦除指定的扇区。
3. 再调用 FLASH_DRV_Program() 对指定位置进行编程。
4. 最后再通过指针读取方式回读数据进行了验证。
---

## 注意事项
1. 调用 FLASH_DRV_Program() 函数时，需要确保要写入的地址中数据是全FF的。
2. FLASH_DRV_EraseSector() 参数地址必须是扇区的整数倍。
3. FLASH_DRV_Program() 参数地址和大小必须是FEATURE_EFM_WRITE_UNIT_SIZE的整数倍，pData参数必须4字节对齐。