# Flash_Demo

---

## Hardware Requirements

- **EVB**: YTM32B1LE1-EVB-Q48

---

## Software Requirements

- **SDK Version**: YTM32B1LE1_1_4_0 or later version
- **Config Tool Version**: YCT v2.6.6 or later version

---

## Hardware Setup on EVB

The following table shows the pin configuration of demo:

|  Pin        |    Function   |
|  ------     |    -----      |
|  PTC9       |    UART1_TX   |
|  PTC8       |    UART1_RX   |

The following table shows the hardware connection on EVB, short-L is connected to short-R:

|  Short-L     |    Short-R   |      Description     |
|  ------      |    -----     |      -----           |
|  J1-2        |    5VUSB     |      USB 5V supply   |
|  J2-2        |    5V        |      VDD 5V          |
|  J3-1        |    J3-2      |      MCU work        |
|  J4-1        |    J4-2      |      VDDA 5V         |
|  J22-3       |    J22-4     |      UART1 RXD       |
|  J22-5       |    J22-6     |      UART1 TXD       |

---

## Function Description

This routine shows how to manipulate Flash.
1. Flash needs to be initialized by calling FLASH_DRV_Init() first.
2. The FLASH_DRV_EraseSector() function is called first to erase the specified sector.
3. Then call FLASH_DRV_Program() to program the specified location.
4. This was finally verified by reading the data back through the pointer read method.
---

## Notes
1. When calling the FLASH_DRV_Program() function, you need to make sure that the data in the address to be written is full FF.
2. The FLASH_DRV_EraseSector() parameter address must be an integer multiple of the sector.
3. The FLASH_DRV_Program() parameter address and size must be an integer multiple of FEATURE_EFM_WRITE_UNIT_SIZE and the pData parameter must be 4-byte aligned.
