/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "printf.h"
#include "fls_drv_bin.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define FLASH_INST (0U)
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    uint32_t fls_version;
    uint32_t addr;
    uint32_t data[6 * 1024 / 4];
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    PRINTF("Build %s %s\n", __DATE__, __TIME__);
    PRINTF("Flash Demo!\r\n");

    status = FLASH_DRV_Init();
    if (status != STATUS_SUCCESS)
    {
        PRINTF("Flash init failed!\r\n");
        return status;
    }

    fls_version = FLASH_DRV_GetVersion();
    PRINTF("Flash version: %x\r\n", fls_version);

    PRINTF("Checking program flash 0!\r\n");
    /* Erase 4K from 0x207D000 to 0x207DFFF */
    status = FLASH_DRV_EraseSector(0x207D000, 4 * 1024);
    if (status != STATUS_SUCCESS)
    {
        PRINTF("Erase sector failed!\r\n");
        return status;
    }
    
    /* Write 4K from 0x207D000 to 0x207DFFF */
    for (uint32_t i = 0; i < 1024; i++)
    {
        data[i] = 0x207D000 + i * 4;
    }
    status = FLASH_DRV_Program(0x207D000, 4 * 1024, data);
    if (status != STATUS_SUCCESS)
    {
        PRINTF("Program failed!\r\n");
        return status;
    }
    for (addr = 0x207D000; addr < 0x207E000; addr += 4)
    {
        if (*(uint32_t *)addr != addr)
        {
            PRINTF("Address %x program failed!\r\n", addr);
        }
    }

    PRINTF("Checking program flash 1!\r\n");
    /* When accessing block 1, if code running in block 0, no need to disable global interrupt */
    FLASH_DRV_EraseSector(0x02100000, 6 * 1024);
    /* Write 6K from 0x02100000 to 0x02101800 */
    for (uint32_t i = 0; i < 6 * 1024 / 4; i++)
    {
        data[i] = 0x02100000 + i * 4;
    }
    FLASH_DRV_Program(0x02100000, 6 * 1024, data);
    for (addr = 0x02100000; addr < 0x02101800; addr += 4)
    {
        if (*(uint32_t *)addr != addr)
        {
            PRINTF("Address %x program failed!\r\n", addr);
        }
    }

    PRINTF("Checking data flash!\r\n");
    /* When accessing data flash, if code running in program flash, no need to disable global interrupt */
    FLASH_DRV_EraseSector(0x06000000, 0x400);
    /* Write 1K from 0x06000000 to 0x06000400 */
    for (uint32_t i = 0; i < 6 * 1024 / 4; i++)
    {
        data[i] = 0x06000000 + i * 4;
    }
    FLASH_DRV_Program(0x06000000, 0x400, data);
    for (addr = 0x06000000; addr < 0x06000400; addr += 4)
    {
        if (*(uint32_t *)addr != addr)
        {
            PRINTF("Address %x program failed!\r\n", addr);
        }
    }
    PRINTF("Flash check finished.\n");

    // FLASH_DRV_BootSwap();
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    return status;
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    UTILITY_PRINT_Init();
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
