/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file yt_linker.ld
 * @brief 
 * 
 */















/* MEMORY MAP */
MEMORY
{
    BOOT   (RX) : ORIGIN = 0x2000000, LENGTH = 0x8000
    IVT   (RX) : ORIGIN = 0x2008000, LENGTH = 0x3E0
    BVT   (RX) : ORIGIN = 0x20083e0, LENGTH = 0xA0
    TEXT   (RX) : ORIGIN = 0x2008480, LENGTH = 0x01F7B80
    IVT_RAM   (RW) : ORIGIN = 0x0, LENGTH = 0x400
    CODE_RAM   (RW) : ORIGIN = 0x400, LENGTH = 0x7C00
    STACK   (RW) : ORIGIN = 0x20000000, LENGTH = 0x10000
    FBL_VAR   (RW) : ORIGIN = 0x20020000, LENGTH = 0x10
    RAM   (RW) : ORIGIN = 0x20020010, LENGTH = 0x3FFF0
}
/* SECTIONS */
SECTIONS
{
    .IVT  : {
        
        . = ALIGN(32);
        IVT_start = .;
        isr_vector_region_start = .;
        KEEP(*(.isr_vector))
        isr_vector_region_end = .;
        
        . = ALIGN(32);
        IVT_end = .;
    } > IVT
   
    


    .BVT  : {
        
        . = ALIGN(32);
        BVT_start = .;
        . = ALIGN(4);
        bvt_header_region_start = .;
        KEEP(*(.bvt_header))
        bvt_header_region_end = .;
        
        . = ALIGN(4);
        sb_config_group_region_start = .;
        KEEP(*(.sb_config_group))
        sb_config_group_region_end = .;
        
        . = ALIGN(16);
        sb_config_section_region_start = .;
        KEEP(*(.sb_config_section))
        sb_config_section_region_end = .;
        
        . = ALIGN(16);
        sb_cmac_region_start = .;
        KEEP(*(.sb_cmac))
        sb_cmac_region_end = .;
        
        . = ALIGN(32);
        BVT_end = .;
    } > BVT
   
    


    .TEXT  : {
        
        . = ALIGN(32);
        TEXT_start = .;
        . = ALIGN(32);
        rodata_region_start = .;
        *(.rodata)
        *(.rodata*)
        rodata_region_end = .;
        
        . = ALIGN(32);
        text_region_start = .;
        *(.text)
        *(.text*)
        text_region_end = .;
        
        . = ALIGN(32);
        TEXT_end = .;
    } > TEXT
   
    


    .ARM  : {
        
        ARM_start = .;
        . = ALIGN(8);
        ARM.exidx_region_start = .;
        *(.ARM.exidx)
        *(.ARM.exidx*)
        ARM.exidx_region_end = .;
        
        ARM_end = .;
    } > TEXT
   
    


    CODE_RAM_rom_start_not_align = .;
    CODE_RAM_rom_start = CODE_RAM_rom_start_not_align + (CODE_RAM_rom_start_not_align % 8);
   
    CODE_RAM_rom_end = CODE_RAM_rom_start + CODE_RAM_ram_end - CODE_RAM_ram_start;
    


    DATA_RAM_rom_start_not_align = CODE_RAM_rom_end;
    DATA_RAM_rom_start = DATA_RAM_rom_start_not_align + (DATA_RAM_rom_start_not_align % 8);
   
    DATA_RAM_rom_end = DATA_RAM_rom_start + DATA_RAM_ram_end - DATA_RAM_ram_start;
    


    .IVT_RAM  : {
        
        . = ALIGN(1024);
        IVT_RAM_start = .;
        . += 0x400;
        IVT_RAM_end = .;
    } > IVT_RAM
   
    


    .CODE_RAM  : AT(CODE_RAM_rom_start) {
        
        CODE_RAM_ram_start = .;
        CODE_RAM_start = .;
        . = ALIGN(4);
        code_ram_region_start = .;
        *(.code_ram)
        code_ram_region_end = .;
        
        CODE_RAM_end = .;
        CODE_RAM_ram_end = .;
    } > CODE_RAM
   
    
    ASSERT((CODE_RAM_ram_end - CODE_RAM_ram_start) == (CODE_RAM_rom_end - CODE_RAM_rom_start), "Copy Section CODE_RAM Size non-aligned")


    .STACK  : {
        
        . = ALIGN(8);
        STACK_start = .;
        . += 0x10000;
        . = ALIGN(8);
        STACK_end = .;
    } > STACK
   
    


    .FBL_VAR  (NOLOAD): {
        
        . = ALIGN(8);
        FBL_VAR_start = .;
        fbl_bss_region_start = .;
        *(.fbl_bss)
        fbl_bss_region_end = .;
        
        . = ALIGN(8);
        FBL_VAR_end = .;
    } > FBL_VAR
   
    


    .BSS  (NOLOAD): {
        
        BSS_start = .;
        bss_region_start = .;
        *(.bss)
        *(.bss*)
        bss_region_end = .;
        
        BSS_end = .;
    } > RAM
   
    


    .DATA_RAM  : AT(DATA_RAM_rom_start) {
        
        . = ALIGN(4);
        DATA_RAM_ram_start = .;
        DATA_RAM_start = .;
        data_region_start = .;
        *(.data)
        *(.data*)
        data_region_end = .;
        
        . = ALIGN(4);
        DATA_RAM_end = .;
        DATA_RAM_ram_end = .;
    } > RAM
   
    
    ASSERT((DATA_RAM_ram_end - DATA_RAM_ram_start) == (DATA_RAM_rom_end - DATA_RAM_rom_start), "Copy Section DATA_RAM Size non-aligned")


    BOOT_memory_start = ORIGIN(BOOT);
    BOOT_memory_end = ORIGIN(BOOT) + LENGTH(BOOT);
    BOOT_memory_size = LENGTH(BOOT);
    IVT_memory_start = ORIGIN(IVT);
    IVT_memory_end = ORIGIN(IVT) + LENGTH(IVT);
    IVT_memory_size = LENGTH(IVT);
    BVT_memory_start = ORIGIN(BVT);
    BVT_memory_end = ORIGIN(BVT) + LENGTH(BVT);
    BVT_memory_size = LENGTH(BVT);
    TEXT_memory_start = ORIGIN(TEXT);
    TEXT_memory_end = ORIGIN(TEXT) + LENGTH(TEXT);
    TEXT_memory_size = LENGTH(TEXT);
    IVT_RAM_memory_start = ORIGIN(IVT_RAM);
    IVT_RAM_memory_end = ORIGIN(IVT_RAM) + LENGTH(IVT_RAM);
    IVT_RAM_memory_size = LENGTH(IVT_RAM);
    CODE_RAM_memory_start = ORIGIN(CODE_RAM);
    CODE_RAM_memory_end = ORIGIN(CODE_RAM) + LENGTH(CODE_RAM);
    CODE_RAM_memory_size = LENGTH(CODE_RAM);
    STACK_memory_start = ORIGIN(STACK);
    STACK_memory_end = ORIGIN(STACK) + LENGTH(STACK);
    STACK_memory_size = LENGTH(STACK);
    FBL_VAR_memory_start = ORIGIN(FBL_VAR);
    FBL_VAR_memory_end = ORIGIN(FBL_VAR) + LENGTH(FBL_VAR);
    FBL_VAR_memory_size = LENGTH(FBL_VAR);
    RAM_memory_start = ORIGIN(RAM);
    RAM_memory_end = ORIGIN(RAM) + LENGTH(RAM);
    RAM_memory_size = LENGTH(RAM);
}